/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.PropertyHelper;
import org.apache.synapse.mediators.ext.ClassMediator;

public class ClassMediatorFactory
extends AbstractMediatorFactory {
    private static final QName CLASS_Q = new QName("http://ws.apache.org/ns/synapse", "class");

    public Mediator createMediator(OMElement elem) {
        ClassMediator classMediator = new ClassMediator();
        OMAttribute name = elem.getAttribute(ATT_NAME);
        if (name == null) {
            String msg = "The name of the actual mediator class is a required attribute";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        Class<?> clazz = null;
        Mediator m = null;
        try {
            clazz = this.getClass().getClassLoader().loadClass(name.getAttributeValue());
            m = (Mediator)clazz.newInstance();
        }
        catch (Exception e) {
            String msg = "Error : " + name.getAttributeValue();
            log.error((Object)msg, (Throwable)e);
            throw new SynapseException(msg, e);
        }
        Iterator it = elem.getChildrenWithName(PROP_Q);
        while (it.hasNext()) {
            OMElement child = (OMElement)it.next();
            String propName = child.getAttribute(ATT_NAME).getAttributeValue();
            if (propName == null) {
                this.handleException("A Class mediator property must specify the name attribute");
                continue;
            }
            if (child.getAttribute(ATT_VALUE) != null) {
                String value = child.getAttribute(ATT_VALUE).getAttributeValue();
                classMediator.addProperty(propName, value);
                PropertyHelper.setInstanceProperty(propName, value, m);
                continue;
            }
            OMElement omElt = child.getFirstElement();
            if (omElt != null) {
                classMediator.addProperty(propName, omElt);
                PropertyHelper.setInstanceProperty(propName, omElt, m);
                continue;
            }
            this.handleException("A Class mediator property must specify name and value attributes, or a name and a child XML fragment");
        }
        classMediator.setMediator(m);
        this.processTraceState(classMediator, elem);
        return classMediator;
    }

    public QName getTagQName() {
        return CLASS_Q;
    }
}

