/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.SequenceMediatorSerializer;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.mediators.eip.aggregator.AggregateMediator;

public class AggregateMediatorSerializer
extends AbstractMediatorSerializer {
    private static final Log log = LogFactory.getLog(AggregateMediatorSerializer.class);

    public OMElement serializeMediator(OMElement parent, Mediator m) {
        if (!(m instanceof AggregateMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        AggregateMediator mediator = (AggregateMediator)m;
        OMElement aggregator = fac.createOMElement("aggregate", synNS);
        AggregateMediatorSerializer.saveTracingState(aggregator, mediator);
        if (mediator.getCorrelateExpression() != null) {
            OMElement corelateOn = fac.createOMElement("correlateOn", synNS);
            SynapseXPathSerializer.serializeXPath(mediator.getCorrelateExpression(), corelateOn, "expression");
            aggregator.addChild((OMNode)corelateOn);
        }
        OMElement completeCond = fac.createOMElement("completeCondition", synNS);
        if (mediator.getCompletionTimeoutMillis() != 0L) {
            completeCond.addAttribute("timeout", Long.toString(mediator.getCompletionTimeoutMillis() / 1000L), nullNS);
        }
        OMElement messageCount = fac.createOMElement("messageCount", synNS);
        if (mediator.getMinMessagesToComplete() != 0) {
            messageCount.addAttribute("min", Integer.toString(mediator.getMinMessagesToComplete()), nullNS);
        }
        if (mediator.getMaxMessagesToComplete() != 0) {
            messageCount.addAttribute("max", Integer.toString(mediator.getMaxMessagesToComplete()), nullNS);
        }
        completeCond.addChild((OMNode)messageCount);
        aggregator.addChild((OMNode)completeCond);
        OMElement onCompleteElem = fac.createOMElement("onComplete", synNS);
        if (mediator.getAggregationExpression() != null) {
            SynapseXPathSerializer.serializeXPath(mediator.getAggregationExpression(), onCompleteElem, "expression");
        }
        if (mediator.getOnCompleteSequenceRef() != null) {
            onCompleteElem.addAttribute("sequence", mediator.getOnCompleteSequenceRef(), nullNS);
        } else if (mediator.getOnCompleteSequence() != null) {
            new SequenceMediatorSerializer().serializeChildren(onCompleteElem, mediator.getOnCompleteSequence().getList());
        }
        aggregator.addChild((OMNode)onCompleteElem);
        if (parent != null) {
            parent.addChild((OMNode)aggregator);
        }
        return aggregator;
    }

    public String getMediatorClassName() {
        return AggregateMediator.class.getName();
    }
}

