/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.SequenceMediatorFactory;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.builtin.DropMediator;
import org.apache.synapse.mediators.eip.aggregator.AggregateMediator;
import org.jaxen.JaxenException;

public class AggregateMediatorFactory
extends AbstractMediatorFactory {
    private static final Log log = LogFactory.getLog(AggregateMediatorFactory.class);
    private static final QName AGGREGATE_Q = new QName("http://ws.apache.org/ns/synapse", "aggregate");
    private static final QName CORELATE_ON_Q = new QName("http://ws.apache.org/ns/synapse", "correlateOn");
    private static final QName COMPLETE_CONDITION_Q = new QName("http://ws.apache.org/ns/synapse", "completeCondition");
    private static final QName MESSAGE_COUNT_Q = new QName("http://ws.apache.org/ns/synapse", "messageCount");
    private static final QName ON_COMPLETE_Q = new QName("http://ws.apache.org/ns/synapse", "onComplete");
    private static final QName EXPRESSION_Q = new QName("", "expression");
    private static final QName TIMEOUT_Q = new QName("", "timeout");
    private static final QName MIN_Q = new QName("", "min");
    private static final QName MAX_Q = new QName("", "max");
    private static final QName SEQUENCE_Q = new QName("", "sequence");

    public Mediator createMediator(OMElement elem) {
        OMElement onComplete;
        OMElement completeCond;
        OMAttribute corelateExpr;
        AggregateMediator mediator = new AggregateMediator();
        this.processTraceState(mediator, elem);
        OMElement corelateOn = elem.getFirstChildWithName(CORELATE_ON_Q);
        if (corelateOn != null && (corelateExpr = corelateOn.getAttribute(EXPRESSION_Q)) != null) {
            try {
                mediator.setCorrelateExpression(SynapseXPathFactory.getSynapseXPath(corelateOn, EXPRESSION_Q));
            }
            catch (JaxenException e) {
                this.handleException("Unable to load the corelate XPATH expression", (Exception)((Object)e));
            }
        }
        if ((completeCond = elem.getFirstChildWithName(COMPLETE_CONDITION_Q)) != null) {
            OMElement messageCount;
            OMAttribute completeTimeout = completeCond.getAttribute(TIMEOUT_Q);
            if (completeTimeout != null) {
                mediator.setCompletionTimeoutMillis(Long.parseLong(completeTimeout.getAttributeValue()) * 1000L);
            }
            if ((messageCount = completeCond.getFirstChildWithName(MESSAGE_COUNT_Q)) != null) {
                OMAttribute max;
                OMAttribute min = messageCount.getAttribute(MIN_Q);
                if (min != null) {
                    mediator.setMinMessagesToComplete(Integer.parseInt(min.getAttributeValue()));
                }
                if ((max = messageCount.getAttribute(MAX_Q)) != null) {
                    mediator.setMaxMessagesToComplete(Integer.parseInt(max.getAttributeValue()));
                }
            }
        }
        if ((onComplete = elem.getFirstChildWithName(ON_COMPLETE_Q)) != null) {
            OMAttribute onCompleteSequence;
            OMAttribute aggregateExpr = onComplete.getAttribute(EXPRESSION_Q);
            if (aggregateExpr != null) {
                try {
                    mediator.setAggregationExpression(SynapseXPathFactory.getSynapseXPath(onComplete, EXPRESSION_Q));
                }
                catch (JaxenException e) {
                    this.handleException("Unable to load the aggregating XPATH", (Exception)((Object)e));
                }
            }
            if ((onCompleteSequence = onComplete.getAttribute(SEQUENCE_Q)) != null) {
                mediator.setOnCompleteSequenceRef(onCompleteSequence.getAttributeValue());
            } else if (onComplete.getFirstElement() != null) {
                mediator.setOnCompleteSequence(new SequenceMediatorFactory().createAnonymousSequence(onComplete));
            } else {
                SequenceMediator sequence = new SequenceMediator();
                sequence.addChild(new DropMediator());
                mediator.setOnCompleteSequence(sequence);
            }
        }
        return mediator;
    }

    public QName getTagQName() {
        return AGGREGATE_Q;
    }
}

