/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.MediatorFactory;

public abstract class AbstractMediatorFactory
implements MediatorFactory {
    protected static Log log;
    protected static final QName ATT_NAME;
    protected static final QName ATT_VALUE;
    protected static final QName ATT_XPATH;
    protected static final QName ATT_REGEX;
    protected static final QName ATT_SEQUENCE;
    protected static final QName ATT_EXPRN;
    protected static final QName ATT_KEY;
    protected static final QName ATT_SOURCE;
    protected static final QName ATT_TARGET;
    protected static final QName ATT_ONERROR;
    protected static final QName ATT_STATS;
    protected static final QName PROP_Q;
    protected static final QName FEATURE_Q;
    protected static final QName TARGET_Q;

    protected AbstractMediatorFactory() {
        log = LogFactory.getLog(this.getClass());
    }

    protected void processTraceState(Mediator mediator, OMElement mediatorOmElement) {
        String traceValue;
        OMAttribute trace = mediatorOmElement.getAttribute(new QName("", "trace"));
        if (trace != null && (traceValue = trace.getAttributeValue()) != null) {
            if (traceValue.equals("enable")) {
                mediator.setTraceState(1);
            } else if (traceValue.equals("disable")) {
                mediator.setTraceState(0);
            }
        }
    }

    protected void handleException(String message, Exception e) {
        LogFactory.getLog(this.getClass()).error((Object)message, (Throwable)e);
        throw new SynapseException(message, e);
    }

    protected void handleException(String message) {
        LogFactory.getLog(this.getClass()).error((Object)message);
        throw new SynapseException(message);
    }

    static {
        ATT_NAME = new QName("name");
        ATT_VALUE = new QName("value");
        ATT_XPATH = new QName("xpath");
        ATT_REGEX = new QName("regex");
        ATT_SEQUENCE = new QName("sequence");
        ATT_EXPRN = new QName("expression");
        ATT_KEY = new QName("key");
        ATT_SOURCE = new QName("source");
        ATT_TARGET = new QName("target");
        ATT_ONERROR = new QName("onError");
        ATT_STATS = new QName("statistics");
        PROP_Q = new QName("http://ws.apache.org/ns/synapse", "property");
        FEATURE_Q = new QName("http://ws.apache.org/ns/synapse", "feature");
        TARGET_Q = new QName("http://ws.apache.org/ns/synapse", "target");
    }
}

