/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.mediators.db.AbstractDBMediator;
import org.apache.synapse.mediators.db.Statement;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public abstract class AbstractDBMediatorFactory
extends AbstractMediatorFactory {
    public static final QName URL_Q = new QName("http://ws.apache.org/ns/synapse", "url");
    static final QName DRIVER_Q = new QName("http://ws.apache.org/ns/synapse", "driver");
    static final QName USER_Q = new QName("http://ws.apache.org/ns/synapse", "user");
    static final QName PASS_Q = new QName("http://ws.apache.org/ns/synapse", "password");
    static final QName DSNAME_Q = new QName("http://ws.apache.org/ns/synapse", "dsName");
    static final QName ICCLASS_Q = new QName("http://ws.apache.org/ns/synapse", "icClass");
    static final QName STMNT_Q = new QName("http://ws.apache.org/ns/synapse", "statement");
    static final QName SQL_Q = new QName("http://ws.apache.org/ns/synapse", "sql");
    static final QName PARAM_Q = new QName("http://ws.apache.org/ns/synapse", "parameter");
    static final QName RESULT_Q = new QName("http://ws.apache.org/ns/synapse", "result");
    static final QName ATT_COLUMN = new QName("column");
    static final QName ATT_TYPE = new QName("type");

    protected void buildDataSource(OMElement elem, AbstractDBMediator mediator) {
        OMElement pool = null;
        try {
            SynapseXPath xpath = new SynapseXPath("self::node()/syn:connection/syn:pool");
            xpath.addNamespace("syn", "http://ws.apache.org/ns/synapse");
            pool = (OMElement)xpath.selectSingleNode(elem);
            if (pool.getFirstChildWithName(DRIVER_Q) != null) {
                mediator.setDataSource(this.createCustomDataSource(pool, mediator));
            } else if (pool.getFirstChildWithName(ICCLASS_Q) != null && pool.getFirstChildWithName(DSNAME_Q) != null) {
                mediator.setDataSource(this.lookupDataSource(pool, mediator));
            } else {
                this.handleException("The DataSource connection information must be specified for using a custom DataSource connection pool or for a JNDI lookup");
            }
        }
        catch (JaxenException e) {
            this.handleException("Error looking up DataSource connection information", (Exception)((Object)e));
        }
    }

    private DataSource lookupDataSource(OMElement pool, AbstractDBMediator mediator) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.factory.initial", this.getValue(pool, ICCLASS_Q));
        props.put("java.naming.security.principal", this.getValue(pool, USER_Q));
        props.put("java.naming.security.credentials", this.getValue(pool, PASS_Q));
        props.put("java.naming.provider.url", this.getValue(pool, URL_Q));
        String dsName = this.getValue(pool, DSNAME_Q);
        mediator.addDataSourceProperty(ICCLASS_Q, this.getValue(pool, ICCLASS_Q));
        mediator.addDataSourceProperty(DSNAME_Q, this.getValue(pool, DSNAME_Q));
        mediator.addDataSourceProperty(URL_Q, this.getValue(pool, URL_Q));
        mediator.addDataSourceProperty(USER_Q, this.getValue(pool, USER_Q));
        mediator.addDataSourceProperty(PASS_Q, this.getValue(pool, PASS_Q));
        try {
            InitialContext ctx = new InitialContext(props);
            Object ds = ctx.lookup(dsName);
            if (ds != null && ds instanceof DataSource) {
                return (DataSource)ds;
            }
            this.handleException("DataSource : " + dsName + " not found when looking up" + " using JNDI properties : " + props);
        }
        catch (NamingException e) {
            this.handleException("Error looking up DataSource : " + dsName + " using JNDI properties : " + props, e);
        }
        return null;
    }

    private DataSource createCustomDataSource(OMElement pool, AbstractDBMediator mediator) {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(this.getValue(pool, DRIVER_Q));
        ds.setUsername(this.getValue(pool, USER_Q));
        ds.setPassword(this.getValue(pool, PASS_Q));
        ds.setUrl(this.getValue(pool, URL_Q));
        mediator.addDataSourceProperty(DRIVER_Q, this.getValue(pool, DRIVER_Q));
        mediator.addDataSourceProperty(URL_Q, this.getValue(pool, URL_Q));
        mediator.addDataSourceProperty(USER_Q, this.getValue(pool, USER_Q));
        mediator.addDataSourceProperty(PASS_Q, this.getValue(pool, PASS_Q));
        Iterator props = pool.getChildrenWithName(PROP_Q);
        while (props.hasNext()) {
            OMElement prop = (OMElement)props.next();
            String name = prop.getAttribute(ATT_NAME).getAttributeValue();
            String value = prop.getAttribute(ATT_VALUE).getAttributeValue();
            mediator.addDataSourceProperty(name, value);
            if ("autocommit".equals(name)) {
                if ("true".equals(value)) {
                    ds.setDefaultAutoCommit(true);
                    continue;
                }
                if (!"false".equals(value)) continue;
                ds.setDefaultAutoCommit(false);
                continue;
            }
            if ("isolation".equals(name)) {
                try {
                    if ("Connection.TRANSACTION_NONE".equals(value)) {
                        ds.setDefaultTransactionIsolation(0);
                        continue;
                    }
                    if ("Connection.TRANSACTION_READ_COMMITTED".equals(value)) {
                        ds.setDefaultTransactionIsolation(2);
                        continue;
                    }
                    if ("Connection.TRANSACTION_READ_UNCOMMITTED".equals(value)) {
                        ds.setDefaultTransactionIsolation(1);
                        continue;
                    }
                    if ("Connection.TRANSACTION_REPEATABLE_READ".equals(value)) {
                        ds.setDefaultTransactionIsolation(4);
                        continue;
                    }
                    if (!"Connection.TRANSACTION_SERIALIZABLE".equals(value)) continue;
                    ds.setDefaultTransactionIsolation(8);
                }
                catch (NumberFormatException ignore) {}
                continue;
            }
            if ("initialsize".equals(name)) {
                try {
                    ds.setInitialSize(Integer.parseInt(value));
                }
                catch (NumberFormatException ignore) {}
                continue;
            }
            if ("maxactive".equals(name)) {
                try {
                    ds.setMaxActive(Integer.parseInt(value));
                }
                catch (NumberFormatException ignore) {}
                continue;
            }
            if ("maxidle".equals(name)) {
                try {
                    ds.setMaxIdle(Integer.parseInt(value));
                }
                catch (NumberFormatException ignore) {}
                continue;
            }
            if ("maxopenstatements".equals(name)) {
                try {
                    ds.setMaxOpenPreparedStatements(Integer.parseInt(value));
                }
                catch (NumberFormatException ignore) {}
                continue;
            }
            if ("maxwait".equals(name)) {
                try {
                    ds.setMaxWait(Long.parseLong(value));
                }
                catch (NumberFormatException ignore) {}
                continue;
            }
            if ("minidle".equals(name)) {
                try {
                    ds.setMinIdle(Integer.parseInt(value));
                }
                catch (NumberFormatException ignore) {}
                continue;
            }
            if ("poolstatements".equals(name)) {
                if ("true".equals(value)) {
                    ds.setPoolPreparedStatements(true);
                    continue;
                }
                if (!"false".equals(value)) continue;
                ds.setPoolPreparedStatements(false);
                continue;
            }
            if ("testonborrow".equals(name)) {
                if ("true".equals(value)) {
                    ds.setTestOnBorrow(true);
                    continue;
                }
                if (!"false".equals(value)) continue;
                ds.setTestOnBorrow(false);
                continue;
            }
            if ("testonreturn".equals(name)) {
                if ("true".equals(value)) {
                    ds.setTestOnReturn(true);
                    continue;
                }
                if (!"false".equals(value)) continue;
                ds.setTestOnReturn(false);
                continue;
            }
            if ("testwhileidle".equals(name)) {
                if ("true".equals(value)) {
                    ds.setTestWhileIdle(true);
                    continue;
                }
                if (!"false".equals(value)) continue;
                ds.setTestWhileIdle(false);
                continue;
            }
            if (!"validationquery".equals(name)) continue;
            ds.setValidationQuery(value);
        }
        return ds;
    }

    protected void processStatements(OMElement elem, AbstractDBMediator mediator) {
        Iterator iter = elem.getChildrenWithName(STMNT_Q);
        while (iter.hasNext()) {
            OMElement stmntElt = (OMElement)iter.next();
            Statement statement = new Statement(this.getValue(stmntElt, SQL_Q));
            Iterator paramIter = stmntElt.getChildrenWithName(PARAM_Q);
            while (paramIter.hasNext()) {
                OMElement paramElt = (OMElement)paramIter.next();
                String xpath = this.getAttribute(paramElt, ATT_EXPRN);
                String value = this.getAttribute(paramElt, ATT_VALUE);
                if (xpath == null && value == null) continue;
                SynapseXPath xp = null;
                if (xpath != null) {
                    try {
                        xp = SynapseXPathFactory.getSynapseXPath(paramElt, ATT_EXPRN);
                    }
                    catch (JaxenException e) {
                        this.handleException("Invalid XPath specified for the source attribute : " + xpath);
                    }
                }
                statement.addParameter(value, xp, this.getAttribute(paramElt, ATT_TYPE));
            }
            Iterator resultIter = stmntElt.getChildrenWithName(RESULT_Q);
            while (resultIter.hasNext()) {
                OMElement resultElt = (OMElement)resultIter.next();
                statement.addResult(this.getAttribute(resultElt, ATT_NAME), this.getAttribute(resultElt, ATT_COLUMN));
            }
            mediator.addStatement(statement);
        }
    }

    protected String getValue(OMElement elt, QName qName) {
        OMElement e = elt.getFirstChildWithName(qName);
        if (e != null) {
            return e.getText();
        }
        this.handleException("Unable to read configuration value for : " + qName);
        return null;
    }

    protected String getAttribute(OMElement elt, QName qName) {
        OMAttribute a = elt.getAttribute(qName);
        if (a != null) {
            return a.getAttributeValue();
        }
        return null;
    }
}

