/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.XMLConfigurationBuilder;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.builtin.DropMediator;
import org.apache.synapse.mediators.builtin.LogMediator;
import org.apache.synapse.util.DataSourceRegistrar;

public class SynapseConfigurationBuilder {
    private static Log log = LogFactory.getLog(SynapseConfigurationBuilder.class);

    public static SynapseConfiguration getDefaultConfiguration() {
        SynapseConfiguration config = new SynapseConfiguration();
        SequenceMediator mainmediator = new SequenceMediator();
        mainmediator.addChild(new LogMediator());
        mainmediator.addChild(new DropMediator());
        config.addSequence("main", mainmediator);
        SequenceMediator faultmediator = new SequenceMediator();
        LogMediator fault = new LogMediator();
        fault.setLogLevel(3);
        faultmediator.addChild(fault);
        config.addSequence("fault", faultmediator);
        return config;
    }

    public static SynapseConfiguration getConfiguration(String configFile) {
        try {
            Properties synapseProperties = SynapseConfigurationBuilder.loadSynapseProperties();
            DataSourceRegistrar.registerDataSources(synapseProperties);
            SynapseConfiguration synCfg = XMLConfigurationBuilder.getConfiguration(new FileInputStream(configFile));
            log.info((Object)("Loaded Synapse configuration from : " + configFile));
            synCfg.setPathToConfigFile(new File(configFile).getAbsolutePath());
            synCfg.setProperties(synapseProperties);
            return synCfg;
        }
        catch (FileNotFoundException fnf) {
            SynapseConfigurationBuilder.handleException("Cannot load Synapse configuration from : " + configFile, fnf);
        }
        catch (Exception e) {
            SynapseConfigurationBuilder.handleException("Could not initialize Synapse : " + e.getMessage(), e);
        }
        return null;
    }

    private static Properties loadSynapseProperties() {
        try {
            InputStream in;
            Properties properties = new Properties();
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (log.isDebugEnabled()) {
                log.debug((Object)"synapse.properties file is loading from classpath");
            }
            if ((in = cl.getResourceAsStream("synapse.properties")) == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Unable to load synapse.propeties file");
                }
                String path = "conf" + File.separatorChar + "synapse.properties";
                if (log.isDebugEnabled()) {
                    log.debug((Object)("synapse.properties file is loading from classpath with resource path '" + path + " '"));
                }
                if ((in = cl.getResourceAsStream(path)) == null && log.isDebugEnabled()) {
                    log.debug((Object)("Unable to load the synapse.properties file from classpath with resource name '" + path + " '"));
                }
            }
            if (in != null) {
                properties.load(in);
            }
            return properties;
        }
        catch (Exception e) {
            log.info((Object)"Using the default tuning parameters for Synapse");
            return new Properties();
        }
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }
}

