/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerManager;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.XMLToObjectMapper;
import org.apache.synapse.util.SynapseBinaryDataSource;
import org.xml.sax.InputSource;

public class SynapseConfigUtils {
    private static final Log log = LogFactory.getLog(SynapseConfigUtils.class);

    public static StreamSource getStreamSource(Object o) {
        if (o == null) {
            SynapseConfigUtils.handleException("Cannot convert null to a StreamSource");
        } else if (o instanceof OMElement) {
            OMElement omElement = (OMElement)o;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                omElement.serialize((OutputStream)baos);
                return new StreamSource(new ByteArrayInputStream(baos.toByteArray()));
            }
            catch (XMLStreamException e) {
                SynapseConfigUtils.handleException("Error converting to a StreamSource", e);
            }
        } else if (o instanceof OMText) {
            DataHandler dataHandler = (DataHandler)((OMText)o).getDataHandler();
            if (dataHandler != null) {
                try {
                    return new StreamSource(dataHandler.getInputStream());
                }
                catch (IOException e) {
                    SynapseConfigUtils.handleException("Error in reading content as a stream ");
                }
            }
        } else {
            SynapseConfigUtils.handleException("Cannot convert object to a StreamSource");
        }
        return null;
    }

    public static InputStream getInputStream(Object o) {
        if (o == null) {
            SynapseConfigUtils.handleException("Cannot convert null to a StreamSource");
        } else if (o instanceof OMElement) {
            OMElement omElement = (OMElement)o;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                omElement.serialize((OutputStream)baos);
                return new ByteArrayInputStream(baos.toByteArray());
            }
            catch (XMLStreamException e) {
                SynapseConfigUtils.handleException("Error converting to a StreamSource", e);
            }
        } else if (o instanceof OMText) {
            DataHandler dataHandler = (DataHandler)((OMText)o).getDataHandler();
            if (dataHandler != null) {
                try {
                    return dataHandler.getInputStream();
                }
                catch (IOException e) {
                    SynapseConfigUtils.handleException("Error in reading content as a stream ");
                }
            }
        } else if (o instanceof URI) {
            try {
                return ((URI)o).toURL().openStream();
            }
            catch (IOException e) {
                SynapseConfigUtils.handleException("Error opening stream form URI", e);
            }
        } else {
            SynapseConfigUtils.handleException("Cannot convert object to a StreamSource");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object getObject(URL url) {
        try {
            OMNode oMNode;
            block23: {
                if (url != null && "file".equals(url.getProtocol())) {
                    try {
                        url.openStream();
                    }
                    catch (IOException ignored) {
                        String synapseHome;
                        String path = url.getPath();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Can not open a connection to the URL with a path :" + path));
                        }
                        if ((synapseHome = ServerManager.getInstance().getSynapseHome()) == null) break block23;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Trying  to resolve an absolute path of the  URL using the synapse.home : " + synapseHome));
                        }
                        if (synapseHome.endsWith("/")) {
                            synapseHome = synapseHome.substring(0, synapseHome.lastIndexOf("/"));
                        }
                        url = new URL(url.getProtocol() + ":" + synapseHome + "/" + path);
                        try {
                            url.openStream();
                        }
                        catch (IOException e) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Faild to resolve an absolute path of the  URL using the synapse.home : " + synapseHome));
                            }
                            log.warn((Object)("IO Error reading from URL " + url.getPath() + e));
                        }
                    }
                }
            }
            if (url == null) {
                return null;
            }
            URLConnection urlc = url.openConnection();
            XMLToObjectMapper xmlToObject = SynapseConfigUtils.getXmlToObjectMapper(urlc.getContentType());
            InputStream inputStream = urlc.getInputStream();
            try {
                XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
                StAXOMBuilder builder = new StAXOMBuilder(parser);
                OMElement omElem = builder.getDocumentElement();
                omElem.build();
                if (xmlToObject != null) {
                    Object object = xmlToObject.getObjectFromOMNode((OMNode)omElem);
                    return object;
                }
                OMElement oMElement = omElem;
                return oMElement;
            }
            catch (XMLStreamException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Content at URL : " + url + " is non XML.."));
                }
                oMNode = SynapseConfigUtils.readNonXML(url);
                return oMNode;
            }
            catch (OMException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Content at URL : " + url + " is non XML.."));
                }
                oMNode = SynapseConfigUtils.readNonXML(url);
                return oMNode;
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException e) {
            SynapseConfigUtils.handleException("Error connecting to URL : " + url, e);
            return null;
        }
    }

    public static OMNode readNonXML(URL url) {
        try {
            URLConnection newConnection = url.openConnection();
            BufferedInputStream newInputStream = new BufferedInputStream(newConnection.getInputStream());
            OMFactory omFactory = OMAbstractFactory.getOMFactory();
            return omFactory.createOMText((Object)new DataHandler((DataSource)new SynapseBinaryDataSource(newInputStream, newConnection.getContentType())), true);
        }
        catch (IOException e) {
            SynapseConfigUtils.handleException("Error when getting a stream from resource's content", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OMNode getOMElementFromURL(String urlStr) throws IOException {
        URL url = SynapseConfigUtils.getURLFromPath(urlStr);
        if (url == null) {
            return null;
        }
        URLConnection conn = url.openConnection();
        conn.setReadTimeout(SynapseConfigUtils.getReadTimeout());
        conn.setConnectTimeout(SynapseConfigUtils.getConnectionTimeout());
        conn.setRequestProperty("Connection", "close");
        BufferedInputStream urlInStream = new BufferedInputStream(conn.getInputStream());
        try {
            StAXOMBuilder builder = new StAXOMBuilder((InputStream)urlInStream);
            OMElement doc = builder.getDocumentElement();
            doc.build();
            OMElement oMElement = doc;
            return oMElement;
        }
        catch (Exception e) {
            OMNode content;
            if (log.isDebugEnabled()) {
                log.info((Object)("Content at URL : " + url + " is non XML.."));
            }
            if ((content = SynapseConfigUtils.readNonXML(url)) instanceof OMNode) {
                OMNode oMNode = content;
                return oMNode;
            }
        }
        finally {
            try {
                urlInStream.close();
            }
            catch (IOException ignore) {}
        }
        return null;
    }

    public static InputSource getInputSourceFormURI(URI uri) {
        if (uri == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Can not create a URL from 'null' ");
            }
            return null;
        }
        try {
            URL url = uri.toURL();
            String protocol = url.getProtocol();
            String path = url.getPath();
            if (protocol == null || "".equals(protocol)) {
                url = new URL("file:" + path);
            }
            URLConnection conn = url.openConnection();
            conn.setReadTimeout(SynapseConfigUtils.getReadTimeout());
            conn.setConnectTimeout(SynapseConfigUtils.getConnectionTimeout());
            conn.setRequestProperty("Connection", "close");
            BufferedInputStream urlInStream = new BufferedInputStream(conn.getInputStream());
            return new InputSource(urlInStream);
        }
        catch (MalformedURLException e) {
            SynapseConfigUtils.handleException("Invalid URL ' " + uri + " '", e);
        }
        catch (IOException e) {
            SynapseConfigUtils.handleException("Error reading at URI ' " + uri + " ' ", e);
        }
        return null;
    }

    private static int getReadTimeout() {
        return ServerManager.getInstance().getReadTimeout();
    }

    private static int getConnectionTimeout() {
        return ServerManager.getInstance().getConnectTimeout();
    }

    private static void handleException(String msg, Exception e) {
        log.warn((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    private static void handleException(String msg) {
        log.warn((Object)msg);
        throw new SynapseException(msg);
    }

    public static XMLToObjectMapper getXmlToObjectMapper(String contentType) {
        return null;
    }

    public static URL getURLFromPath(String path) {
        URL url;
        block15: {
            if (path == null || "null".equals(path)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Can not create a URL from 'null' ");
                }
                return null;
            }
            url = null;
            try {
                url = new URL(path);
                if (!"file".equals(url.getProtocol())) break block15;
                try {
                    url.openStream();
                }
                catch (MalformedURLException e) {
                    SynapseConfigUtils.handleException("Invalid URL reference : " + path, e);
                }
                catch (IOException ignored) {
                    String synapseHome;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Can not open a connection to the URL with a path :" + path));
                    }
                    if ((synapseHome = ServerManager.getInstance().getSynapseHome()) == null) break block15;
                    if (synapseHome.endsWith("/")) {
                        synapseHome = synapseHome.substring(0, synapseHome.lastIndexOf("/"));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Trying  to resolve an absolute path of the  URL using the synapse.home : " + synapseHome));
                    }
                    try {
                        url = new URL(url.getProtocol() + ":" + synapseHome + "/" + url.getPath());
                        url.openStream();
                    }
                    catch (MalformedURLException e) {
                        SynapseConfigUtils.handleException("Invalid URL reference " + url.getPath() + e);
                    }
                    catch (IOException e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Faild to resolve an absolute path of the  URL using the synapse.home : " + synapseHome));
                        }
                        log.warn((Object)("IO Error reading from URL : " + url.getPath() + e));
                    }
                }
            }
            catch (MalformedURLException e) {
                SynapseConfigUtils.handleException("Invalid URL reference :  " + path, e);
            }
            catch (IOException e) {
                SynapseConfigUtils.handleException("IO Error reading from URL : " + path, e);
            }
        }
        return url;
    }

    public static String resolveRelativeURI(String parentLocation, String relativeLocation) {
        if (relativeLocation == null) {
            throw new IllegalArgumentException("Import URI cannot be null");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resolving import URI ' " + parentLocation + " '  against base URI ' " + relativeLocation + " '  "));
        }
        URI importUri = null;
        try {
            importUri = new URI(relativeLocation);
            if (importUri.isAbsolute()) {
                return importUri.toString();
            }
        }
        catch (URISyntaxException e) {
            SynapseConfigUtils.handleException("Invalid URI : " + relativeLocation, e);
        }
        if (parentLocation == null) {
            return importUri.toString();
        }
        if (relativeLocation.startsWith("/") || relativeLocation.startsWith("\\")) {
            if (importUri != null && !importUri.isAbsolute()) {
                try {
                    importUri = new URI("file:" + relativeLocation);
                    return importUri.toString();
                }
                catch (URISyntaxException e) {
                    SynapseConfigUtils.handleException("Invalid URI ' " + importUri.getPath() + " '", e);
                }
            }
        } else {
            int index = parentLocation.lastIndexOf("/");
            if (index == -1) {
                index = parentLocation.lastIndexOf("\\");
            }
            if (index != -1) {
                String basepath = parentLocation.substring(0, index + 1);
                String resolvedPath = basepath + relativeLocation;
                try {
                    URI resolvedUri = new URI(resolvedPath);
                    if (!resolvedUri.isAbsolute()) {
                        resolvedUri = new URI("file:" + resolvedPath);
                    }
                    return resolvedUri.toString();
                }
                catch (URISyntaxException e) {
                    SynapseConfigUtils.handleException("Invalid URI ' " + resolvedPath + " '", e);
                }
            } else {
                return importUri.toString();
            }
        }
        return null;
    }
}

