/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerManager;

public class SynapseServer {
    private static final Log log = LogFactory.getLog(SynapseServer.class);
    private static final String USAGE_TXT = "Usage: SynapseServer <axis2_repository> <axis2_xml> <synapse_home> <synapse_xml> <resolve_root>\n Opts: -? this message";

    public static void printUsage() {
        System.out.println(USAGE_TXT);
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1 && args.length != 4 && args.length != 5 && args.length != 6) {
            SynapseServer.printUsage();
        }
        ServerManager serverManager = ServerManager.getInstance();
        serverManager.setAxis2Repolocation(args[0]);
        if (args.length == 1) {
            log.warn((Object)"Configuring server manager using deprecated system properties; please update your configuration");
            serverManager.setAxis2Xml(System.getProperty("axis2.xml"));
            serverManager.setSynapseHome(System.getProperty("synapse.home"));
            serverManager.setSynapseXMLPath(System.getProperty("synapse.xml"));
            serverManager.setResolveRoot(System.getProperty("resolve.root"));
        } else if (args.length == 4) {
            serverManager.setAxis2Xml(args[1]);
            serverManager.setSynapseHome(args[2]);
            serverManager.setSynapseXMLPath(args[3]);
            serverManager.setResolveRoot(args[2] + File.separator + "repository");
        } else if (args.length == 5) {
            serverManager.setAxis2Xml(args[1]);
            serverManager.setSynapseHome(args[2]);
            serverManager.setSynapseXMLPath(args[3]);
            serverManager.setResolveRoot(args[4]);
        } else if (args.length == 6) {
            serverManager.setAxis2Xml(args[1]);
            serverManager.setSynapseHome(args[2]);
            serverManager.setSynapseXMLPath(args[3]);
            serverManager.setResolveRoot(args[4]);
            serverManager.setServerName(args[5]);
        }
        serverManager.start();
        SynapseServer.addShutdownHook();
    }

    private static void addShutdownHook() {
        Thread shutdownHook = new Thread(){

            public void run() {
                log.info((Object)"Shutting down Apache Synapse ...");
                try {
                    ServerManager.getInstance().stop();
                    log.info((Object)"Shutdown complete");
                    log.info((Object)"Halting JVM");
                }
                catch (Exception e) {
                    log.warn((Object)("Error occurred while shutting down Apache Synapse : " + e));
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }
}

