/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse;

import java.io.File;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.ListenerManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Startup;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.format.BinaryBuilder;
import org.apache.synapse.format.PlainTextBuilder;
import org.apache.synapse.util.ClasspathURLStreamHandler;
import org.apache.synapse.util.RMIRegistryController;

public class ServerManager {
    private static final Log log = LogFactory.getLog(ServerManager.class);
    private static ServerManager instance = new ServerManager();
    private String axis2Repolocation;
    private String axis2Xml;
    private String synapseHome;
    private String synapseXMLPath;
    private String resolveRoot;
    private String serverName = "localhost";
    private ListenerManager listenerManager;
    private ConfigurationContext configctx;
    private SynapseConfiguration synConfig = null;
    private Map callbackStore = null;

    public static ServerManager getInstance() {
        return instance;
    }

    public void start() {
        this.validate();
        try {
            URL.setURLStreamHandlerFactory(new URLStreamHandlerFactoryImpl());
        }
        catch (Throwable t) {
            log.debug((Object)"Unable to register a URLStreamHandlerFactory - Custom URL protocols may not work properly (e.g. classpath://)");
        }
        try {
            this.configctx = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)this.axis2Repolocation, (String)this.axis2Xml);
            this.addDefaultBuildersAndFormatters(this.configctx.getAxisConfiguration());
            this.listenerManager = this.configctx.getListenerManager();
            if (this.listenerManager == null) {
                this.listenerManager = new ListenerManager();
                this.listenerManager.init(this.configctx);
            }
            for (Object o : this.configctx.getAxisConfiguration().getTransportsIn().keySet()) {
                String trp = (String)o;
                TransportInDescription trsIn = (TransportInDescription)this.configctx.getAxisConfiguration().getTransportsIn().get(trp);
                String msg = "Starting transport " + trsIn.getName();
                if (trsIn.getParameter("port") != null) {
                    msg = msg + " on port " + trsIn.getParameter("port").getValue();
                }
                log.info((Object)msg);
                this.listenerManager.addListener(trsIn, false);
            }
            Parameter synEnv = this.configctx.getAxisConfiguration().getParameter("synapse.env");
            Parameter synCfg = this.configctx.getAxisConfiguration().getParameter("synapse.config");
            String message = "Unable to initialize the Synapse Configuration : Cannot find the ";
            if (synCfg == null || synCfg.getValue() == null || !(synCfg.getValue() instanceof SynapseConfiguration)) {
                log.fatal((Object)(message + "Synapse Configuration"));
                throw new SynapseException(message + "Synapse Configuration");
            }
            this.synConfig = (SynapseConfiguration)synCfg.getValue();
            if (synEnv == null || synEnv.getValue() == null || !(synEnv.getValue() instanceof SynapseEnvironment)) {
                log.fatal((Object)(message + "Synapse Environment"));
                throw new SynapseException(message + "Synapse Environment");
            }
            ((SynapseEnvironment)synEnv.getValue()).setInitialized(true);
            for (Startup stp : ((SynapseConfiguration)synCfg.getValue()).getStartups()) {
                if (stp == null) continue;
                stp.init((SynapseEnvironment)synEnv.getValue());
            }
            log.info((Object)"Ready for processing");
        }
        catch (Throwable t) {
            log.fatal((Object)"Synaps startup failed...", t);
            throw new SynapseException("Synapse startup failed", t);
        }
    }

    private void addDefaultBuildersAndFormatters(AxisConfiguration axisConf) {
        if (axisConf.getMessageBuilder("text/plain") == null) {
            axisConf.addMessageBuilder("text/plain", (Builder)new PlainTextBuilder());
        }
        if (axisConf.getMessageBuilder("application/octet-stream") == null) {
            axisConf.addMessageBuilder("application/octet-stream", (Builder)new BinaryBuilder());
        }
    }

    public void stop() {
        try {
            RMIRegistryController.getInstance().removeLocalRegistry();
            if (this.configctx != null && this.configctx.getAxisConfiguration() != null) {
                HashMap serviceMap = this.configctx.getAxisConfiguration().getServices();
                for (AxisService svc : serviceMap.values()) {
                    svc.setActive(false);
                }
                HashMap moduleMap = this.configctx.getAxisConfiguration().getModules();
                for (AxisModule mod : moduleMap.values()) {
                    if (mod.getModule() == null || "synapse".equals(mod.getName())) continue;
                    mod.getModule().shutdown(this.configctx);
                }
            }
            if (this.listenerManager != null) {
                this.listenerManager.stop();
                this.listenerManager.destroy();
            }
            if (this.configctx != null) {
                this.configctx.terminate();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error stopping the ServerManager", (Throwable)e);
        }
    }

    public int pendingCallbacks() {
        if (this.callbackStore != null) {
            return this.callbackStore.size();
        }
        return 0;
    }

    private void validate() {
        if (this.synapseHome == null || !new File(this.synapseHome).exists()) {
            this.handleFatal("Synapse home");
        } else {
            log.info((Object)("Using Synapse home as : " + this.synapseHome));
        }
        if (this.axis2Repolocation == null || !new File(this.axis2Repolocation).exists()) {
            this.handleFatal("Axis2 repository");
        } else {
            log.info((Object)("Using the Axis2 Repository : " + new File(this.axis2Repolocation).getAbsolutePath()));
        }
        if (this.axis2Xml == null || !new File(this.axis2Xml).exists()) {
            this.handleFatal("axis2.xml location");
        } else {
            log.info((Object)("Using the axis2.xml : " + new File(this.axis2Xml).getAbsolutePath()));
        }
        if (this.synapseXMLPath == null || !new File(this.synapseXMLPath).exists()) {
            this.handleFatal("synapse.xml path");
        }
        if (this.serverName == null) {
            try {
                this.serverName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            log.info((Object)("The server name was not specified, defaulting to : " + this.serverName));
        } else {
            log.info((Object)("Using server name : " + this.serverName));
        }
        log.info((Object)("The timeout handler will run every : " + this.getTimeoutHandlerInterval() / 1000L + "s"));
    }

    public void handleFatal(String msgPre) {
        String msg = "The " + msgPre + " must be set as a system property or init-parameter";
        log.fatal((Object)msg);
        throw new SynapseException(msg);
    }

    public ConfigurationContext getConfigurationContext() {
        return this.configctx;
    }

    public void setCallbackStore(Map callbackStore) {
        this.callbackStore = callbackStore;
    }

    public void setAxis2Repolocation(String axis2Repolocation) {
        this.axis2Repolocation = !new File(axis2Repolocation).isAbsolute() && this.synapseHome != null ? this.synapseHome + File.separator + axis2Repolocation : axis2Repolocation;
    }

    public void setAxis2Xml(String axis2Xml) {
        this.axis2Xml = !new File(axis2Xml).isAbsolute() && this.synapseHome != null ? this.synapseHome + File.separator + axis2Xml : axis2Xml;
    }

    public String getSynapseHome() {
        return this.synapseHome;
    }

    public void setSynapseHome(String synapseHome) {
        this.synapseHome = synapseHome;
    }

    public String getResolveRoot() {
        return this.resolveRoot;
    }

    public void setResolveRoot(String resolveRoot) {
        this.resolveRoot = !new File(resolveRoot).isAbsolute() && this.synapseHome != null ? this.synapseHome + File.separator + resolveRoot : resolveRoot;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getSynapseXMLPath() {
        return this.synapseXMLPath;
    }

    public void setSynapseXMLPath(String synapseXMLPath) {
        this.synapseXMLPath = !new File(synapseXMLPath).isAbsolute() && this.synapseHome != null ? this.synapseHome + File.separator + synapseXMLPath : synapseXMLPath;
    }

    public int getConnectTimeout() {
        if (this.synConfig == null) {
            return 86400000;
        }
        return (int)this.synConfig.getProperty("synapse.connection.connect_timeout", 20000L);
    }

    public int getReadTimeout() {
        if (this.synConfig == null) {
            return 100000;
        }
        return (int)this.synConfig.getProperty("synapse.connection.read_timeout", 100000L);
    }

    public long getTimeoutHandlerInterval() {
        if (this.synConfig == null) {
            return 15000L;
        }
        return this.synConfig.getProperty("synapse.timeout_handler_interval", 15000L);
    }

    public long getGlobalTimeoutInterval() {
        if (this.synConfig == null) {
            return 86400000L;
        }
        return this.synConfig.getProperty("synapse.global_timeout_interval", 86400000L);
    }

    private static final class URLStreamHandlerFactoryImpl
    implements URLStreamHandlerFactory {
        private URLStreamHandlerFactoryImpl() {
        }

        public URLStreamHandler createURLStreamHandler(String protocol) {
            if (protocol == null) {
                throw new IllegalArgumentException("'protocol' cannot be null");
            }
            ClasspathURLStreamHandler urlSH = null;
            if (protocol.equals("classpath")) {
                urlSH = new ClasspathURLStreamHandler();
            }
            return urlSH;
        }
    }
}

