/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.handler;

import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rampart.handler.WSDoAllHandler;
import org.apache.rampart.util.Axis2Util;
import org.apache.rampart.util.HandlerParameterDecoder;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.token.Timestamp;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSDoAllReceiver
extends WSDoAllHandler {
    private static final Log log = LogFactory.getLog((Class)WSDoAllReceiver.class);
    private static Log mlog = LogFactory.getLog((String)"org.apache.rampart.MESSAGE");

    public WSDoAllReceiver() {
        this.inHandler = true;
    }

    public void processMessage(MessageContext msgContext) throws AxisFault {
        String useDoomValue;
        boolean doDebug;
        if (mlog.isDebugEnabled()) {
            mlog.debug((Object)("*********************** WSDoAllReceiver recieved \n" + msgContext.getEnvelope()));
        }
        if (doDebug = log.isDebugEnabled()) {
            log.debug((Object)"WSDoAllReceiver: enter invoke() ");
        }
        boolean useDoom = (useDoomValue = (String)this.getProperty(msgContext, "useDoom")) != null && "true".equalsIgnoreCase(useDoomValue);
        RequestData reqData = new RequestData();
        try {
            this.processBasic(msgContext, useDoom, reqData);
        }
        catch (AxisFault axisFault) {
            this.setAddressingInformationOnFault(msgContext);
            throw axisFault;
        }
        catch (Exception e) {
            this.setAddressingInformationOnFault(msgContext);
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
        finally {
            if (reqData != null) {
                reqData.clear();
                reqData = null;
            }
            if (doDebug) {
                log.debug((Object)"WSDoAllReceiver: exit invoke()");
            }
        }
    }

    private void processBasic(MessageContext msgContext, boolean useDoom, RequestData reqData) throws Exception {
        Timestamp timestamp;
        X509Certificate returnCert;
        WSSecurityEngineResult actionResult;
        try {
            HandlerParameterDecoder.processParameters(msgContext, true);
        }
        catch (Exception e) {
            throw new AxisFault("Configuration error", (Throwable)e);
        }
        reqData.setMsgContext((Object)msgContext);
        if (this.getOption("InflowSecurity") == null && this.getProperty(msgContext, "InflowSecurity") == null) {
            if (msgContext.isServerSide() && this.getOption("InflowSecurity-server") == null && this.getProperty(msgContext, "InflowSecurity-server") == null) {
                return;
            }
            if (this.getOption("InflowSecurity-client") == null && this.getProperty(msgContext, "InflowSecurity-client") == null) {
                return;
            }
        }
        Vector actions = new Vector();
        String action = null;
        action = (String)this.getOption("items");
        if (action == null) {
            action = (String)this.getProperty(msgContext, "items");
        }
        if (action == null) {
            throw new AxisFault("WSDoAllReceiver: No action items defined");
        }
        int doAction = WSSecurityUtil.decodeAction((String)action, actions);
        if (doAction == 0) {
            return;
        }
        String actor = (String)this.getOption("actor");
        Document doc = null;
        try {
            doc = Axis2Util.getDocumentFromSOAPEnvelope(msgContext.getEnvelope(), useDoom);
        }
        catch (WSSecurityException wssEx) {
            throw new AxisFault("WSDoAllReceiver: Error in converting to Document", (Throwable)wssEx);
        }
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants((Element)doc.getDocumentElement());
        if (WSSecurityUtil.findElement((Node)doc.getDocumentElement(), (String)"Fault", (String)soapConstants.getEnvelopeURI()) != null) {
            return;
        }
        CallbackHandler cbHandler = null;
        if ((doAction & 5) != 0) {
            cbHandler = this.getPasswordCB(reqData);
        }
        String sigConfEnabled = null;
        sigConfEnabled = (String)this.getOption("enableSignatureConfirmation");
        if (sigConfEnabled == null) {
            sigConfEnabled = (String)this.getProperty(msgContext, "enableSignatureConfirmation");
        }
        if (!msgContext.isServerSide() && !"false".equalsIgnoreCase(sigConfEnabled)) {
            OperationContext opCtx = msgContext.getOperationContext();
            MessageContext outMsgCtx = opCtx.getMessageContext("Out");
            if (outMsgCtx != null) {
                msgContext.setProperty("_sendSignatureValues_", outMsgCtx.getProperty("_sendSignatureValues_"));
            } else {
                throw new WSSecurityException("Cannot obtain request message context");
            }
        }
        this.doReceiverAction(doAction, reqData);
        Vector wsResult = null;
        try {
            wsResult = secEngine.processSecurityHeader(doc, actor, cbHandler, reqData.getSigCrypto(), reqData.getDecCrypto());
        }
        catch (WSSecurityException ex) {
            throw new AxisFault("WSDoAllReceiver: security processing failed", (Throwable)ex);
        }
        if (wsResult == null) {
            if (doAction == 0) {
                return;
            }
            throw new AxisFault("WSDoAllReceiver: Incoming message does not contain required Security header");
        }
        if (reqData.getWssConfig().isEnableSignatureConfirmation() && !msgContext.isServerSide()) {
            this.checkSignatureConfirmation(reqData, wsResult);
        }
        msgContext.setEnvelope(Axis2Util.getSOAPEnvelopeFromDOMDocument(doc, useDoom));
        SOAPHeader header = null;
        try {
            header = msgContext.getEnvelope().getHeader();
        }
        catch (OMException ex) {
            throw new AxisFault("WSDoAllReceiver: cannot get SOAP header after security processing", (Throwable)ex);
        }
        Iterator headers = header.examineHeaderBlocks(actor);
        SOAPHeaderBlock headerBlock = null;
        while (headers.hasNext()) {
            SOAPHeaderBlock hb = (SOAPHeaderBlock)headers.next();
            if (!hb.getLocalName().equals("Security") || !hb.getNamespace().getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")) continue;
            headerBlock = hb;
            break;
        }
        if (headerBlock != null) {
            headerBlock.setProcessed();
        }
        if ((actionResult = WSSecurityUtil.fetchActionResult((Vector)wsResult, (int)2)) != null && (returnCert = actionResult.getCertificate()) != null && !this.verifyTrust(returnCert, reqData)) {
            throw new AxisFault("WSDoAllReceiver: The certificate used for the signature is not trusted");
        }
        actionResult = WSSecurityUtil.fetchActionResult((Vector)wsResult, (int)32);
        if (actionResult != null && (timestamp = actionResult.getTimestamp()) != null) {
            String ttl = null;
            ttl = (String)this.getOption("timeToLive");
            if (ttl == null) {
                ttl = (String)this.getProperty(msgContext, "timeToLive");
            }
            int ttl_i = 0;
            if (ttl != null) {
                try {
                    ttl_i = Integer.parseInt(ttl);
                }
                catch (NumberFormatException e) {
                    ttl_i = reqData.getTimeToLive();
                }
            }
            if (ttl_i <= 0) {
                ttl_i = reqData.getTimeToLive();
            }
            if (!this.verifyTimestamp(timestamp, ttl_i)) {
                throw new AxisFault("WSDoAllReceiver: The timestamp could not be validated");
            }
        }
        if (!this.checkReceiverResults(wsResult, actions)) {
            throw new AxisFault("WSDoAllReceiver: security processing failed (actions mismatch)");
        }
        Vector<WSHandlerResult> results = null;
        results = (Vector<WSHandlerResult>)this.getProperty(msgContext, "RECV_RESULTS");
        if (results == null) {
            results = new Vector<WSHandlerResult>();
            msgContext.setProperty("RECV_RESULTS", results);
        }
        WSHandlerResult rResult = new WSHandlerResult(actor, wsResult);
        results.add(0, rResult);
    }

    private void setAddressingInformationOnFault(MessageContext msgContext) {
        SOAPEnvelope env = msgContext.getEnvelope();
        SOAPHeader header = env.getHeader();
        if (header != null) {
            OMElement msgIdElem = header.getFirstChildWithName(new QName("http://www.w3.org/2005/08/addressing", "MessageID"));
            if (msgIdElem == null) {
                msgIdElem = header.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "MessageID"));
            }
            if (msgIdElem != null && msgIdElem.getText() != null) {
                msgContext.getOptions().setMessageId(msgIdElem.getText());
            }
        }
    }
}

