/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.handler;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.util.RampartUtil;
import org.apache.ws.secpolicy.model.Binding;
import org.apache.ws.secpolicy.model.SupportingToken;

public class PostDispatchVerificationHandler
implements Handler {
    private HandlerDescription handlerDesc;

    public void cleanup() {
    }

    public void flowComplete(MessageContext msgContext) {
    }

    public HandlerDescription getHandlerDesc() {
        return this.handlerDesc;
    }

    public String getName() {
        return "Post dispatch security verification handler";
    }

    public Parameter getParameter(String name) {
        return this.handlerDesc.getParameter(name);
    }

    public void init(HandlerDescription handlerDesc) {
        this.handlerDesc = handlerDesc;
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        Parameter param;
        Policy policy = msgContext.getEffectivePolicy();
        if (msgContext.getProperty("rampartPolicy") != null) {
            policy = (Policy)msgContext.getProperty("rampartPolicy");
        }
        if (policy == null) {
            policy = msgContext.getEffectivePolicy();
        }
        if (policy == null && (param = msgContext.getParameter("rampartPolicy")) != null) {
            OMElement policyElem = param.getParameterElement().getFirstElement();
            policy = PolicyEngine.getPolicy((OMElement)policyElem);
        }
        if (policy == null) {
            return Handler.InvocationResponse.CONTINUE;
        }
        Iterator alternatives = policy.getAlternatives();
        boolean securityPolicyPresent = false;
        if (alternatives.hasNext()) {
            List assertions = (List)alternatives.next();
            Iterator iterator = assertions.iterator();
            while (iterator.hasNext()) {
                Assertion assertion = (Assertion)iterator.next();
                if (assertion instanceof Binding) {
                    securityPolicyPresent = true;
                    break;
                }
                if (!(assertion instanceof SupportingToken)) continue;
                securityPolicyPresent = true;
                break;
            }
        }
        if (securityPolicyPresent) {
            RampartPolicyData rpd = (RampartPolicyData)msgContext.getProperty("rampartPolicyData");
            if (rpd == null) {
                throw new AxisFault("InvalidSecurity");
            }
            boolean isInitiator = false;
            Parameter clientSideParam = msgContext.getAxisService().getParameter("CLIENT_SIDE");
            if (clientSideParam != null) {
                isInitiator = true;
            }
            if (RampartUtil.isSecHeaderRequired(rpd, isInitiator, true) && msgContext.getProperty("RECV_RESULTS") == null) {
                throw new AxisFault("InvalidSecurity");
            }
        }
        if (msgContext.getParameter("InflowSecurity") != null || msgContext.getProperty("InflowSecurity") != null) {
            if (msgContext.getProperty("RECV_RESULTS") == null) {
                throw new AxisFault("InvalidSecurity");
            }
            if (((Vector)msgContext.getProperty("RECV_RESULTS")).size() == 0) {
                throw new AxisFault("InvalidSecurity");
            }
        }
        return Handler.InvocationResponse.CONTINUE;
    }
}

