/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.builder;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.TrustException;
import org.apache.rampart.RampartException;
import org.apache.rampart.RampartMessageData;
import org.apache.rampart.builder.BindingBuilder;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.policy.model.RampartConfig;
import org.apache.rampart.util.RampartUtil;
import org.apache.ws.secpolicy.model.AlgorithmSuite;
import org.apache.ws.secpolicy.model.SupportingToken;
import org.apache.ws.secpolicy.model.Token;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.message.WSSecBase;
import org.apache.ws.security.message.WSSecDKEncrypt;
import org.apache.ws.security.message.WSSecDKSign;
import org.apache.ws.security.message.WSSecEncrypt;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.message.WSSecSignature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AsymmetricBindingBuilder
extends BindingBuilder {
    private static Log log = LogFactory.getLog((Class)AsymmetricBindingBuilder.class);
    private static Log tlog = LogFactory.getLog((String)"org.apache.rampart.TIME");
    private boolean dotDebug = false;
    private Token sigToken;
    private WSSecSignature sig;
    private WSSecEncryptedKey encrKey;
    private String encryptedKeyId;
    private byte[] encryptedKeyValue;
    private Vector signatureValues = new Vector();
    private Element encrTokenElement;
    private Element sigDKTElement;
    private Element encrDKTElement;
    private Vector sigParts = new Vector();
    private Element signatureElement;

    public AsymmetricBindingBuilder() {
        this.dotDebug = tlog.isDebugEnabled();
    }

    public void build(RampartMessageData rmd) throws RampartException {
        log.debug((Object)"AsymmetricBindingBuilder build invoked");
        RampartPolicyData rpd = rmd.getPolicyData();
        if (rpd.isIncludeTimestamp()) {
            this.addTimestamp(rmd);
        }
        if ("EncryptBeforeSigning".equals(rpd.getProtectionOrder())) {
            this.doEncryptBeforeSig(rmd);
        } else {
            this.doSignBeforeEncrypt(rmd);
        }
        log.debug((Object)"AsymmetricBindingBuilder build invoked : DONE");
    }

    private void doEncryptBeforeSig(RampartMessageData rmd) throws RampartException {
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        if (this.dotDebug) {
            t0 = System.currentTimeMillis();
        }
        RampartPolicyData rpd = rmd.getPolicyData();
        Document doc = rmd.getDocument();
        RampartConfig config = rpd.getRampartConfig();
        Element encrDKTokenElem = null;
        WSSecEncrypt encr = null;
        Element refList = null;
        WSSecDKEncrypt dkEncr = null;
        Token encryptionToken = null;
        encryptionToken = rmd.isInitiator() ? rpd.getRecipientToken() : rpd.getInitiatorToken();
        Vector encrParts = RampartUtil.getEncryptedParts(rmd);
        this.sigParts = RampartUtil.getSignedParts(rmd);
        if (encryptionToken == null && encrParts.size() > 0) {
            throw new RampartException("encryptionTokenMissing");
        }
        if (encryptionToken != null && encrParts.size() > 0) {
            if (rpd.getRampartConfig() == null) {
                throw new RampartException("rampartConigMissing");
            }
            if (encryptionToken.isDerivedKeys()) {
                try {
                    this.setupEncryptedKey(rmd, encryptionToken);
                    dkEncr = new WSSecDKEncrypt();
                    dkEncr.setParts(encrParts);
                    dkEncr.setExternalKey(this.encryptedKeyValue, this.encryptedKeyId);
                    dkEncr.setDerivedKeyLength(rpd.getAlgorithmSuite().getEncryptionDerivedKeyLength() / 8);
                    dkEncr.prepare(doc);
                    this.encrDKTElement = dkEncr.getdktElement();
                    encrDKTokenElem = RampartUtil.appendChildToSecHeader(rmd, this.encrDKTElement);
                    refList = dkEncr.encryptForExternalRef(null, encrParts);
                }
                catch (WSSecurityException e) {
                    throw new RampartException("errorCreatingEncryptedKey", e);
                }
                catch (ConversationException e) {
                    throw new RampartException("errorInDKEncr", e);
                }
            }
            try {
                encr = new WSSecEncrypt();
                encr.setParts(encrParts);
                encr.setWsConfig(rmd.getConfig());
                encr.setDocument(doc);
                RampartUtil.setEncryptionUser(rmd, (WSSecEncryptedKey)encr);
                encr.setSymmetricEncAlgorithm(rpd.getAlgorithmSuite().getEncryption());
                RampartUtil.setKeyIdentifierType(rpd, (WSSecBase)encr, encryptionToken);
                encr.setKeyEncAlgo(rpd.getAlgorithmSuite().getAsymmetricKeyWrap());
                encr.prepare(doc, RampartUtil.getEncryptionCrypto(config, rmd.getCustomClassLoader()));
                Element bstElem = encr.getBinarySecurityTokenElement();
                if (bstElem != null) {
                    RampartUtil.appendChildToSecHeader(rmd, bstElem);
                }
                this.encrTokenElement = encr.getEncryptedKeyElement();
                this.encrTokenElement = RampartUtil.appendChildToSecHeader(rmd, this.encrTokenElement);
                refList = encr.encryptForExternalRef(null, encrParts);
            }
            catch (WSSecurityException e) {
                throw new RampartException("errorInEncryption", e);
            }
            RampartUtil.appendChildToSecHeader(rmd, refList);
            if (this.dotDebug) {
                t1 = System.currentTimeMillis();
            }
            this.setInsertionLocation(this.encrTokenElement);
            RampartUtil.handleEncryptedSignedHeaders(encrParts, this.sigParts, doc);
            HashMap sigSuppTokMap = null;
            HashMap endSuppTokMap = null;
            HashMap sgndEndSuppTokMap = null;
            HashMap sgndEncSuppTokMap = null;
            HashMap endEncSuppTokMap = null;
            HashMap sgndEndEncSuppTokMap = null;
            if (this.timestampElement != null) {
                this.sigParts.add(new WSEncryptionPart(RampartUtil.addWsuIdToElement((OMElement)this.timestampElement)));
            }
            if (rmd.isInitiator()) {
                SupportingToken sgndSuppTokens = rpd.getSignedSupportingTokens();
                sigSuppTokMap = this.handleSupportingTokens(rmd, sgndSuppTokens);
                SupportingToken endSuppTokens = rpd.getEndorsingSupportingTokens();
                endSuppTokMap = this.handleSupportingTokens(rmd, endSuppTokens);
                SupportingToken sgndEndSuppTokens = rpd.getSignedEndorsingSupportingTokens();
                sgndEndSuppTokMap = this.handleSupportingTokens(rmd, sgndEndSuppTokens);
                SupportingToken sgndEncryptedSuppTokens = rpd.getSignedEncryptedSupportingTokens();
                sgndEncSuppTokMap = this.handleSupportingTokens(rmd, sgndEncryptedSuppTokens);
                SupportingToken endorsingEncryptedSuppTokens = rpd.getEndorsingEncryptedSupportingTokens();
                endEncSuppTokMap = this.handleSupportingTokens(rmd, endorsingEncryptedSuppTokens);
                SupportingToken sgndEndEncSuppTokens = rpd.getSignedEndorsingEncryptedSupportingTokens();
                sgndEndEncSuppTokMap = this.handleSupportingTokens(rmd, sgndEndEncSuppTokens);
                SupportingToken supportingToks = rpd.getSupportingTokens();
                this.handleSupportingTokens(rmd, supportingToks);
                SupportingToken encryptedSupportingToks = rpd.getEncryptedSupportingTokens();
                this.handleSupportingTokens(rmd, encryptedSupportingToks);
                this.sigParts = this.addSignatureParts(sigSuppTokMap, this.sigParts);
                this.sigParts = this.addSignatureParts(sgndEncSuppTokMap, this.sigParts);
                this.sigParts = this.addSignatureParts(sgndEndSuppTokMap, this.sigParts);
                this.sigParts = this.addSignatureParts(sgndEndEncSuppTokMap, this.sigParts);
            } else {
                this.addSignatureConfirmation(rmd, this.sigParts);
            }
            if (this.sigParts.size() > 0 && rmd.isInitiator() && rpd.getInitiatorToken() != null || !rmd.isInitiator() && rpd.getRecipientToken() != null) {
                this.doSignature(rmd);
            }
            if (rmd.isInitiator()) {
                endSuppTokMap.putAll(endEncSuppTokMap);
                Vector endSigVals = this.doEndorsedSignatures(rmd, endSuppTokMap);
                Iterator iter = endSigVals.iterator();
                while (iter.hasNext()) {
                    this.signatureValues.add(iter.next());
                }
                sgndEndSuppTokMap.putAll(sgndEndEncSuppTokMap);
                Vector sigEndSigVals = this.doEndorsedSignatures(rmd, sgndEndSuppTokMap);
                Iterator iter2 = sigEndSigVals.iterator();
                while (iter2.hasNext()) {
                    this.signatureValues.add(iter2.next());
                }
            }
            if (this.dotDebug) {
                t2 = System.currentTimeMillis();
                tlog.debug((Object)("Encryption took :" + (t1 - t0) + ", Signature tool :" + (t2 - t1)));
            }
            if (rpd.isSignatureProtection() && this.mainSigId != null) {
                long t3 = 0L;
                long t4 = 0L;
                if (this.dotDebug) {
                    t3 = System.currentTimeMillis();
                }
                Vector<WSEncryptionPart> secondEncrParts = new Vector<WSEncryptionPart>();
                secondEncrParts.add(new WSEncryptionPart(this.mainSigId, "Element"));
                if (rmd.isInitiator()) {
                    for (int i = 0; i < this.encryptedTokensIdList.size(); ++i) {
                        secondEncrParts.add(new WSEncryptionPart((String)this.encryptedTokensIdList.get(i), "Element"));
                    }
                }
                Element secondRefList = null;
                if (encryptionToken.isDerivedKeys()) {
                    try {
                        secondRefList = dkEncr.encryptForExternalRef(null, secondEncrParts);
                        RampartUtil.insertSiblingAfter(rmd, encrDKTokenElem, secondRefList);
                    }
                    catch (WSSecurityException e) {
                        throw new RampartException("errorCreatingEncryptedKey", e);
                    }
                }
                try {
                    secondRefList = encr.encryptForExternalRef(null, secondEncrParts);
                    this.setInsertionLocation(RampartUtil.insertSiblingAfter(rmd, this.encrTokenElement, secondRefList));
                }
                catch (WSSecurityException e) {
                    throw new RampartException("errorInEncryption", e);
                }
                if (this.dotDebug) {
                    t4 = System.currentTimeMillis();
                    tlog.debug((Object)("Signature protection took :" + (t4 - t3)));
                }
            }
        }
    }

    private void doSignBeforeEncrypt(RampartMessageData rmd) throws RampartException {
        Token encrToken;
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        RampartPolicyData rpd = rmd.getPolicyData();
        Document doc = rmd.getDocument();
        HashMap sigSuppTokMap = null;
        HashMap endSuppTokMap = null;
        HashMap sgndEndSuppTokMap = null;
        HashMap sgndEncSuppTokMap = null;
        HashMap endEncSuppTokMap = null;
        HashMap sgndEndEncSuppTokMap = null;
        this.sigParts = RampartUtil.getSignedParts(rmd);
        if (this.timestampElement != null) {
            this.sigParts.add(new WSEncryptionPart(RampartUtil.addWsuIdToElement((OMElement)this.timestampElement)));
        } else {
            this.setInsertionLocation(null);
        }
        if (this.dotDebug) {
            t0 = System.currentTimeMillis();
        }
        if (rmd.isInitiator()) {
            SupportingToken sgndSuppTokens = rpd.getSignedSupportingTokens();
            sigSuppTokMap = this.handleSupportingTokens(rmd, sgndSuppTokens);
            SupportingToken endSuppTokens = rpd.getEndorsingSupportingTokens();
            endSuppTokMap = this.handleSupportingTokens(rmd, endSuppTokens);
            SupportingToken sgndEndSuppTokens = rpd.getSignedEndorsingSupportingTokens();
            sgndEndSuppTokMap = this.handleSupportingTokens(rmd, sgndEndSuppTokens);
            SupportingToken sgndEncryptedSuppTokens = rpd.getSignedEncryptedSupportingTokens();
            sgndEncSuppTokMap = this.handleSupportingTokens(rmd, sgndEncryptedSuppTokens);
            SupportingToken endorsingEncryptedSuppTokens = rpd.getEndorsingEncryptedSupportingTokens();
            endEncSuppTokMap = this.handleSupportingTokens(rmd, endorsingEncryptedSuppTokens);
            SupportingToken sgndEndEncSuppTokens = rpd.getSignedEndorsingEncryptedSupportingTokens();
            sgndEndEncSuppTokMap = this.handleSupportingTokens(rmd, sgndEndEncSuppTokens);
            SupportingToken supportingToks = rpd.getSupportingTokens();
            this.handleSupportingTokens(rmd, supportingToks);
            SupportingToken encryptedSupportingToks = rpd.getEncryptedSupportingTokens();
            this.handleSupportingTokens(rmd, encryptedSupportingToks);
            this.sigParts = this.addSignatureParts(sigSuppTokMap, this.sigParts);
            this.sigParts = this.addSignatureParts(sgndEncSuppTokMap, this.sigParts);
            this.sigParts = this.addSignatureParts(sgndEndSuppTokMap, this.sigParts);
            this.sigParts = this.addSignatureParts(sgndEndEncSuppTokMap, this.sigParts);
        } else {
            this.addSignatureConfirmation(rmd, this.sigParts);
        }
        if (this.sigParts.size() > 0 && (rmd.isInitiator() && rpd.getInitiatorToken() != null || !rmd.isInitiator() && rpd.getRecipientToken() != null)) {
            this.doSignature(rmd);
        }
        if (rmd.isInitiator()) {
            endSuppTokMap.putAll(endEncSuppTokMap);
            Vector endSigVals = this.doEndorsedSignatures(rmd, endSuppTokMap);
            Iterator iter = endSigVals.iterator();
            while (iter.hasNext()) {
                this.signatureValues.add(iter.next());
            }
            sgndEndSuppTokMap.putAll(sgndEndEncSuppTokMap);
            Vector sigEndSigVals = this.doEndorsedSignatures(rmd, sgndEndSuppTokMap);
            Iterator iter2 = sigEndSigVals.iterator();
            while (iter2.hasNext()) {
                this.signatureValues.add(iter2.next());
            }
        }
        if (this.dotDebug) {
            t1 = System.currentTimeMillis();
        }
        Vector encrParts = RampartUtil.getEncryptedParts(rmd);
        if (rpd.isSignatureProtection() && this.mainSigId != null) {
            encrParts.add(new WSEncryptionPart(RampartUtil.addWsuIdToElement((OMElement)this.signatureElement), "Element"));
        }
        if (rmd.isInitiator()) {
            for (int i = 0; i < this.encryptedTokensIdList.size(); ++i) {
                encrParts.add(new WSEncryptionPart((String)this.encryptedTokensIdList.get(i), "Element"));
            }
        }
        if ((encrToken = rpd.getRecipientToken()) != null && encrParts.size() > 0) {
            Element refList = null;
            AlgorithmSuite algorithmSuite = rpd.getAlgorithmSuite();
            if (encrToken.isDerivedKeys()) {
                try {
                    WSSecDKEncrypt dkEncr = new WSSecDKEncrypt();
                    if (this.encrKey == null) {
                        this.setupEncryptedKey(rmd, encrToken);
                    }
                    dkEncr.setExternalKey(this.encryptedKeyValue, this.encryptedKeyId);
                    dkEncr.setCustomValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                    dkEncr.setSymmetricEncAlgorithm(algorithmSuite.getEncryption());
                    dkEncr.setDerivedKeyLength(algorithmSuite.getEncryptionDerivedKeyLength() / 8);
                    dkEncr.prepare(doc);
                    this.encrDKTElement = this.encrTokenElement != null ? RampartUtil.insertSiblingAfter(rmd, this.encrTokenElement, dkEncr.getdktElement()) : RampartUtil.insertSiblingBefore(rmd, this.sigDKTElement, dkEncr.getdktElement());
                    refList = dkEncr.encryptForExternalRef(null, encrParts);
                    RampartUtil.insertSiblingAfter(rmd, this.encrDKTElement, refList);
                }
                catch (WSSecurityException e) {
                    throw new RampartException("errorInDKEncr", e);
                }
                catch (ConversationException e) {
                    throw new RampartException("errorInDKEncr", e);
                }
            }
            try {
                WSSecEncrypt encr = new WSSecEncrypt();
                RampartUtil.setKeyIdentifierType(rpd, (WSSecBase)encr, encrToken);
                encr.setWsConfig(rmd.getConfig());
                encr.setDocument(doc);
                RampartUtil.setEncryptionUser(rmd, (WSSecEncryptedKey)encr);
                encr.setSymmetricEncAlgorithm(algorithmSuite.getEncryption());
                encr.setKeyEncAlgo(algorithmSuite.getAsymmetricKeyWrap());
                encr.prepare(doc, RampartUtil.getEncryptionCrypto(rpd.getRampartConfig(), rmd.getCustomClassLoader()));
                if (this.timestampElement != null) {
                    this.setInsertionLocation(this.timestampElement);
                } else {
                    this.setInsertionLocation(null);
                }
                if (encr.getBSTTokenId() != null) {
                    this.setInsertionLocation(RampartUtil.insertSiblingAfterOrPrepend(rmd, this.getInsertionLocation(), encr.getBinarySecurityTokenElement()));
                }
                Element encryptedKeyElement = encr.getEncryptedKeyElement();
                refList = encr.encryptForInternalRef(null, encrParts);
                encryptedKeyElement.appendChild(refList);
                this.setInsertionLocation(RampartUtil.insertSiblingAfterOrPrepend(rmd, this.getInsertionLocation(), encryptedKeyElement));
            }
            catch (WSSecurityException e) {
                throw new RampartException("errorInEncryption", e);
            }
        }
        if (this.dotDebug) {
            t2 = System.currentTimeMillis();
            tlog.debug((Object)("Signature took :" + (t1 - t0) + ", Encryption took :" + (t2 - t1)));
        }
    }

    private void doSignature(RampartMessageData rmd) throws RampartException {
        RampartPolicyData rpd = rmd.getPolicyData();
        Document doc = rmd.getDocument();
        long t0 = 0L;
        long t1 = 0L;
        if (this.dotDebug) {
            t0 = System.currentTimeMillis();
        }
        this.sigToken = rmd.isInitiator() ? rpd.getInitiatorToken() : rpd.getRecipientToken();
        if (this.sigToken.isDerivedKeys()) {
            if (this.encrKey == null) {
                this.setupEncryptedKey(rmd, this.sigToken);
            }
            WSSecDKSign dkSign = new WSSecDKSign();
            dkSign.setExternalKey(this.encryptedKeyValue, this.encryptedKeyId);
            dkSign.setSignatureAlgorithm(rpd.getAlgorithmSuite().getSymmetricSignature());
            dkSign.setDerivedKeyLength(rpd.getAlgorithmSuite().getSignatureDerivedKeyLength() / 8);
            dkSign.setCustomValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
            try {
                dkSign.prepare(doc, rmd.getSecHeader());
                if (rpd.isTokenProtection()) {
                    this.sigParts.add(new WSEncryptionPart(this.encrKey.getId()));
                }
                dkSign.setParts(this.sigParts);
                dkSign.addReferencesToSign(this.sigParts, rmd.getSecHeader());
                dkSign.computeSignature();
                this.sigDKTElement = RampartUtil.insertSiblingAfter(rmd, this.getInsertionLocation(), dkSign.getdktElement());
                this.setInsertionLocation(this.sigDKTElement);
                this.setInsertionLocation(RampartUtil.insertSiblingAfter(rmd, this.getInsertionLocation(), dkSign.getSignatureElement()));
                this.mainSigId = RampartUtil.addWsuIdToElement((OMElement)dkSign.getSignatureElement());
                this.signatureValues.add(dkSign.getSignatureValue());
                this.signatureElement = dkSign.getSignatureElement();
            }
            catch (WSSecurityException e) {
                throw new RampartException("errorInDerivedKeyTokenSignature", e);
            }
            catch (ConversationException e) {
                throw new RampartException("errorInDerivedKeyTokenSignature", e);
            }
        }
        this.sig = this.getSignatureBuider(rmd, this.sigToken);
        Element bstElem = this.sig.getBinarySecurityTokenElement();
        if (bstElem != null) {
            bstElem = RampartUtil.insertSiblingAfter(rmd, this.getInsertionLocation(), bstElem);
            this.setInsertionLocation(bstElem);
        }
        if (rmd.getPolicyData().isTokenProtection() && this.sig.getBSTTokenId() != null) {
            this.sigParts.add(new WSEncryptionPart(this.sig.getBSTTokenId()));
        }
        try {
            this.sig.addReferencesToSign(this.sigParts, rmd.getSecHeader());
            this.sig.computeSignature();
            this.signatureElement = this.sig.getSignatureElement();
            this.setInsertionLocation(RampartUtil.insertSiblingAfter(rmd, this.getInsertionLocation(), this.signatureElement));
            this.mainSigId = RampartUtil.addWsuIdToElement((OMElement)this.signatureElement);
        }
        catch (WSSecurityException e) {
            throw new RampartException("errorInSignatureWithX509Token", e);
        }
        this.signatureValues.add(this.sig.getSignatureValue());
        if (this.dotDebug) {
            t1 = System.currentTimeMillis();
            tlog.debug((Object)("Signature took :" + (t1 - t0)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setupEncryptedKey(RampartMessageData rmd, Token token) throws RampartException {
        if (!rmd.isInitiator() && token.isDerivedKeys()) {
            if (this.encryptedKeyId != null && this.encryptedKeyValue != null) {
                return;
            }
            Object resultsObj = rmd.getMsgContext().getProperty("RECV_RESULTS");
            if (resultsObj == null) throw new RampartException("noSecurityResults");
            this.encryptedKeyId = RampartUtil.getRequestEncryptedKeyId((Vector)resultsObj);
            this.encryptedKeyValue = RampartUtil.getRequestEncryptedKeyValue((Vector)resultsObj);
            if (this.encryptedKeyId != null || this.encryptedKeyValue != null) return;
            this.createEncryptedKey(rmd, token);
            return;
        } else {
            this.createEncryptedKey(rmd, token);
        }
    }

    private void createEncryptedKey(RampartMessageData rmd, Token token) throws RampartException {
        this.encrKey = this.getEncryptedKeyBuilder(rmd, token);
        Element bstElem = this.encrKey.getBinarySecurityTokenElement();
        if (bstElem != null) {
            RampartUtil.appendChildToSecHeader(rmd, bstElem);
        }
        this.encrTokenElement = this.encrKey.getEncryptedKeyElement();
        this.encrTokenElement = RampartUtil.appendChildToSecHeader(rmd, this.encrTokenElement);
        this.encryptedKeyValue = this.encrKey.getEphemeralKey();
        this.encryptedKeyId = this.encrKey.getId();
        try {
            org.apache.rahas.Token tok = new org.apache.rahas.Token(this.encryptedKeyId, (OMElement)this.encrTokenElement, null, null);
            tok.setSecret(this.encryptedKeyValue);
            rmd.getTokenStorage().add(tok);
        }
        catch (TrustException e) {
            throw new RampartException("errorInAddingTokenIntoStore", e);
        }
    }
}

