/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart;

import java.util.List;
import java.util.Vector;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.rahas.SimpleTokenStore;
import org.apache.rahas.TokenStorage;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rampart.RampartException;
import org.apache.rampart.policy.RampartPolicyBuilder;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.policy.model.RampartConfig;
import org.apache.rampart.util.Axis2Util;
import org.apache.rampart.util.RampartUtil;
import org.apache.ws.secpolicy.WSSPolicyException;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.token.SecurityContextToken;
import org.apache.ws.security.util.Loader;
import org.apache.ws.security.util.WSSecurityUtil;
import org.opensaml.SAMLAssertion;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RampartMessageData {
    public static final String KEY_RAMPART_POLICY = "rampartPolicy";
    public static final String RAMPART_POLICY_DATA = "rampartPolicyData";
    public static final String RAMPART_STS_POLICY = "rampartStsPolicy";
    public static final String KEY_CUSTOM_ISSUED_TOKEN = "customIssuedToken";
    public static final String KEY_WST_VERSION = "wstVersion";
    public static final String PARAM_CLIENT_SIDE = "CLIENT_SIDE";
    public static final String KEY_WSSC_VERSION = "wscVersion";
    public static final String KEY_SCT_ISSUER_POLICY = "sct-issuer-policy";
    public static final String CANCEL_REQUEST = "cancelrequest";
    public static final String SCT_ID = "sctID";
    private MessageContext msgContext = null;
    private RampartPolicyData policyData = null;
    private WSSecHeader secHeader = null;
    private WSSConfig config = null;
    private int timeToLive = 300;
    private int timestampMaxSkew = 0;
    private String timestampId;
    private Document document;
    private TokenStorage tokenStorage;
    private int wstVersion = 1;
    private int secConvVersion = 1;
    private String issuedEncryptionTokenId;
    private String issuedSignatureTokenId;
    private Policy servicePolicy;
    private boolean isInitiator;
    private boolean sender;
    private ClassLoader customClassLoader;
    private SOAPConstants soapConstants;

    public RampartMessageData(MessageContext msgCtx, boolean sender) throws RampartException {
        this.msgContext = msgCtx;
        try {
            MessageContext outMsgCtx;
            MessageContext inMsgCtx;
            Parameter param;
            AxisService axisService;
            this.document = Axis2Util.getDocumentFromSOAPEnvelope(msgCtx.getEnvelope(), true);
            msgCtx.setEnvelope((SOAPEnvelope)this.document.getDocumentElement());
            this.soapConstants = WSSecurityUtil.getSOAPConstants((Element)this.document.getDocumentElement());
            if (msgCtx.getProperty(KEY_WST_VERSION) != null) {
                this.wstVersion = TrustUtil.getWSTVersion((String)((String)msgCtx.getProperty(KEY_WST_VERSION)));
            }
            if (msgCtx.getProperty(KEY_WSSC_VERSION) != null) {
                this.secConvVersion = TrustUtil.getWSTVersion((String)((String)msgCtx.getProperty(KEY_WSSC_VERSION)));
            }
            if ((axisService = msgCtx.getAxisService()) != null && axisService.getParameter(PARAM_CLIENT_SIDE) != null) {
                this.isInitiator = true;
            } else {
                boolean bl = this.isInitiator = !msgCtx.isServerSide();
                if (this.isInitiator && axisService != null) {
                    Parameter clientSideParam = new Parameter();
                    clientSideParam.setName(PARAM_CLIENT_SIDE);
                    clientSideParam.setLocked(true);
                    msgCtx.getAxisService().addParameter(clientSideParam);
                }
            }
            if (msgCtx.getProperty(KEY_RAMPART_POLICY) != null) {
                this.servicePolicy = (Policy)msgCtx.getProperty(KEY_RAMPART_POLICY);
            }
            if (this.servicePolicy == null) {
                this.servicePolicy = msgCtx.getEffectivePolicy();
            }
            if (this.servicePolicy == null && (param = msgCtx.getParameter(KEY_RAMPART_POLICY)) != null) {
                OMElement policyElem = param.getParameterElement().getFirstElement();
                this.servicePolicy = PolicyEngine.getPolicy((OMElement)policyElem);
            }
            if (this.servicePolicy != null) {
                List it = (List)this.servicePolicy.getAlternatives().next();
                this.policyData = RampartPolicyBuilder.build(it);
            }
            if (this.policyData != null && ("http://schemas.xmlsoap.org/ws/2005/02/trust/RST/SCT".equals(this.msgContext.getWSAAction()) || "http://schemas.xmlsoap.org/ws/2005/02/trust/RSTR/SCT".equals(this.msgContext.getWSAAction())) && this.policyData.getIssuerPolicy() != null) {
                this.servicePolicy = this.policyData.getIssuerPolicy();
                RampartConfig rampartConfig = this.policyData.getRampartConfig();
                if (rampartConfig != null) {
                    RampartConfig rc = new RampartConfig();
                    rc.setEncrCryptoConfig(rampartConfig.getEncrCryptoConfig());
                    rc.setSigCryptoConfig(rampartConfig.getSigCryptoConfig());
                    rc.setDecCryptoConfig(rampartConfig.getDecCryptoConfig());
                    rc.setUser(rampartConfig.getUser());
                    rc.setEncryptionUser(rampartConfig.getEncryptionUser());
                    rc.setPwCbClass(rampartConfig.getPwCbClass());
                    rc.setSSLConfig(rampartConfig.getSSLConfig());
                    this.servicePolicy.addAssertion((Assertion)rc);
                }
                List it = (List)this.servicePolicy.getAlternatives().next();
                this.policyData = RampartPolicyBuilder.build(it);
            }
            this.sender = sender;
            OperationContext opCtx = this.msgContext.getOperationContext();
            if (!this.isInitiator && this.sender && opCtx != null && (inMsgCtx = opCtx.getMessageContext("In")) != null && this.msgContext.getProperty("RECV_RESULTS") == null) {
                this.msgContext.setProperty("RECV_RESULTS", inMsgCtx.getProperty("RECV_RESULTS"));
                this.msgContext.setProperty(SCT_ID, inMsgCtx.getProperty(SCT_ID));
            }
            if (this.isInitiator && !this.sender && opCtx != null && (outMsgCtx = opCtx.getMessageContext("Out")) != null) {
                this.msgContext.setProperty(SCT_ID, outMsgCtx.getProperty(SCT_ID));
            }
            if (this.policyData != null && this.policyData.getRampartConfig() != null) {
                boolean timestampPrecisionInMilliseconds = Boolean.valueOf(this.policyData.getRampartConfig().getTimestampPrecisionInMilliseconds());
                if (timestampPrecisionInMilliseconds == WSSConfig.getDefaultWSConfig().isPrecisionInMilliSeconds()) {
                    this.config = WSSConfig.getDefaultWSConfig();
                } else {
                    this.config = RampartUtil.getWSSConfigInstance();
                    this.config.setPrecisionInMilliSeconds(timestampPrecisionInMilliseconds);
                }
            } else {
                this.config = WSSConfig.getDefaultWSConfig();
            }
            this.customClassLoader = msgCtx.getAxisService().getClassLoader();
            if (this.sender && this.policyData != null) {
                this.secHeader = new WSSecHeader();
                this.secHeader.insertSecurityHeader(this.document);
            }
        }
        catch (TrustException e) {
            throw new RampartException("errorInExtractingMsgProps", e);
        }
        catch (AxisFault e) {
            throw new RampartException("errorInExtractingMsgProps", e);
        }
        catch (WSSPolicyException e) {
            throw new RampartException("errorInExtractingMsgProps", e);
        }
        catch (WSSecurityException e) {
            throw new RampartException("errorInExtractingMsgProps", e);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public int getTimestampMaxSkew() {
        return this.timestampMaxSkew;
    }

    public void setTimestampMaxSkew(int timestampMaxSkew) {
        this.timestampMaxSkew = timestampMaxSkew;
    }

    public WSSConfig getConfig() {
        return this.config;
    }

    public void setConfig(WSSConfig config) {
        this.config = config;
    }

    public MessageContext getMsgContext() {
        return this.msgContext;
    }

    public void setMsgContext(MessageContext msgContext) {
        this.msgContext = msgContext;
    }

    public RampartPolicyData getPolicyData() {
        return this.policyData;
    }

    public void setPolicyData(RampartPolicyData policyData) throws RampartException {
        this.policyData = policyData;
        try {
            if (this.isInitiator && !this.sender && policyData.isSignatureConfirmation()) {
                OperationContext opCtx = this.msgContext.getOperationContext();
                MessageContext outMsgCtx = opCtx.getMessageContext("Out");
                this.msgContext.setProperty("_sendSignatureValues_", outMsgCtx.getProperty("_sendSignatureValues_"));
            }
        }
        catch (AxisFault e) {
            throw new RampartException("errorGettingSignatureValuesForSigconf", e);
        }
    }

    public WSSecHeader getSecHeader() {
        return this.secHeader;
    }

    public void setSecHeader(WSSecHeader secHeader) {
        this.secHeader = secHeader;
    }

    public String getIssuedEncryptionTokenId() {
        return this.issuedEncryptionTokenId;
    }

    public void setIssuedEncryptionTokenId(String issuedEncryptionTokenId) {
        this.issuedEncryptionTokenId = issuedEncryptionTokenId;
    }

    public String getIssuedSignatureTokenId() {
        if (this.isInitiator) {
            return this.issuedSignatureTokenId;
        }
        Vector results = (Vector)this.msgContext.getProperty("RECV_RESULTS");
        for (int i = 0; i < results.size(); ++i) {
            WSHandlerResult rResult = (WSHandlerResult)results.get(i);
            Vector wsSecEngineResults = rResult.getResults();
            for (int j = 0; j < wsSecEngineResults.size(); ++j) {
                WSSecurityEngineResult wser = (WSSecurityEngineResult)wsSecEngineResults.get(j);
                Integer actInt = (Integer)wser.get((Object)"action");
                if (8 != actInt) continue;
                SAMLAssertion assertion = (SAMLAssertion)wser.get((Object)"saml-assertion");
                return assertion.getId();
            }
        }
        return null;
    }

    public void setIssuedSignatureTokenId(String issuedSignatureTokenId) {
        this.issuedSignatureTokenId = issuedSignatureTokenId;
    }

    public String getSecConvTokenId() {
        String id = null;
        if (this.isInitiator) {
            String contextIdentifierKey = RampartUtil.getContextIdentifierKey(this.msgContext);
            id = (String)RampartUtil.getContextMap(this.msgContext).get(contextIdentifierKey);
        } else {
            Vector results = (Vector)this.msgContext.getProperty("RECV_RESULTS");
            for (int i = 0; i < results.size(); ++i) {
                WSHandlerResult rResult = (WSHandlerResult)results.get(i);
                Vector wsSecEngineResults = rResult.getResults();
                for (int j = 0; j < wsSecEngineResults.size(); ++j) {
                    WSSecurityEngineResult wser = (WSSecurityEngineResult)wsSecEngineResults.get(j);
                    Integer actInt = (Integer)wser.get((Object)"action");
                    if (1024 != actInt) continue;
                    SecurityContextToken sct = (SecurityContextToken)wser.get((Object)"security-context-token");
                    id = sct.getID();
                }
            }
        }
        if (id == null || id.length() == 0) {
            id = (String)this.msgContext.getProperty(SCT_ID);
        }
        return id;
    }

    public void setSecConvTokenId(String secConvTokenId) {
        String contextIdentifierKey = RampartUtil.getContextIdentifierKey(this.msgContext);
        RampartUtil.getContextMap(this.msgContext).put(contextIdentifierKey, secConvTokenId);
    }

    public TokenStorage getTokenStorage() throws RampartException {
        if (this.tokenStorage != null) {
            return this.tokenStorage;
        }
        TokenStorage storage = (TokenStorage)this.msgContext.getProperty("org.apache.rahas.TokenStorage");
        if (storage != null) {
            this.tokenStorage = storage;
        } else {
            if (this.policyData.getRampartConfig() != null && this.policyData.getRampartConfig().getTokenStoreClass() != null) {
                Class stClass = null;
                String storageClass = this.policyData.getRampartConfig().getTokenStoreClass();
                try {
                    stClass = Loader.loadClass((ClassLoader)this.msgContext.getAxisService().getClassLoader(), (String)storageClass);
                }
                catch (ClassNotFoundException e) {
                    throw new RampartException("WSHandler: cannot load token storage class: " + storageClass, e);
                }
                try {
                    this.tokenStorage = (TokenStorage)stClass.newInstance();
                }
                catch (Exception e) {
                    throw new RampartException("Cannot create instance of token storage: " + storageClass, e);
                }
            }
            this.tokenStorage = new SimpleTokenStore();
            this.msgContext.getConfigurationContext().setProperty("org.apache.rahas.TokenStorage", (Object)this.tokenStorage);
        }
        return this.tokenStorage;
    }

    public void setTokenStorage(TokenStorage tokenStorage) {
        this.tokenStorage = tokenStorage;
    }

    public int getWstVersion() {
        return this.wstVersion;
    }

    public void setWstVersion(int wstVersion) {
        this.wstVersion = wstVersion;
    }

    public int getSecConvVersion() {
        return this.secConvVersion;
    }

    public Policy getServicePolicy() {
        return this.servicePolicy;
    }

    public void setServicePolicy(Policy servicePolicy) {
        this.servicePolicy = servicePolicy;
    }

    public String getTimestampId() {
        return this.timestampId;
    }

    public void setTimestampId(String timestampId) {
        this.timestampId = timestampId;
    }

    public boolean isInitiator() {
        return this.isInitiator;
    }

    public ClassLoader getCustomClassLoader() {
        return this.customClassLoader;
    }

    public SOAPConstants getSoapConstants() {
        return this.soapConstants;
    }
}

