/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultSubCode;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.Token;
import org.apache.rahas.TokenStorage;
import org.apache.rampart.PolicyValidatorCallbackHandler;
import org.apache.rampart.RampartException;
import org.apache.rampart.RampartMessageData;
import org.apache.rampart.TokenCallbackHandler;
import org.apache.rampart.ValidatorData;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.util.Axis2Util;
import org.apache.rampart.util.RampartUtil;
import org.apache.ws.secpolicy.WSSPolicyException;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.SAMLUtil;
import org.opensaml.SAMLAssertion;

public class RampartEngine {
    private static Log log = LogFactory.getLog((Class)RampartEngine.class);
    private static Log tlog = LogFactory.getLog((String)"org.apache.rampart.TIME");

    public Vector process(MessageContext msgCtx) throws WSSPolicyException, RampartException, WSSecurityException, AxisFault {
        boolean doDebug = log.isDebugEnabled();
        boolean dotDebug = tlog.isDebugEnabled();
        if (doDebug) {
            log.debug((Object)"Enter process(MessageContext msgCtx)");
        }
        RampartMessageData rmd = new RampartMessageData(msgCtx, false);
        RampartPolicyData rpd = rmd.getPolicyData();
        msgCtx.setProperty("rampartPolicyData", (Object)rpd);
        if (rpd == null || this.isSecurityFault(rmd) || !RampartUtil.isSecHeaderRequired(rpd, rmd.isInitiator(), true)) {
            SOAPEnvelope env = Axis2Util.getSOAPEnvelopeFromDOMDocument(rmd.getDocument(), true);
            msgCtx.setEnvelope(env);
            Axis2Util.useDOOM(false);
            if (doDebug) {
                log.debug((Object)"Return process MessageContext msgCtx)");
            }
            return null;
        }
        Vector results = null;
        WSSecurityEngine engine = new WSSecurityEngine();
        ValidatorData data = new ValidatorData(rmd);
        SOAPHeader header = rmd.getMsgContext().getEnvelope().getHeader();
        if (header == null) {
            throw new RampartException("missingSOAPHeader");
        }
        ArrayList headerBlocks = header.getHeaderBlocksWithNSURI("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        SOAPHeaderBlock secHeader = null;
        if (headerBlocks != null) {
            Iterator headerBlocksIterator = headerBlocks.iterator();
            while (headerBlocksIterator.hasNext()) {
                SOAPHeaderBlock elem = (SOAPHeaderBlock)headerBlocksIterator.next();
                if (!elem.getLocalName().equals("Security")) continue;
                secHeader = elem;
                break;
            }
        }
        if (secHeader == null) {
            throw new RampartException("missingSecurityHeader");
        }
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        if (dotDebug) {
            t0 = System.currentTimeMillis();
        }
        String actorValue = secHeader.getAttributeValue(new QName(rmd.getSoapConstants().getEnvelopeURI(), "actor"));
        Crypto signatureCrypto = RampartUtil.getSignatureCrypto(rpd.getRampartConfig(), msgCtx.getAxisService().getClassLoader());
        TokenCallbackHandler tokenCallbackHandler = new TokenCallbackHandler(rmd.getTokenStorage(), RampartUtil.getPasswordCB(rmd));
        if (rpd.isSymmetricBinding()) {
            if (doDebug) {
                log.debug((Object)"Processing security header using SymetricBinding");
            }
            results = engine.processSecurityHeader(rmd.getDocument(), actorValue, (CallbackHandler)tokenCallbackHandler, signatureCrypto);
        } else {
            if (doDebug) {
                log.debug((Object)"Processing security header in normal path");
            }
            results = engine.processSecurityHeader(rmd.getDocument(), actorValue, (CallbackHandler)tokenCallbackHandler, signatureCrypto, RampartUtil.getEncryptionCrypto(rpd.getRampartConfig(), msgCtx.getAxisService().getClassLoader()));
        }
        if (dotDebug) {
            t1 = System.currentTimeMillis();
        }
        for (int j = 0; j < results.size(); ++j) {
            WSSecurityEngineResult wser = (WSSecurityEngineResult)results.get(j);
            Integer actInt = (Integer)wser.get((Object)"action");
            if (8 != actInt) continue;
            SAMLAssertion assertion = (SAMLAssertion)wser.get((Object)"saml-assertion");
            String id = assertion.getId();
            Date created = assertion.getNotBefore();
            Date expires = assertion.getNotOnOrAfter();
            SAMLKeyInfo samlKi = SAMLUtil.getSAMLKeyInfo((SAMLAssertion)assertion, (Crypto)signatureCrypto, (CallbackHandler)tokenCallbackHandler);
            try {
                TokenStorage store = rmd.getTokenStorage();
                if (store.getToken(id) != null) continue;
                Token token = new Token(id, (OMElement)assertion.toDOM(), created, expires);
                token.setSecret(samlKi.getSecret());
                store.add(token);
                continue;
            }
            catch (Exception e) {
                throw new RampartException("errorInAddingTokenIntoStore", e);
            }
        }
        SOAPEnvelope env = Axis2Util.getSOAPEnvelopeFromDOMDocument(rmd.getDocument(), true);
        if (dotDebug) {
            t2 = System.currentTimeMillis();
        }
        msgCtx.setEnvelope(env);
        Axis2Util.useDOOM(false);
        PolicyValidatorCallbackHandler validator = RampartUtil.getPolicyValidatorCB(msgCtx, rpd);
        validator.validate(data, results);
        if (dotDebug) {
            t3 = System.currentTimeMillis();
            tlog.debug((Object)("processHeader by WSSecurityEngine took : " + (t1 - t0) + ", DOOM conversion took :" + (t2 - t1) + ", PolicyBasedResultsValidattor took " + (t3 - t2)));
        }
        if (doDebug) {
            log.debug((Object)"Return process(MessageContext msgCtx)");
        }
        return results;
    }

    private boolean isSecurityFault(RampartMessageData rmd) {
        SOAPFaultValue faultSubCodeValue;
        SOAPFaultSubCode faultSubCode;
        SOAPFaultCode faultCode;
        SOAPEnvelope soapEnvelope = rmd.getMsgContext().getEnvelope();
        SOAPFault soapFault = soapEnvelope.getBody().getFault();
        if (soapFault == null) {
            return false;
        }
        String soapVersionURI = rmd.getMsgContext().getEnvelope().getNamespace().getNamespaceURI();
        return soapVersionURI.equals("http://schemas.xmlsoap.org/soap/envelope/") ? (faultCode = soapFault.getCode()).getTextAsQName().getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") : soapVersionURI.equals("http://www.w3.org/2003/05/soap-envelope") && (faultSubCode = soapFault.getCode().getSubCode()) != null && (faultSubCodeValue = faultSubCode.getValue()) != null && faultSubCodeValue.getTextAsQName().getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
    }
}

