/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.dataretrieval;

import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.dataretrieval.AxisDataLocator;
import org.apache.axis2.dataretrieval.BaseAxisDataLocator;
import org.apache.axis2.dataretrieval.Data;
import org.apache.axis2.dataretrieval.DataRetrievalException;
import org.apache.axis2.dataretrieval.DataRetrievalRequest;
import org.apache.axis2.dataretrieval.OutputForm;
import org.apache.axis2.dataretrieval.ServiceData;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisService2WSDL11;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WSDLDataLocator
extends BaseAxisDataLocator
implements AxisDataLocator {
    private static final Log log = LogFactory.getLog((Class)WSDLDataLocator.class);
    String serviceURL = null;
    AxisService theService = null;
    String request_Identifier = null;

    protected WSDLDataLocator() {
    }

    protected WSDLDataLocator(ServiceData[] data) {
        this.dataList = data;
    }

    public Data[] getData(DataRetrievalRequest request, MessageContext msgContext) throws DataRetrievalException {
        log.trace((Object)"Default WSDL DataLocator getData starts");
        this.request_Identifier = request.getIdentifier();
        this.serviceURL = msgContext.getTo().getAddress();
        OutputForm outputform = request.getOutputForm();
        if (outputform == null) {
            outputform = OutputForm.INLINE_FORM;
        }
        String outputFormString = outputform.getType();
        Data[] output = outputform == OutputForm.INLINE_FORM ? this.outputInlineForm(msgContext, this.dataList) : (outputform == OutputForm.LOCATION_FORM ? this.outputLocationForm(this.dataList) : (outputform == OutputForm.REFERENCE_FORM ? this.outputReferenceForm(msgContext, this.dataList) : this.outputInlineForm(msgContext, this.dataList)));
        if (output == null && log.isTraceEnabled()) {
            log.trace((Object)("Null data return! Data Locator does not know how to handle request for dialect= " + request.getDialect() + " in the form of " + outputFormString));
        }
        log.trace((Object)"Default WSDL DataLocator getData ends");
        return output;
    }

    protected Data[] outputInlineForm(MessageContext msgContext, ServiceData[] dataList) throws DataRetrievalException {
        Data[] result = super.outputInlineForm(msgContext, dataList);
        if (result.length == 0) {
            log.trace((Object)"Default WSDL DataLocator attempt to generates WSDL.");
            if (msgContext == null) {
                throw new DataRetrievalException("MessageContext was not set!");
            }
            this.theService = msgContext.getAxisService();
            this.serviceURL = msgContext.getTo().getAddress();
            if (this.request_Identifier == null || this.request_Identifier.equals(this.theService.getTargetNamespace())) {
                OMElement wsdlElement;
                try {
                    AxisService2WSDL11 axisService2WOM = new AxisService2WSDL11(this.theService);
                    wsdlElement = axisService2WOM.generateOM();
                }
                catch (Exception e) {
                    log.debug((Object)e);
                    throw new DataRetrievalException(e);
                }
                if (wsdlElement != null) {
                    log.trace((Object)"Default WSDL DataLocator successfully generated WSDL.");
                    result = new Data[]{new Data(wsdlElement, null)};
                }
            }
        }
        return result;
    }

    protected Data[] outputLocationForm(ServiceData[] serviceData) throws DataRetrievalException {
        Data[] result = super.outputLocationForm(serviceData);
        if (result.length == 0 && this.request_Identifier == null) {
            result = new Data[]{new Data(this.serviceURL + "?wsdl", null)};
        }
        return result;
    }
}

