/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.catalina.tribes.Member;

public class MembershipManager {
    private final List members = new ArrayList();

    public synchronized void memberAdded(Member member) {
        this.members.add(member);
    }

    public synchronized void memberDisappeared(Member member) {
        this.members.remove(member);
    }

    public synchronized Member[] getMembers() {
        return this.members.toArray(new Member[this.members.size()]);
    }

    public synchronized Member getLongestLivingMember() {
        Member longestLivingMember = null;
        if (this.members.size() > 0) {
            Member member0 = (Member)this.members.get(0);
            long longestAliveTime = member0.getMemberAliveTime();
            longestLivingMember = member0;
            for (int i = 0; i < this.members.size(); ++i) {
                Member member = (Member)this.members.get(i);
                if (longestAliveTime >= member.getMemberAliveTime()) continue;
                longestAliveTime = member.getMemberAliveTime();
                longestLivingMember = member;
            }
        }
        return longestLivingMember;
    }

    public synchronized Member getRandomMember() {
        if (this.members.size() == 0) {
            return null;
        }
        int memberIndex = new Random().nextInt(this.members.size());
        return (Member)this.members.get(memberIndex);
    }
}

