/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.swing.tree;

import de.schlichtherle.io.swing.FileSystemView;
import de.schlichtherle.io.swing.JFileTree;
import java.awt.Component;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class FileTreeCellRenderer
extends DefaultTreeCellRenderer {
    private final JFileTree fileTree;

    public FileTreeCellRenderer(JFileTree fileTree) {
        this.fileTree = fileTree;
    }

    public Icon getOpenIcon() {
        File node = this.fileTree.getEditedNode();
        return node != null ? FileSystemView.getFileSystemView().getSystemIcon(node) : super.getOpenIcon();
    }

    public Icon getClosedIcon() {
        File node = this.fileTree.getEditedNode();
        return node != null ? FileSystemView.getFileSystemView().getSystemIcon(node) : super.getClosedIcon();
    }

    public Icon getLeafIcon() {
        File node = this.fileTree.getEditedNode();
        return node != null ? FileSystemView.getFileSystemView().getSystemIcon(node) : super.getLeafIcon();
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        this.setIcon(FileSystemView.getFileSystemView().getSystemIcon((File)value));
        return this;
    }
}

