/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.xpath;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.xml.JaxpVersion;
import org.springframework.xml.xpath.JaxenXPathExpressionFactory;
import org.springframework.xml.xpath.Jaxp13XPathExpressionFactory;
import org.springframework.xml.xpath.XPathExpression;
import org.springframework.xml.xpath.XPathParseException;

public abstract class XPathExpressionFactory {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$xml$xpath$XPathExpressionFactory == null ? (class$org$springframework$xml$xpath$XPathExpressionFactory = XPathExpressionFactory.class$("org.springframework.xml.xpath.XPathExpressionFactory")) : class$org$springframework$xml$xpath$XPathExpressionFactory));
    private static final String JAXEN_CLASS_NAME = "org.jaxen.XPath";
    private static boolean jaxenAvailable;
    static /* synthetic */ Class class$org$springframework$xml$xpath$XPathExpressionFactory;

    public static XPathExpression createXPathExpression(String expression) throws IllegalStateException, XPathParseException {
        return XPathExpressionFactory.createXPathExpression(expression, Collections.EMPTY_MAP);
    }

    public static XPathExpression createXPathExpression(String expression, Map namespaces) throws IllegalStateException, XPathParseException {
        Assert.hasLength((String)expression, (String)"expression is empty");
        if (JaxpVersion.getJaxpVersion() >= 3) {
            logger.trace((Object)"Creating [javax.xml.xpath.XPathExpression]");
            return Jaxp13XPathExpressionFactory.createXPathExpression(expression, namespaces);
        }
        if (jaxenAvailable) {
            logger.trace((Object)"Creating [org.jaxen.XPath]");
            return JaxenXPathExpressionFactory.createXPathExpression(expression, namespaces);
        }
        throw new IllegalStateException("Could not create XPathExpression: could not locate JAXP 1.3, or Jaxen on the class path");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            ClassUtils.forName((String)JAXEN_CLASS_NAME);
            jaxenAvailable = true;
        }
        catch (ClassNotFoundException ex) {
            jaxenAvailable = false;
        }
    }
}

