/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.stream;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.springframework.xml.namespace.QNameUtils;
import org.springframework.xml.stream.AbstractStaxXmlReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class StaxStreamXmlReader
extends AbstractStaxXmlReader {
    private final XMLStreamReader reader;

    public StaxStreamXmlReader(XMLStreamReader reader) {
        int event = reader.getEventType();
        if (event != 7 && event != 1) {
            throw new IllegalStateException("XMLEventReader not at start of document or element");
        }
        this.reader = reader;
    }

    protected void parseInternal() throws SAXException, XMLStreamException {
        boolean documentStarted = false;
        boolean documentEnded = false;
        int elementDepth = 0;
        int eventType = this.reader.getEventType();
        while (true) {
            if (eventType != 7 && eventType != 8 && !documentStarted) {
                this.handleStartDocument();
                documentStarted = true;
            }
            switch (eventType) {
                case 1: {
                    ++elementDepth;
                    this.handleStartElement();
                    break;
                }
                case 2: {
                    if (--elementDepth < 0) break;
                    this.handleEndElement();
                    break;
                }
                case 3: {
                    this.handleProcessingInstruction();
                    break;
                }
                case 4: 
                case 6: 
                case 12: {
                    this.handleCharacters();
                    break;
                }
                case 7: {
                    this.setLocator(this.reader.getLocation());
                    this.handleStartDocument();
                    documentStarted = true;
                    break;
                }
                case 8: {
                    this.handleEndDocument();
                    documentEnded = true;
                }
            }
            if (!this.reader.hasNext() || elementDepth < 0) break;
            eventType = this.reader.next();
        }
        if (!documentEnded) {
            this.handleEndDocument();
        }
    }

    private void handleCharacters() throws SAXException {
        if (this.getContentHandler() != null) {
            if (this.reader.isWhiteSpace()) {
                this.getContentHandler().ignorableWhitespace(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
            } else {
                this.getContentHandler().characters(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
            }
        }
    }

    private void handleEndDocument() throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().endDocument();
        }
    }

    private void handleEndElement() throws SAXException {
        if (this.getContentHandler() != null) {
            QName qName = this.reader.getName();
            this.getContentHandler().endElement(qName.getNamespaceURI(), qName.getLocalPart(), QNameUtils.toQualifiedName(qName));
            for (int i = 0; i < this.reader.getNamespaceCount(); ++i) {
                String prefix = this.reader.getNamespacePrefix(i);
                if (prefix == null) {
                    prefix = "";
                }
                this.getContentHandler().endPrefixMapping(prefix);
            }
        }
    }

    private void handleProcessingInstruction() throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().processingInstruction(this.reader.getPITarget(), this.reader.getPIData());
        }
    }

    private void handleStartDocument() throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().startDocument();
        }
    }

    private void handleStartElement() throws SAXException {
        if (this.getContentHandler() != null) {
            for (int i = 0; i < this.reader.getNamespaceCount(); ++i) {
                String prefix = this.reader.getNamespacePrefix(i);
                if (prefix == null) {
                    prefix = "";
                }
                this.getContentHandler().startPrefixMapping(prefix, this.reader.getNamespaceURI(i));
            }
            QName qName = this.reader.getName();
            this.getContentHandler().startElement(qName.getNamespaceURI(), qName.getLocalPart(), QNameUtils.toQualifiedName(qName), this.getAttributes());
        }
    }

    private Attributes getAttributes() {
        AttributesImpl attributes = new AttributesImpl();
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String type;
            String namespace = this.reader.getAttributeNamespace(i);
            if (namespace == null) {
                namespace = "";
            }
            if ((type = this.reader.getAttributeType(i)) == null) {
                type = "";
            }
            attributes.addAttribute(namespace, this.reader.getAttributeLocalName(i), QNameUtils.toQualifiedName(this.reader.getAttributeName(i)), type, this.reader.getAttributeValue(i));
        }
        return attributes;
    }
}

