/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.stream;

import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.springframework.xml.sax.AbstractXmlReader;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractStaxXmlReader
extends AbstractXmlReader {
    public final void parse(InputSource ignored) throws SAXException {
        this.parse();
    }

    public final void parse(String ignored) throws SAXException {
        this.parse();
    }

    private void parse() throws SAXException {
        try {
            this.parseInternal();
        }
        catch (XMLStreamException ex) {
            StaxLocator locator = null;
            if (ex.getLocation() != null) {
                locator = new StaxLocator(ex.getLocation());
            }
            SAXParseException saxException = new SAXParseException(ex.getMessage(), locator, ex);
            if (this.getErrorHandler() != null) {
                this.getErrorHandler().fatalError(saxException);
            }
            throw saxException;
        }
    }

    protected void setLocator(Location location) {
        if (this.getContentHandler() != null) {
            this.getContentHandler().setDocumentLocator(new StaxLocator(location));
        }
    }

    protected abstract void parseInternal() throws SAXException, XMLStreamException;

    private static class StaxLocator
    implements Locator {
        private Location location;

        protected StaxLocator(Location location) {
            this.location = location;
        }

        public String getPublicId() {
            return this.location.getPublicId();
        }

        public String getSystemId() {
            return this.location.getSystemId();
        }

        public int getLineNumber() {
            return this.location.getLineNumber();
        }

        public int getColumnNumber() {
            return this.location.getColumnNumber();
        }
    }
}

