/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.vfs;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.impl.StandardFileSystemManager;
import org.apache.synapse.transport.base.AbstractTransportSender;
import org.apache.synapse.transport.base.BaseUtils;
import org.apache.synapse.transport.base.ManagementSupport;
import org.apache.synapse.transport.vfs.VFSOutTransportInfo;
import org.apache.synapse.transport.vfs.VFSUtils;

public class VFSTransportSender
extends AbstractTransportSender
implements ManagementSupport {
    public static final String TRANSPORT_NAME = "vfs";
    private FileSystemManager fsManager = null;

    public VFSTransportSender() {
        this.log = LogFactory.getLog(VFSTransportSender.class);
    }

    public void init(ConfigurationContext cfgCtx, TransportOutDescription transportOut) throws AxisFault {
        this.setTransportName(TRANSPORT_NAME);
        super.init(cfgCtx, transportOut);
        try {
            StandardFileSystemManager fsm = new StandardFileSystemManager();
            fsm.setConfiguration(this.getClass().getClassLoader().getResource("providers.xml"));
            fsm.init();
            this.fsManager = fsm;
        }
        catch (FileSystemException e) {
            this.handleException("Error initializing the file transport : " + e.getMessage(), (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(MessageContext msgCtx, String targetAddress, OutTransportInfo outTransportInfo) throws AxisFault {
        VFSOutTransportInfo vfsOutInfo = null;
        if (targetAddress != null) {
            vfsOutInfo = new VFSOutTransportInfo(targetAddress);
        } else if (outTransportInfo != null && outTransportInfo instanceof VFSOutTransportInfo) {
            vfsOutInfo = (VFSOutTransportInfo)outTransportInfo;
        }
        if (vfsOutInfo != null) {
            FileObject replyFile = null;
            try {
                boolean wasError = true;
                int retryCount = 0;
                int maxRetryCount = VFSUtils.getMaxRetryCount(msgCtx, vfsOutInfo);
                long reconnectionTimeout = VFSUtils.getReconnectTimout(msgCtx, vfsOutInfo);
                boolean append = vfsOutInfo.isAppend();
                while (wasError) {
                    block27: {
                        try {
                            ++retryCount;
                            replyFile = this.fsManager.resolveFile(vfsOutInfo.getOutFileURI());
                            if (replyFile == null) {
                                this.log.error((Object)"replyFile is null");
                                throw new FileSystemException("replyFile is null");
                            }
                            wasError = false;
                        }
                        catch (FileSystemException e) {
                            this.log.error((Object)"cannot resolve replyFile", (Throwable)e);
                            if (maxRetryCount > retryCount) break block27;
                            this.handleException("cannot resolve replyFile repeatedly: " + e.getMessage(), (Exception)((Object)e));
                        }
                    }
                    if (!wasError) continue;
                    try {
                        Thread.sleep(reconnectionTimeout);
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                }
                if (replyFile.exists()) {
                    if (replyFile.getType() == FileType.FOLDER) {
                        FileObject responseFile = this.fsManager.resolveFile(replyFile, VFSUtils.getFileName(msgCtx, vfsOutInfo));
                        if (!responseFile.exists()) {
                            responseFile.createFile();
                        }
                        this.populateResponseFile(responseFile, msgCtx, append);
                    }
                    if (replyFile.getType() == FileType.FILE) {
                        this.populateResponseFile(replyFile, msgCtx, append);
                    }
                    this.handleException("Unsupported reply file type : " + replyFile.getType() + " for file : " + vfsOutInfo.getOutFileURI());
                }
                replyFile.createFile();
                this.populateResponseFile(replyFile, msgCtx, append);
            }
            catch (FileSystemException e) {
                this.handleException("Error resolving reply file : " + vfsOutInfo.getOutFileURI(), (Exception)((Object)e));
            }
            finally {
                if (replyFile != null) {
                    try {
                        replyFile.close();
                    }
                    catch (FileSystemException ignore) {}
                }
            }
        } else {
            this.handleException("Unable to determine out transport information to send message");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateResponseFile(FileObject responseFile, MessageContext msgContext, boolean append) throws AxisFault {
        MessageFormatter messageFormatter = BaseUtils.getMessageFormatter(msgContext);
        OMOutputFormat format = BaseUtils.getOMOutputFormat(msgContext);
        try {
            CountingOutputStream os = new CountingOutputStream(responseFile.getContent().getOutputStream(append));
            try {
                messageFormatter.writeTo(msgContext, format, (OutputStream)os, true);
            }
            finally {
                os.close();
            }
            this.metrics.incrementMessagesSent();
            this.metrics.incrementBytesSent(os.getByteCount());
        }
        catch (FileSystemException e) {
            this.metrics.incrementFaultsSending();
            this.handleException("IO Error while creating response file : " + responseFile.getName(), (Exception)((Object)e));
        }
        catch (IOException e) {
            this.metrics.incrementFaultsSending();
            this.handleException("IO Error while creating response file : " + responseFile.getName(), e);
        }
    }
}

