/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.vfs;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VFSOutTransportInfo
implements OutTransportInfo {
    private static final Log log = LogFactory.getLog(VFSOutTransportInfo.class);
    private String outFileURI = null;
    private String outFileName = null;
    private String contentType = null;
    private int maxRetryCount = 3;
    private long reconnectTimeout = 30000L;
    private boolean append;

    VFSOutTransportInfo(String outFileURI) {
        this.outFileURI = outFileURI.startsWith("vfs:") ? outFileURI.substring("vfs:".length()) : outFileURI;
        Map properties = VFSOutTransportInfo.getProperties(outFileURI);
        if (properties.containsKey("transport.vfs.MaxRetryCount")) {
            String strMaxRetryCount = (String)properties.get("transport.vfs.MaxRetryCount");
            this.maxRetryCount = Integer.parseInt(strMaxRetryCount);
        }
        if (properties.containsKey("transport.vfs.ReconnectTimeout")) {
            String strReconnectTimeout = (String)properties.get("transport.vfs.ReconnectTimeout");
            this.reconnectTimeout = Long.parseLong(strReconnectTimeout) * 1000L;
        }
        if (properties.containsKey("transport.vfs.Append")) {
            String strAppend = (String)properties.get("transport.vfs.Append");
            this.append = Boolean.parseBoolean(strAppend);
        }
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getOutFileURI() {
        return this.outFileURI;
    }

    public String getOutFileName() {
        return this.outFileName;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public void setMaxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
    }

    public long getReconnectTimeout() {
        return this.reconnectTimeout;
    }

    public void setReconnectTimeout(long reconnectTimeout) {
        this.reconnectTimeout = reconnectTimeout;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public static Map getProperties(String url) {
        HashMap<String, String> h = new HashMap<String, String>();
        int propPos = url.indexOf("?");
        if (propPos != -1) {
            StringTokenizer st = new StringTokenizer(url.substring(propPos + 1), "&");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int sep = token.indexOf("=");
                if (sep == -1) continue;
                h.put(token.substring(0, sep), token.substring(sep + 1));
            }
        }
        return h;
    }
}

