/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.udp;

import org.apache.commons.lang.StringUtils;

public class Utils {
    private Utils() {
    }

    public static void hexDump(StringBuilder buffer, byte[] data, int length) {
        for (int start = 0; start < length; start += 16) {
            int index;
            int i;
            for (i = 0; i < 16; ++i) {
                index = start + i;
                if (index < length) {
                    buffer.append(StringUtils.leftPad((String)Integer.toHexString(data[start + i]), (int)2, (char)'0'));
                } else {
                    buffer.append("  ");
                }
                buffer.append(' ');
                if (i != 8) continue;
                buffer.append(' ');
            }
            buffer.append(" |");
            for (i = 0; i < 16; ++i) {
                index = start + i;
                if (index < length) {
                    int b = data[index] & 0xFF;
                    if (32 <= b && b < 128) {
                        buffer.append((char)b);
                        continue;
                    }
                    buffer.append('.');
                    continue;
                }
                buffer.append(' ');
            }
            buffer.append('|');
            buffer.append('\n');
        }
    }
}

