/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.udp;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.synapse.transport.base.AbstractTransportListener;
import org.apache.synapse.transport.base.ManagementSupport;
import org.apache.synapse.transport.udp.Endpoint;
import org.apache.synapse.transport.udp.IODispatcher;

public class UDPListener
extends AbstractTransportListener
implements ManagementSupport {
    private final Map<String, Endpoint> endpoints = new HashMap<String, Endpoint>();
    private IODispatcher dispatcher;

    public void init(ConfigurationContext cfgCtx, TransportInDescription transportIn) throws AxisFault {
        this.setTransportName("udp");
        super.init(cfgCtx, transportIn);
        try {
            this.dispatcher = new IODispatcher(this.workerPool);
        }
        catch (IOException ex) {
            throw new AxisFault("Unable to create selector", (Throwable)ex);
        }
        new Thread((Runnable)this.dispatcher, this.getTransportName() + "-dispatcher").start();
    }

    public void destroy() {
        super.destroy();
        try {
            this.dispatcher.stop();
        }
        catch (IOException ex) {
            this.log.error((Object)"Failed to stop dispatcher", (Throwable)ex);
        }
    }

    protected void startListeningForService(AxisService service) {
        int port;
        Parameter param = service.getParameter("transport.udp.port");
        if (param == null) {
            this.log.info((Object)("No UDP port number specified for service " + service.getName() + "; disabling transport for this service"));
            this.disableTransportForService(service);
            return;
        }
        try {
            port = Integer.parseInt(param.getValue().toString());
        }
        catch (NumberFormatException ex) {
            this.log.error((Object)("Invalid port number " + param.getValue() + " for service " + service.getName()));
            this.disableTransportForService(service);
            return;
        }
        int maxPacketSize = 1024;
        param = service.getParameter("transport.udp.maxPacketSize");
        if (param != null) {
            try {
                maxPacketSize = Integer.parseInt(param.getValue().toString());
            }
            catch (NumberFormatException ex) {
                this.log.warn((Object)("Invalid maximum packet size; falling back to default value " + maxPacketSize));
            }
        }
        if ((param = service.getParameter("transport.udp.contentType")) == null) {
            this.log.info((Object)("No content type specified for service " + service.getName() + "; disabling transport for this service"));
            this.disableTransportForService(service);
            return;
        }
        String contentType = (String)param.getValue();
        Endpoint endpoint = new Endpoint(this, port, contentType, maxPacketSize, service, this.metrics);
        try {
            this.dispatcher.addEndpoint(endpoint);
        }
        catch (IOException ex) {
            this.log.error((Object)("Unable to listen on port " + port), (Throwable)ex);
            this.disableTransportForService(service);
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Started listening on port " + port + " [contentType=" + contentType + "; maxPacketSize=" + maxPacketSize + "; service=" + service.getName() + "]"));
        }
        this.endpoints.put(service.getName(), endpoint);
    }

    protected void stopListeningForService(AxisService service) {
        try {
            this.dispatcher.removeEndpoint(service.getName());
        }
        catch (IOException ex) {
            this.log.error((Object)("I/O exception while stopping listener for service " + service.getName()), (Throwable)ex);
        }
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        Endpoint endpoint = this.endpoints.get(serviceName);
        if (endpoint == null) {
            return null;
        }
        return new EndpointReference[]{endpoint.getEndpointReference(ip)};
    }
}

