/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.udp;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.base.MetricsCollector;
import org.apache.synapse.transport.udp.Endpoint;
import org.apache.synapse.transport.udp.Utils;

public class ProcessPacketTask
implements Runnable {
    private static final Log log = LogFactory.getLog(ProcessPacketTask.class);
    private final Endpoint endpoint;
    private final byte[] data;
    private final int length;

    public ProcessPacketTask(Endpoint endpoint, byte[] data, int length) {
        this.endpoint = endpoint;
        this.data = data;
        this.length = length;
    }

    public void run() {
        MetricsCollector metrics = this.endpoint.getMetrics();
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(this.data, 0, this.length);
            MessageContext msgContext = this.endpoint.getListener().createMessageContext();
            msgContext.setAxisService(this.endpoint.getService());
            SOAPEnvelope envelope = TransportUtils.createSOAPMessage((MessageContext)msgContext, (InputStream)inputStream, (String)this.endpoint.getContentType());
            msgContext.setEnvelope(envelope);
            AxisEngine.receive((MessageContext)msgContext);
            metrics.incrementMessagesReceived();
            metrics.incrementBytesReceived(this.length);
        }
        catch (Exception ex) {
            metrics.incrementFaultsReceiving();
            StringBuilder buffer = new StringBuilder("Error during processing of UDP packet:\n");
            Utils.hexDump(buffer, this.data, this.length);
            log.error((Object)buffer.toString(), (Throwable)ex);
        }
    }
}

