/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.udp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.base.threads.WorkerPool;
import org.apache.synapse.transport.udp.Endpoint;
import org.apache.synapse.transport.udp.ProcessPacketTask;

public class IODispatcher
implements Runnable {
    private static final Log log = LogFactory.getLog(IODispatcher.class);
    private final WorkerPool workerPool;
    private final Selector selector;
    private final Queue<SelectorOperation> selectorOperationQueue = new ConcurrentLinkedQueue<SelectorOperation>();

    public IODispatcher(WorkerPool workerPool) throws IOException {
        this.workerPool = workerPool;
        this.selector = Selector.open();
    }

    public void addEndpoint(final Endpoint endpoint) throws IOException {
        final DatagramChannel channel = DatagramChannel.open();
        channel.socket().bind(new InetSocketAddress(endpoint.getPort()));
        channel.configureBlocking(false);
        this.execute(new SelectorOperation(){

            public void doExecute(Selector selector) throws IOException {
                channel.register(selector, 1, endpoint);
            }
        });
    }

    public void removeEndpoint(final String serviceName) throws IOException {
        this.execute(new SelectorOperation(){

            public void doExecute(Selector selector) throws IOException {
                for (SelectionKey key : selector.keys()) {
                    Endpoint endpoint = (Endpoint)key.attachment();
                    if (!serviceName.equals(endpoint.getService().getName())) continue;
                    key.cancel();
                    key.channel().close();
                    break;
                }
            }
        });
    }

    public void stop() throws IOException {
        this.execute(new SelectorOperation(){

            public void doExecute(Selector selector) throws IOException {
                IOException exception;
                block6: {
                    exception = null;
                    for (SelectionKey key : selector.keys()) {
                        try {
                            key.channel().close();
                        }
                        catch (IOException ex) {
                            if (exception != null) continue;
                            exception = ex;
                        }
                    }
                    try {
                        selector.close();
                    }
                    catch (IOException ex) {
                        if (exception != null) break block6;
                        exception = ex;
                    }
                }
                if (exception != null) {
                    throw exception;
                }
            }
        });
    }

    public void run() {
        block2: while (true) {
            SelectorOperation request;
            try {
                this.selector.select();
            }
            catch (IOException ex) {
                log.error((Object)"Exception in select; I/O dispatcher will be shut down", (Throwable)ex);
                return;
            }
            while ((request = this.selectorOperationQueue.poll()) != null) {
                request.execute(this.selector);
                if (this.selector.isOpen()) continue;
                return;
            }
            Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
            while (true) {
                if (!it.hasNext()) continue block2;
                SelectionKey key = it.next();
                it.remove();
                if (!key.isValid() || !key.isReadable()) continue;
                this.receive((Endpoint)key.attachment(), (DatagramChannel)key.channel());
            }
            break;
        }
    }

    private void execute(SelectorOperation operation) throws IOException {
        this.selectorOperationQueue.add(operation);
        this.selector.wakeup();
        boolean interrupted = false;
        while (true) {
            try {
                operation.waitForCompletion();
                return;
            }
            catch (InterruptedException ex) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void receive(Endpoint endpoint, DatagramChannel channel) {
        try {
            byte[] data = new byte[endpoint.getMaxPacketSize()];
            ByteBuffer buffer = ByteBuffer.wrap(data);
            SocketAddress address = channel.receive(buffer);
            int length = buffer.position();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received packet from " + address + " with length " + length));
            }
            this.workerPool.execute(new ProcessPacketTask(endpoint, data, length));
        }
        catch (IOException ex) {
            endpoint.getMetrics().incrementFaultsReceiving();
            log.error((Object)"Error receiving UDP packet", (Throwable)ex);
        }
    }

    private static abstract class SelectorOperation {
        private final CountDownLatch done = new CountDownLatch(1);
        private IOException exception;

        private SelectorOperation() {
        }

        public void waitForCompletion() throws IOException, InterruptedException {
            this.done.await();
            if (this.exception != null) {
                throw this.exception;
            }
        }

        public void execute(Selector selector) {
            try {
                this.doExecute(selector);
            }
            catch (IOException ex) {
                this.exception = ex;
            }
            catch (Throwable ex) {
                this.exception = new IOException("Unexpected exception");
                this.exception.initCause(ex);
            }
            this.done.countDown();
        }

        public abstract void doExecute(Selector var1) throws IOException;
    }
}

