/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.udp;

import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.description.AxisService;
import org.apache.synapse.transport.base.MetricsCollector;
import org.apache.synapse.transport.udp.UDPListener;

public class Endpoint {
    private final UDPListener listener;
    private final int port;
    private final String contentType;
    private final int maxPacketSize;
    private final AxisService service;
    private final MetricsCollector metrics;

    public Endpoint(UDPListener listener, int port, String contentType, int maxPacketSize, AxisService service, MetricsCollector metrics) {
        this.listener = listener;
        this.port = port;
        this.contentType = contentType;
        this.maxPacketSize = maxPacketSize;
        this.service = service;
        this.metrics = metrics;
    }

    public UDPListener getListener() {
        return this.listener;
    }

    public int getPort() {
        return this.port;
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public AxisService getService() {
        return this.service;
    }

    public MetricsCollector getMetrics() {
        return this.metrics;
    }

    public EndpointReference getEndpointReference(String ip) {
        return new EndpointReference("udp://" + ip + ":" + this.getPort() + "?contentType=" + this.contentType);
    }
}

