/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResponseAcceptEncodingProcessor {
    private static final Log log = LogFactory.getLog(ResponseAcceptEncodingProcessor.class);
    private static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static final String GZIP_CODEC = "gzip";

    public static void process(MessageContext response, MessageContext request) {
        Map headers;
        String encode;
        if (response == null) {
            throw new IllegalArgumentException("Response Message Context cannot be null");
        }
        if (request == null) {
            throw new IllegalArgumentException("Request Message context cannot be null");
        }
        Object o = request.getProperty("TRANSPORT_HEADERS");
        if (o != null && o instanceof Map && (encode = (String)(headers = (Map)o).get(ACCEPT_ENCODING)) != null && GZIP_CODEC.equals(encode)) {
            Map<String, String> responseHeaders;
            Object obj = response.getProperty("TRANSPORT_HEADERS");
            if (obj != null && obj instanceof Map) {
                responseHeaders = (Map)obj;
            } else {
                responseHeaders = new HashMap();
                response.setProperty("TRANSPORT_HEADERS", responseHeaders);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Sets the 'Content-Encoding' header as ' gzip '");
            }
            responseHeaders.put("Content-Encoding", GZIP_CODEC);
        }
    }
}

