/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.http.HTTPTransportReceiver;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.util.RESTUtil;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.synapse.transport.base.MetricsCollector;
import org.apache.synapse.transport.nhttp.HttpCoreRequestResponseTransport;
import org.apache.synapse.transport.nhttp.ServerHandler;
import org.apache.ws.commons.schema.XmlSchema;

public class ServerWorker
implements Runnable {
    private static final Log log = LogFactory.getLog(ServerWorker.class);
    private MessageContext msgContext = null;
    private ConfigurationContext cfgCtx = null;
    private ServerHandler serverHandler = null;
    private NHttpServerConnection conn = null;
    private boolean isHttps = false;
    private HttpRequest request = null;
    private HttpResponse response = null;
    private InputStream is = null;
    private OutputStream os = null;
    private MetricsCollector metrics = null;
    private static final String SOAPACTION = "SOAPAction";
    private static final String LOCATION = "Location";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String TEXT_HTML = "text/html";
    private static final String TEXT_XML = "text/xml";

    public ServerWorker(ConfigurationContext cfgCtx, NHttpServerConnection conn, boolean isHttps, MetricsCollector metrics, ServerHandler serverHandler, HttpRequest request, InputStream is, HttpResponse response, OutputStream os) {
        this.cfgCtx = cfgCtx;
        this.conn = conn;
        this.isHttps = isHttps;
        this.metrics = metrics;
        this.serverHandler = serverHandler;
        this.request = request;
        this.response = response;
        this.is = is;
        this.os = os;
        this.msgContext = this.createMessageContext(request);
    }

    private MessageContext createMessageContext(HttpRequest request) {
        HttpInetConnection inetConn;
        InetAddress remoteAddr;
        MessageContext msgContext = new MessageContext();
        msgContext.setMessageID(UUIDGenerator.getUUID());
        msgContext.setProperty("transportNonBlocking", (Object)Boolean.FALSE);
        msgContext.setConfigurationContext(this.cfgCtx);
        if (this.isHttps) {
            msgContext.setTransportOut(this.cfgCtx.getAxisConfiguration().getTransportOut("https"));
            msgContext.setTransportIn(this.cfgCtx.getAxisConfiguration().getTransportIn("https"));
            msgContext.setIncomingTransportName("https");
        } else {
            msgContext.setTransportOut(this.cfgCtx.getAxisConfiguration().getTransportOut("http"));
            msgContext.setTransportIn(this.cfgCtx.getAxisConfiguration().getTransportIn("http"));
            msgContext.setIncomingTransportName("http");
        }
        msgContext.setProperty("OutTransportInfo", (Object)this);
        msgContext.setServiceGroupContextId(UUIDGenerator.getUUID());
        msgContext.setServerSide(true);
        msgContext.setProperty("TransportInURL", (Object)request.getRequestLine().getUri());
        HashMap<String, String> headers = new HashMap<String, String>();
        Header[] headerArr = request.getAllHeaders();
        for (int i = 0; i < headerArr.length; ++i) {
            headers.put(headerArr[i].getName(), headerArr[i].getValue());
        }
        msgContext.setProperty("TRANSPORT_HEADERS", headers);
        if (this.conn instanceof HttpInetConnection && (remoteAddr = (inetConn = (HttpInetConnection)this.conn).getRemoteAddress()) != null) {
            msgContext.setProperty("REMOTE_ADDR", (Object)remoteAddr.getHostAddress());
            msgContext.setProperty("REMOTE_HOST", (Object)remoteAddr.getHostName());
        }
        msgContext.setProperty("RequestResponseTransportControl", (Object)new HttpCoreRequestResponseTransport(msgContext));
        return msgContext;
    }

    public void run() {
        String method = this.request.getRequestLine().getMethod().toUpperCase();
        if ("GET".equals(method)) {
            this.processGet();
        } else if ("POST".equals(method)) {
            this.processPost();
        } else {
            this.handleException("Unsupported method : " + method, null);
        }
        if (this.msgContext != null && this.msgContext.getOperationContext() != null && !this.msgContext.getOperationContext().getAxisOperation().isControlOperation()) {
            String respWritten = (String)this.msgContext.getOperationContext().getProperty("RESPONSE_WRITTEN");
            boolean respWillFollow = !"true".equals(respWritten) && !"SKIP".equals(respWritten);
            boolean acked = ((RequestResponseTransport)this.msgContext.getProperty("RequestResponseTransportControl")).getStatus() == RequestResponseTransport.RequestResponseTransportStatus.ACKED;
            boolean forced = this.msgContext.isPropertyTrue("FORCE_SC_ACCEPTED");
            if (respWillFollow || acked || forced) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending 202 Accepted response for MessageID : " + this.msgContext.getMessageID() + " response written : " + respWritten + " response will follow : " + respWillFollow + " acked : " + acked + " forced ack : " + forced));
                }
                this.response.setStatusCode(202);
                this.serverHandler.commitResponse(this.conn, this.response);
                try {
                    this.is.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                try {
                    this.os.flush();
                    this.os.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
        }
    }

    private void processPost() {
        try {
            Header contentType = this.request.getFirstHeader(CONTENT_TYPE);
            Header soapAction = this.request.getFirstHeader(SOAPACTION);
            HTTPTransportUtils.processHTTPPostRequest((MessageContext)this.msgContext, (InputStream)this.is, (OutputStream)this.os, (String)(contentType != null ? contentType.getValue() : null), (String)(soapAction != null ? soapAction.getValue() : null), (String)this.request.getRequestLine().getUri());
        }
        catch (AxisFault e) {
            this.handleException("Error processing POST request ", (Exception)((Object)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processGet() {
        block39: {
            AxisService service;
            HashMap<String, String> parameters;
            String operation;
            String serviceName;
            block44: {
                block45: {
                    block43: {
                        block42: {
                            block41: {
                                String servicePath;
                                String uri;
                                block40: {
                                    int opnStart;
                                    uri = this.request.getRequestLine().getUri();
                                    String contextPath = this.cfgCtx.getContextRoot();
                                    if (!contextPath.startsWith("/")) {
                                        contextPath = "/" + contextPath;
                                    }
                                    if (!contextPath.endsWith("/")) {
                                        contextPath = contextPath + "/";
                                    }
                                    if (!(servicePath = this.cfgCtx.getServiceContextPath()).startsWith("/")) {
                                        servicePath = "/" + servicePath;
                                    }
                                    serviceName = null;
                                    operation = null;
                                    if (uri.startsWith(servicePath)) {
                                        serviceName = uri.substring(servicePath.length());
                                        if (serviceName.startsWith("/")) {
                                            serviceName = serviceName.substring(1);
                                        }
                                        if (serviceName.indexOf("?") != -1) {
                                            serviceName = serviceName.substring(0, serviceName.indexOf("?"));
                                        }
                                    }
                                    if (serviceName != null && (opnStart = serviceName.indexOf("/")) != -1) {
                                        operation = serviceName.substring(opnStart + 1);
                                        serviceName = serviceName.substring(0, opnStart);
                                    }
                                    parameters = new HashMap<String, String>();
                                    int pos = uri.indexOf("?");
                                    if (pos != -1) {
                                        StringTokenizer st = new StringTokenizer(uri.substring(pos + 1), "&");
                                        while (st.hasMoreTokens()) {
                                            String param = st.nextToken();
                                            pos = param.indexOf("=");
                                            if (pos != -1) {
                                                parameters.put(param.substring(0, pos), param.substring(pos + 1));
                                                continue;
                                            }
                                            parameters.put(param, null);
                                        }
                                    }
                                    if ("GET".equalsIgnoreCase(this.request.getRequestLine().getMethod())) {
                                        this.msgContext.setProperty("HTTP_METHOD", (Object)"GET");
                                    }
                                    if (!uri.equals("/favicon.ico")) break block40;
                                    this.response.setStatusCode(301);
                                    this.response.addHeader(LOCATION, "http://ws.apache.org/favicon.ico");
                                    this.serverHandler.commitResponse(this.conn, this.response);
                                    break block39;
                                }
                                if (uri.startsWith(servicePath)) break block41;
                                this.response.setStatusCode(301);
                                this.response.addHeader(LOCATION, servicePath + "/");
                                this.serverHandler.commitResponse(this.conn, this.response);
                                break block39;
                            }
                            if (serviceName == null || !parameters.containsKey("wsdl")) break block42;
                            service = (AxisService)this.cfgCtx.getAxisConfiguration().getServices().get(serviceName);
                            if (service != null) {
                                try {
                                    this.response.addHeader(CONTENT_TYPE, TEXT_XML);
                                    this.serverHandler.commitResponse(this.conn, this.response);
                                    service.printWSDL(this.os, ServerWorker.getIpAddress());
                                }
                                catch (AxisFault e) {
                                    this.handleException("Axis2 fault writing ?wsdl output", (Exception)((Object)e));
                                    return;
                                }
                                catch (SocketException e) {
                                    this.handleException("Error getting ip address for ?wsdl output", e);
                                    return;
                                }
                            }
                            break block39;
                        }
                        if (serviceName == null || !parameters.containsKey("wsdl2")) break block43;
                        service = (AxisService)this.cfgCtx.getAxisConfiguration().getServices().get(serviceName);
                        if (service != null) {
                            try {
                                this.response.addHeader(CONTENT_TYPE, TEXT_XML);
                                this.serverHandler.commitResponse(this.conn, this.response);
                                service.printWSDL2(this.os, ServerWorker.getIpAddress());
                            }
                            catch (AxisFault e) {
                                this.handleException("Axis2 fault writing ?wsdl2 output", (Exception)((Object)e));
                                return;
                            }
                            catch (SocketException e) {
                                this.handleException("Error getting ip address for ?wsdl2 output", e);
                                return;
                            }
                        }
                        break block39;
                    }
                    if (serviceName == null || !parameters.containsKey("xsd")) break block44;
                    if (parameters.get("xsd") != null && !"".equals(parameters.get("xsd"))) break block45;
                    service = (AxisService)this.cfgCtx.getAxisConfiguration().getServices().get(serviceName);
                    if (service != null) {
                        try {
                            this.response.addHeader(CONTENT_TYPE, TEXT_XML);
                            this.serverHandler.commitResponse(this.conn, this.response);
                            service.printSchema(this.os);
                        }
                        catch (AxisFault axisFault) {
                            this.handleException("Error writing ?xsd output to client", (Exception)((Object)axisFault));
                            return;
                        }
                    }
                    break block39;
                }
                String schemaName = (String)parameters.get("xsd");
                AxisService service2 = (AxisService)this.cfgCtx.getAxisConfiguration().getServices().get(serviceName);
                if (service2 != null) {
                    int dotIndex;
                    service2.populateSchemaMappings();
                    Map schemaTable = service2.getSchemaMappingTable();
                    XmlSchema schema = (XmlSchema)schemaTable.get(schemaName);
                    if (schema == null && (dotIndex = schemaName.indexOf(46)) > 0) {
                        String schemaKey = schemaName.substring(0, dotIndex);
                        schema = (XmlSchema)schemaTable.get(schemaKey);
                    }
                    if (schema != null) {
                        this.response.addHeader(CONTENT_TYPE, TEXT_XML);
                        this.serverHandler.commitResponse(this.conn, this.response);
                        schema.write(this.os);
                        break block39;
                    } else {
                        this.response.setStatusCode(404);
                    }
                }
                break block39;
            }
            if (serviceName == null || serviceName.length() == 0) {
                try {
                    this.response.addHeader(CONTENT_TYPE, TEXT_HTML);
                    this.serverHandler.commitResponse(this.conn, this.response);
                    this.os.write(this.getServicesHTML().getBytes());
                }
                catch (IOException e) {
                    this.handleException("Error writing ? output to client", e);
                }
            } else if (parameters.isEmpty() && operation == null) {
                service = (AxisService)this.cfgCtx.getAxisConfiguration().getServices().get(serviceName);
                if (service == null) {
                    this.handleException("Invalid service : " + serviceName, null);
                    return;
                }
                try {
                    this.response.addHeader(CONTENT_TYPE, TEXT_HTML);
                    this.serverHandler.commitResponse(this.conn, this.response);
                    this.os.write(HTTPTransportReceiver.printServiceHTML((String)serviceName, (ConfigurationContext)this.cfgCtx).getBytes());
                }
                catch (IOException e) {
                    this.handleException("Error writing service HTML to client", e);
                    return;
                }
            } else {
                try {
                    Header contentType = this.request.getFirstHeader(CONTENT_TYPE);
                    RESTUtil.processURLRequest((MessageContext)this.msgContext, (OutputStream)this.os, (String)(contentType != null ? contentType.getValue() : null));
                    return;
                }
                catch (AxisFault axisFault) {
                    this.handleException("Error processing GET request for: " + this.request.getRequestLine().getUri(), (Exception)((Object)axisFault));
                }
            }
        }
        try {
            this.os.flush();
            this.os.close();
            return;
        }
        catch (IOException ignore) {
            // empty catch block
        }
    }

    private void handleException(String msg, Exception e) {
        block10: {
            if (e == null) {
                log.error((Object)msg);
            } else {
                log.error((Object)msg, (Throwable)e);
            }
            if (e == null) {
                e = new Exception(msg);
            }
            try {
                MessageContext faultContext = MessageContextBuilder.createFaultMessageContext((MessageContext)this.msgContext, (Throwable)e);
                AxisEngine.sendFault((MessageContext)faultContext);
            }
            catch (Exception ex) {
                this.response.setStatusCode(500);
                this.response.addHeader(CONTENT_TYPE, TEXT_XML);
                this.serverHandler.commitResponse(this.conn, this.response);
                try {
                    this.os.write(msg.getBytes());
                    if (ex != null) {
                        this.os.write(ex.getMessage().getBytes());
                    }
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                if (this.conn == null) break block10;
                try {
                    this.conn.shutdown();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
        }
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public InputStream getIs() {
        return this.is;
    }

    public ServerHandler getServiceHandler() {
        return this.serverHandler;
    }

    public NHttpServerConnection getConn() {
        return this.conn;
    }

    private static String getIpAddress() throws SocketException {
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        String address = "127.0.0.1";
        while (e.hasMoreElements()) {
            NetworkInterface netface = e.nextElement();
            Enumeration<InetAddress> addresses = netface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress ip = addresses.nextElement();
                if (ip.isLoopbackAddress() || !ServerWorker.isIP(ip.getHostAddress())) continue;
                return ip.getHostAddress();
            }
        }
        return address;
    }

    private static boolean isIP(String hostAddress) {
        return hostAddress.split("[.]").length == 4;
    }

    public String getServicesHTML() {
        HashMap services = this.cfgCtx.getAxisConfiguration().getServices();
        Hashtable erroneousServices = this.cfgCtx.getAxisConfiguration().getFaultyServices();
        boolean servicesFound = false;
        StringBuffer resultBuf = new StringBuffer();
        resultBuf.append("<html><head><title>Axis2: Services</title></head><body>");
        if (services != null && !services.isEmpty()) {
            servicesFound = true;
            Collection serviceCollection = services.values();
            resultBuf.append("<h2>Deployed services</h2>");
            for (AxisService axisService : serviceCollection) {
                if (axisService.getName().startsWith("__")) continue;
                Iterator iterator = axisService.getOperations();
                resultBuf.append("<h3><a href=\"" + axisService.getName() + "?wsdl\">" + axisService.getName() + "</a></h3>");
                if (iterator.hasNext()) {
                    resultBuf.append("Available operations <ul>");
                    while (iterator.hasNext()) {
                        AxisOperation axisOperation = (AxisOperation)iterator.next();
                        resultBuf.append("<li>" + axisOperation.getName().getLocalPart() + "</li>");
                    }
                    resultBuf.append("</ul>");
                    continue;
                }
                resultBuf.append("No operations specified for this service");
            }
        }
        if (erroneousServices != null && !erroneousServices.isEmpty()) {
            servicesFound = true;
            resultBuf.append("<hr><h2><font color=\"blue\">Faulty Services</font></h2>");
            Enumeration faultyservices = erroneousServices.keys();
            while (faultyservices.hasMoreElements()) {
                String faultyserviceName = (String)faultyservices.nextElement();
                resultBuf.append("<h3><font color=\"blue\">" + faultyserviceName + "</font></h3>");
            }
        }
        if (!servicesFound) {
            resultBuf.append("<h2>There are no services deployed</h2>");
        }
        resultBuf.append("</body></html>");
        return resultBuf.toString();
    }
}

