/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.nio.entity.ContentInputStream;
import org.apache.http.nio.entity.ContentOutputStream;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.ContentInputBuffer;
import org.apache.http.nio.util.ContentOutputBuffer;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.nio.util.SharedOutputBuffer;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.http.util.EncodingUtils;
import org.apache.synapse.transport.base.MetricsCollector;
import org.apache.synapse.transport.base.threads.WorkerPool;
import org.apache.synapse.transport.base.threads.WorkerPoolFactory;
import org.apache.synapse.transport.nhttp.NHttpConfiguration;
import org.apache.synapse.transport.nhttp.ServerWorker;
import org.apache.synapse.transport.nhttp.util.SharedInputBuffer;

public class ServerHandler
implements NHttpServiceHandler {
    private static final Log log = LogFactory.getLog(ServerHandler.class);
    private final HttpParams params;
    private final HttpResponseFactory responseFactory;
    private final HttpProcessor httpProcessor;
    private final ConnectionReuseStrategy connStrategy;
    private final ByteBufferAllocator allocator;
    ConfigurationContext cfgCtx = null;
    private NHttpConfiguration cfg = null;
    private boolean isHttps = false;
    private WorkerPool workerPool = null;
    private MetricsCollector metrics = null;
    public static final String REQUEST_SINK_BUFFER = "synapse.request-sink-buffer";
    public static final String RESPONSE_SOURCE_BUFFER = "synapse.response-source-buffer";

    public ServerHandler(ConfigurationContext cfgCtx, HttpParams params, boolean isHttps, MetricsCollector metrics) {
        this.cfgCtx = cfgCtx;
        this.params = params;
        this.isHttps = isHttps;
        this.metrics = metrics;
        this.responseFactory = new DefaultHttpResponseFactory();
        this.httpProcessor = this.getHttpProcessor();
        this.connStrategy = new DefaultConnectionReuseStrategy();
        this.allocator = new HeapByteBufferAllocator();
        this.cfg = NHttpConfiguration.getInstance();
        this.workerPool = WorkerPoolFactory.getWorkerPool(this.cfg.getServerCoreThreads(), this.cfg.getServerMaxThreads(), this.cfg.getServerKeepalive(), this.cfg.getServerQueueLen(), "Server Worker thread group", "HttpServerWorker");
    }

    public void requestReceived(NHttpServerConnection conn) {
        HttpContext context = conn.getContext();
        HttpRequest request = conn.getHttpRequest();
        context.setAttribute("http.request", (Object)request);
        try {
            SharedInputBuffer inputBuffer = new SharedInputBuffer(this.cfg.getBufferSize(), (IOControl)conn, this.allocator);
            SharedOutputBuffer outputBuffer = new SharedOutputBuffer(this.cfg.getBufferSize(), (IOControl)conn, this.allocator);
            context.setAttribute(REQUEST_SINK_BUFFER, (Object)inputBuffer);
            context.setAttribute(RESPONSE_SOURCE_BUFFER, (Object)outputBuffer);
            ProtocolVersion httpVersion = request.getRequestLine().getProtocolVersion();
            HttpResponse response = this.responseFactory.newHttpResponse(httpVersion, 200, context);
            response.setParams(this.params);
            BasicHttpEntity entity = new BasicHttpEntity();
            if (httpVersion.greaterEquals((ProtocolVersion)HttpVersion.HTTP_1_1)) {
                entity.setChunked(true);
            }
            response.setEntity((HttpEntity)entity);
            this.workerPool.execute(new ServerWorker(this.cfgCtx, conn, this.isHttps, this.metrics, this, request, (InputStream)new ContentInputStream((ContentInputBuffer)inputBuffer), response, (OutputStream)new ContentOutputStream((ContentOutputBuffer)outputBuffer)));
        }
        catch (Exception e) {
            this.handleException("Error processing request received for : " + request.getRequestLine().getUri(), e, conn);
        }
    }

    public void inputReady(NHttpServerConnection conn, ContentDecoder decoder) {
        HttpContext context = conn.getContext();
        ContentInputBuffer inBuf = (ContentInputBuffer)context.getAttribute(REQUEST_SINK_BUFFER);
        try {
            int bytesRead = inBuf.consumeContent(decoder);
            if (this.metrics != null && bytesRead > 0) {
                this.metrics.incrementBytesReceived(bytesRead);
            }
            if (decoder.isCompleted() && this.metrics != null) {
                this.metrics.incrementMessagesReceived();
            }
        }
        catch (IOException e) {
            this.handleException("I/O Error : " + e.getMessage(), e, conn);
        }
    }

    public void outputReady(NHttpServerConnection conn, ContentEncoder encoder) {
        HttpContext context = conn.getContext();
        HttpResponse response = conn.getHttpResponse();
        ContentOutputBuffer outBuf = (ContentOutputBuffer)context.getAttribute(RESPONSE_SOURCE_BUFFER);
        try {
            int bytesWritten = outBuf.produceContent(encoder);
            if (this.metrics != null && bytesWritten > 0) {
                this.metrics.incrementBytesSent(bytesWritten);
            }
            if (encoder.isCompleted()) {
                if (this.metrics != null) {
                    this.metrics.incrementMessagesSent();
                }
                if (!this.connStrategy.keepAlive(response, context)) {
                    conn.close();
                } else {
                    conn.requestInput();
                }
            }
        }
        catch (IOException e) {
            this.handleException("I/O Error : " + e.getMessage(), e, conn);
        }
    }

    public void commitResponse(NHttpServerConnection conn, HttpResponse response) {
        try {
            this.httpProcessor.process(response, conn.getContext());
            conn.submitResponse(response);
        }
        catch (HttpException e) {
            this.handleException("Unexpected HTTP protocol error : " + e.getMessage(), (Exception)((Object)e), conn);
        }
        catch (IOException e) {
            this.handleException("IO error submiting response : " + e.getMessage(), e, conn);
        }
    }

    public void timeout(NHttpServerConnection conn) {
        HttpRequest req = (HttpRequest)conn.getContext().getAttribute("http.request");
        if (req != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Connection Timeout for request to : " + req.getRequestLine().getUri() + " Probably the keepalive connection was closed"));
            }
        } else {
            log.warn((Object)"Connection Timeout");
            if (this.metrics != null) {
                this.metrics.incrementTimeoutsReceiving();
            }
        }
        this.shutdownConnection((HttpConnection)conn);
    }

    public void connected(NHttpServerConnection conn) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"New incoming connection");
        }
    }

    public void responseReady(NHttpServerConnection conn) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Ready to send response");
        }
    }

    public void closed(NHttpServerConnection conn) {
        HttpContext context = conn.getContext();
        context.removeAttribute(REQUEST_SINK_BUFFER);
        context.removeAttribute(RESPONSE_SOURCE_BUFFER);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Connection closed");
        }
    }

    public void exception(NHttpServerConnection conn, HttpException e) {
        HttpContext context = conn.getContext();
        HttpRequest request = conn.getHttpRequest();
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        HttpResponse response = this.responseFactory.newHttpResponse(ver, 400, context);
        byte[] msg = EncodingUtils.getAsciiBytes((String)("Malformed HTTP request: " + e.getMessage()));
        ByteArrayEntity entity = new ByteArrayEntity(msg);
        entity.setContentType("text/plain; charset=US-ASCII");
        response.setEntity((HttpEntity)entity);
        this.commitResponse(conn, response);
        if (this.metrics != null) {
            this.metrics.incrementFaultsReceiving();
        }
    }

    public void exception(NHttpServerConnection conn, IOException e) {
        if (e instanceof ConnectionClosedException || e.getMessage().contains("Connection reset by peer") || e.getMessage().contains("forcibly closed")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("I/O error (Probably the keepalive connection was closed):" + e.getMessage()));
            }
        } else {
            log.error((Object)("I/O error: " + e.getMessage()));
            if (this.metrics != null) {
                this.metrics.incrementFaultsReceiving();
            }
        }
        this.shutdownConnection((HttpConnection)conn);
    }

    private void handleException(String msg, Exception e, NHttpServerConnection conn) {
        log.error((Object)msg, (Throwable)e);
        if (conn != null) {
            this.shutdownConnection((HttpConnection)conn);
        }
    }

    private void shutdownConnection(HttpConnection conn) {
        try {
            conn.shutdown();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private HttpProcessor getHttpProcessor() {
        BasicHttpProcessor httpProcessor = new BasicHttpProcessor();
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseDate());
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseServer());
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseContent());
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
        return httpProcessor;
    }

    public int getActiveCount() {
        return this.workerPool.getActiveCount();
    }

    public int getQueueSize() {
        return this.workerPool.getQueueSize();
    }
}

