/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NHttpConfiguration {
    private static final int WORKERS_CORE_THREADS = 20;
    private static final int WORKERS_MAX_THREADS = 100;
    private static final int WORKER_KEEP_ALIVE = 5;
    private static final int BLOCKING_QUEUE_LENGTH = -1;
    private static final int IO_WORKER_COUNT = 2;
    private static final int BUFFER_SIZE = 8192;
    private static final String S_T_CORE = "snd_t_core";
    private static final String S_T_MAX = "snd_t_max";
    private static final String S_T_ALIVE = "snd_alive_sec";
    private static final String S_T_QLEN = "snd_qlen";
    private static final String S_IO_WORKERS = "snd_io_threads";
    private static final String C_T_CORE = "lst_t_core";
    private static final String C_T_MAX = "lst_t_max";
    private static final String C_T_ALIVE = "lst_alive_sec";
    private static final String C_T_QLEN = "lst_qlen";
    private static final String C_IO_WORKERS = "lst_io_threads";
    private static final String G_BUFFER_SIZE = "nhttp_buffer_size";
    private static final Log log = LogFactory.getLog(NHttpConfiguration.class);
    private static NHttpConfiguration _instance = new NHttpConfiguration();
    private Properties props = new Properties();

    private NHttpConfiguration() {
        try {
            this.props.load(this.getClass().getClassLoader().getResourceAsStream("nhttp.properties"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static NHttpConfiguration getInstance() {
        return _instance;
    }

    public int getServerCoreThreads() {
        return this.getProperty(S_T_CORE, 20);
    }

    public int getServerMaxThreads() {
        return this.getProperty(S_T_MAX, 100);
    }

    public int getServerKeepalive() {
        return this.getProperty(S_T_ALIVE, 5);
    }

    public int getServerQueueLen() {
        return this.getProperty(S_T_QLEN, -1);
    }

    public int getServerIOWorkers() {
        return this.getProperty(S_IO_WORKERS, 2);
    }

    public int getClientCoreThreads() {
        return this.getProperty(C_T_CORE, 20);
    }

    public int getClientMaxThreads() {
        return this.getProperty(C_T_MAX, 100);
    }

    public int getClientKeepalive() {
        return this.getProperty(C_T_ALIVE, 5);
    }

    public int getClientQueueLen() {
        return this.getProperty(C_T_QLEN, -1);
    }

    public int getClientIOWorkers() {
        return this.getProperty(C_IO_WORKERS, 2);
    }

    public int getBufferSize() {
        return this.getProperty(G_BUFFER_SIZE, 8192);
    }

    public int getProperty(String name, int def) {
        String val = System.getProperty(name);
        if (val == null) {
            val = this.props.getProperty(name);
        }
        if (val != null && Integer.valueOf(val) > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using nhttp tuning parameter : " + name + " = " + val));
            }
            return Integer.valueOf(val);
        }
        return def;
    }
}

