/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.NHttpClientIOTarget;
import org.apache.http.nio.NHttpServerIOTarget;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.nio.reactor.IOSession;
import org.apache.synapse.transport.nhttp.LoggingIOSession;
import org.apache.synapse.transport.nhttp.LoggingNHttpClientHandler;
import org.apache.synapse.transport.nhttp.LoggingNHttpClientIOTarget;
import org.apache.synapse.transport.nhttp.LoggingNHttpServerIOTarget;
import org.apache.synapse.transport.nhttp.LoggingNHttpServiceHandler;

public class LoggingUtils {
    public static String HEADER_LOG_ID = "org.apache.synapse.transport.nhttp.headers";

    public static IOSession decorate(IOSession session, String id) {
        Log log = LogFactory.getLog(session.getClass());
        if (log.isDebugEnabled()) {
            session = new LoggingIOSession(log, session, id);
        }
        return session;
    }

    public static NHttpClientIOTarget decorate(NHttpClientIOTarget target) {
        Log log = LogFactory.getLog(target.getClass());
        Log headerlog = LogFactory.getLog((String)HEADER_LOG_ID);
        if (log.isDebugEnabled() || headerlog.isDebugEnabled()) {
            target = new LoggingNHttpClientIOTarget(log, headerlog, target);
        }
        return target;
    }

    public static NHttpServerIOTarget decorate(NHttpServerIOTarget target) {
        Log log = LogFactory.getLog(target.getClass());
        Log headerlog = LogFactory.getLog((String)HEADER_LOG_ID);
        if (log.isDebugEnabled() || headerlog.isDebugEnabled()) {
            target = new LoggingNHttpServerIOTarget(log, headerlog, target);
        }
        return target;
    }

    public static NHttpClientHandler decorate(NHttpClientHandler handler) {
        Log log = LogFactory.getLog(handler.getClass());
        Log headerlog = LogFactory.getLog((String)HEADER_LOG_ID);
        if (log.isDebugEnabled() || headerlog.isDebugEnabled()) {
            handler = new LoggingNHttpClientHandler(log, headerlog, handler);
        }
        return handler;
    }

    public static NHttpServiceHandler decorate(NHttpServiceHandler handler) {
        Log log = LogFactory.getLog(handler.getClass());
        Log headerlog = LogFactory.getLog((String)HEADER_LOG_ID);
        if (log.isDebugEnabled() || headerlog.isDebugEnabled()) {
            handler = new LoggingNHttpServiceHandler(log, headerlog, handler);
        }
        return handler;
    }
}

