/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpException;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.NHttpClientIOTarget;
import org.apache.http.protocol.HttpContext;
import org.apache.synapse.transport.nhttp.LoggingUtils;

public class LoggingNHttpClientIOTarget
implements NHttpClientIOTarget,
HttpInetConnection {
    private final NHttpClientIOTarget target;
    private final Log log;
    private final Log headerlog;

    public LoggingNHttpClientIOTarget(Log log, Log headerlog, NHttpClientIOTarget target) {
        if (target == null) {
            throw new IllegalArgumentException("IO target may not be null");
        }
        this.target = target;
        this.log = log != null ? log : LogFactory.getLog(target.getClass());
        this.headerlog = log != null ? headerlog : LogFactory.getLog((String)LoggingUtils.HEADER_LOG_ID);
    }

    public void requestInput() {
        this.target.requestInput();
    }

    public void requestOutput() {
        this.target.requestOutput();
    }

    public void suspendInput() {
        this.target.suspendInput();
    }

    public void suspendOutput() {
        this.target.suspendOutput();
    }

    public void close() throws IOException {
        this.log.debug((Object)"Close connection");
        this.target.close();
    }

    public HttpConnectionMetrics getMetrics() {
        return this.target.getMetrics();
    }

    public int getSocketTimeout() {
        return this.target.getSocketTimeout();
    }

    public boolean isOpen() {
        return this.target.isOpen();
    }

    public boolean isStale() {
        return this.target.isStale();
    }

    public void setSocketTimeout(int timeout) {
        this.target.setSocketTimeout(timeout);
    }

    public void shutdown() throws IOException {
        this.log.debug((Object)"Shutdown connection");
        this.target.shutdown();
    }

    public HttpContext getContext() {
        return this.target.getContext();
    }

    public HttpRequest getHttpRequest() {
        return this.target.getHttpRequest();
    }

    public HttpResponse getHttpResponse() {
        return this.target.getHttpResponse();
    }

    public int getStatus() {
        return this.target.getStatus();
    }

    public boolean isRequestSubmitted() {
        return this.target.isRequestSubmitted();
    }

    public void resetInput() {
        this.target.resetInput();
    }

    public void resetOutput() {
        this.target.resetOutput();
    }

    public void submitRequest(HttpRequest request) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + this + ": " + request.getRequestLine().toString()));
        }
        this.target.submitRequest(request);
        if (this.headerlog.isDebugEnabled()) {
            this.headerlog.debug((Object)(">> " + request.getRequestLine().toString()));
            Header[] headers = request.getAllHeaders();
            for (int i = 0; i < headers.length; ++i) {
                this.headerlog.debug((Object)(">> " + headers[i].toString()));
            }
        }
    }

    public void consumeInput(NHttpClientHandler handler) {
        this.log.debug((Object)"Consume input");
        this.target.consumeInput(handler);
    }

    public void produceOutput(NHttpClientHandler handler) {
        this.log.debug((Object)"Produce output");
        this.target.produceOutput(handler);
    }

    public InetAddress getLocalAddress() {
        if (this.target instanceof HttpInetConnection) {
            return ((HttpInetConnection)this.target).getLocalAddress();
        }
        return null;
    }

    public int getLocalPort() {
        if (this.target instanceof HttpInetConnection) {
            return ((HttpInetConnection)this.target).getLocalPort();
        }
        return -1;
    }

    public InetAddress getRemoteAddress() {
        if (this.target instanceof HttpInetConnection) {
            return ((HttpInetConnection)this.target).getRemoteAddress();
        }
        return null;
    }

    public int getRemotePort() {
        if (this.target instanceof HttpInetConnection) {
            return ((HttpInetConnection)this.target).getRemotePort();
        }
        return -1;
    }

    public String toString() {
        return this.target.toString();
    }
}

