/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.net.ssl.SSLContext;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.SSLIOSessionHandler;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.nio.reactor.SessionRequest;
import org.apache.http.nio.reactor.SessionRequestCallback;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.synapse.transport.base.ManagementSupport;
import org.apache.synapse.transport.base.MetricsCollector;
import org.apache.synapse.transport.base.TransportView;
import org.apache.synapse.transport.nhttp.Axis2HttpRequest;
import org.apache.synapse.transport.nhttp.ClientHandler;
import org.apache.synapse.transport.nhttp.ConnectionPool;
import org.apache.synapse.transport.nhttp.NHttpConfiguration;
import org.apache.synapse.transport.nhttp.NhttpUtils;
import org.apache.synapse.transport.nhttp.PlainClientIOEventDispatch;
import org.apache.synapse.transport.nhttp.ServerWorker;
import org.apache.synapse.transport.nhttp.util.MessageFormatterDecoratorFactory;

public class HttpCoreNIOSender
extends AbstractHandler
implements TransportSender,
ManagementSupport {
    private static final Log log = LogFactory.getLog(HttpCoreNIOSender.class);
    private ConfigurationContext cfgCtx;
    private DefaultConnectingIOReactor ioReactor = null;
    private ClientHandler handler = null;
    private final SessionRequestCallback sessionRequestCallback = this.getSessionRequestCallback();
    private SSLContext sslContext = null;
    private SSLIOSessionHandler sslIOSessionHandler = null;
    private MetricsCollector metrics = new MetricsCollector();
    private int state = 0;

    public void init(ConfigurationContext cfgCtx, TransportOutDescription transportOut) throws AxisFault {
        this.cfgCtx = cfgCtx;
        this.sslContext = this.getSSLContext(transportOut);
        this.sslIOSessionHandler = this.getSSLIOSessionHandler(transportOut);
        Thread t = new Thread(new Runnable(){

            public void run() {
                HttpCoreNIOSender.this.executeClientEngine();
            }
        }, "HttpCoreNIOSender");
        t.start();
        log.info((Object)((this.sslContext == null ? "HTTP" : "HTTPS") + " Sender starting"));
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        String jmxAgentName = System.getProperty("jmx.agent.name");
        if (jmxAgentName == null || "".equals(jmxAgentName)) {
            jmxAgentName = "org.apache.synapse";
        }
        try {
            String name = jmxAgentName + ":Type=Transport,ConnectorName=" + "nio-http" + (this.sslContext == null ? "" : "s") + "-sender";
            TransportView tBean = new TransportView(null, this);
            this.registerMBean(mbs, tBean, name);
        }
        catch (Exception e) {
            log.warn((Object)("Error registering the non-blocking http" + (this.sslContext == null ? "" : "s") + " transport sender for JMX management"), (Throwable)e);
        }
    }

    private void executeClientEngine() {
        HttpParams params = this.getClientParameters();
        try {
            this.ioReactor = new DefaultConnectingIOReactor(NHttpConfiguration.getInstance().getClientIOWorkers(), params);
            this.ioReactor.setExceptionHandler(new IOReactorExceptionHandler(){

                public boolean handle(IOException ioException) {
                    log.warn((Object)("System may be unstable: IOReactor encountered a checked exception : " + ioException.getMessage()), (Throwable)ioException);
                    return true;
                }

                public boolean handle(RuntimeException runtimeException) {
                    log.warn((Object)("System may be unstable: IOReactor encountered a runtime exception : " + runtimeException.getMessage()), (Throwable)runtimeException);
                    return true;
                }
            });
        }
        catch (IOException e) {
            log.error((Object)"Error starting the IOReactor", (Throwable)e);
        }
        this.handler = new ClientHandler(this.cfgCtx, params, this.metrics);
        IOEventDispatch ioEventDispatch = this.getEventDispatch(this.handler, this.sslContext, this.sslIOSessionHandler, params);
        this.state = 1;
        try {
            this.ioReactor.execute(ioEventDispatch);
        }
        catch (InterruptedIOException ex) {
            log.fatal((Object)"Reactor Interrupted");
        }
        catch (IOException e) {
            log.fatal((Object)("Encountered an I/O error: " + e.getMessage()), (Throwable)e);
        }
        log.info((Object)((this.sslContext == null ? "HTTP" : "HTTPS") + " Sender Shutdown"));
    }

    protected IOEventDispatch getEventDispatch(NHttpClientHandler handler, SSLContext sslContext, SSLIOSessionHandler sslIOSessionHandler, HttpParams params) {
        return new PlainClientIOEventDispatch(handler, params);
    }

    protected SSLContext getSSLContext(TransportOutDescription transportOut) throws AxisFault {
        return null;
    }

    protected SSLIOSessionHandler getSSLIOSessionHandler(TransportOutDescription transportOut) throws AxisFault {
        return null;
    }

    private HttpParams getClientParameters() {
        NHttpConfiguration cfg = NHttpConfiguration.getInstance();
        BasicHttpParams params = new BasicHttpParams();
        params.setIntParameter("http.socket.timeout", cfg.getProperty("http.socket.timeout", 60000)).setIntParameter("http.connection.timeout", cfg.getProperty("http.connection.timeout", 10000)).setIntParameter("http.socket.buffer-size", cfg.getProperty("http.socket.buffer-size", 8192)).setBooleanParameter("http.connection.stalecheck", cfg.getProperty("http.connection.stalecheck", 0) == 1).setBooleanParameter("http.tcp.nodelay", cfg.getProperty("http.tcp.nodelay", 1) == 1).setParameter("http.useragent", (Object)"Synapse-HttpComponents-NIO");
        return params;
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        EndpointReference epr;
        this.removeUnwantedHeaders(msgContext);
        if (AddressingHelper.isReplyRedirected((MessageContext)msgContext) && !msgContext.getReplyTo().hasNoneAddress()) {
            msgContext.setProperty("IGNORE_SC_ACCEPTED", (Object)"true");
        }
        if ((epr = NhttpUtils.getDestinationEPR(msgContext)) != null) {
            if (!"http://www.w3.org/2005/08/addressing/none".equals(epr.getAddress())) {
                this.sendAsyncRequest(epr, msgContext);
            } else {
                this.handleException("Cannot send message to http://www.w3.org/2005/08/addressing/none");
            }
        } else if (msgContext.getProperty("OutTransportInfo") != null) {
            if (msgContext.getProperty("OutTransportInfo") instanceof ServerWorker) {
                this.sendAsyncResponse(msgContext);
            } else {
                this.sendUsingOutputStream(msgContext);
            }
        } else {
            this.handleException("No valid destination EPR or OutputStream to send message");
        }
        if (msgContext.getOperationContext() != null) {
            msgContext.getOperationContext().setProperty("RESPONSE_WRITTEN", (Object)"true");
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void removeUnwantedHeaders(MessageContext msgContext) {
        Map headers = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
        if (headers == null || headers.isEmpty()) {
            return;
        }
        Iterator iter = headers.keySet().iterator();
        while (iter.hasNext()) {
            String headerName = (String)iter.next();
            if (!"Connection".equalsIgnoreCase(headerName) && !"Transfer-Encoding".equalsIgnoreCase(headerName) && !"Date".equalsIgnoreCase(headerName) && !"Server".equalsIgnoreCase(headerName) && !"Content-Type".equalsIgnoreCase(headerName) && !"Content-Length".equalsIgnoreCase(headerName) && !"User-Agent".equalsIgnoreCase(headerName)) continue;
            iter.remove();
        }
    }

    private void sendAsyncRequest(EndpointReference epr, MessageContext msgContext) throws AxisFault {
        try {
            URL url = new URL(epr.getAddress());
            int port = url.getPort();
            if (port == -1) {
                if ("http".equals(url.getProtocol())) {
                    port = 80;
                } else if ("https".equals(url.getProtocol())) {
                    port = 443;
                }
            }
            HttpHost httpHost = new HttpHost(url.getHost(), port, url.getProtocol());
            Axis2HttpRequest axis2Req = new Axis2HttpRequest(epr, httpHost, msgContext);
            NHttpClientConnection conn = ConnectionPool.getConnection(url.getHost(), port);
            if (conn == null) {
                this.ioReactor.connect((SocketAddress)new InetSocketAddress(url.getHost(), port), null, (Object)axis2Req, this.sessionRequestCallback);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("A new connection established to : " + url.getHost() + ":" + port));
                }
            } else {
                this.handler.submitRequest(conn, axis2Req);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("An existing connection reused to : " + url.getHost() + ":" + port));
                }
            }
            axis2Req.streamMessageContents();
        }
        catch (MalformedURLException e) {
            this.handleException("Malformed destination EPR : " + epr.getAddress(), e);
        }
        catch (IOException e) {
            this.handleException("IO Error while submiting request message for sending", e);
        }
    }

    private void sendAsyncResponse(MessageContext msgContext) throws AxisFault {
        this.removeUnwantedHeaders(msgContext);
        ServerWorker worker = (ServerWorker)msgContext.getProperty("OutTransportInfo");
        HttpResponse response = worker.getResponse();
        OMOutputFormat format = NhttpUtils.getOMOutputFormat(msgContext);
        MessageFormatter messageFormatter = MessageFormatterDecoratorFactory.createMessageFormatterDecorator(msgContext);
        response.setHeader("Content-Type", messageFormatter.getContentType(msgContext, format, msgContext.getSoapAction()));
        if (msgContext.getEnvelope().getBody().hasFault() || msgContext.isProcessingFault()) {
            response.setStatusCode(500);
        }
        if (msgContext.isPropertyTrue("SC_ACCEPTED")) {
            response.setStatusCode(202);
        } else {
            Object statusCode = msgContext.getProperty("HTTP_SC");
            if (statusCode != null) {
                try {
                    response.setStatusCode(Integer.parseInt(msgContext.getProperty("HTTP_SC").toString()));
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Unable to set the HTTP Status Code from the property HHTP_SC with value : " + statusCode));
                }
            }
        }
        Map transportHeaders = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
        if (transportHeaders != null && !transportHeaders.values().isEmpty()) {
            for (Object header : transportHeaders.keySet()) {
                Object value = transportHeaders.get(header);
                if (value == null || !(header instanceof String) || !(value instanceof String)) continue;
                response.setHeader((String)header, (String)value);
            }
        }
        worker.getServiceHandler().commitResponse(worker.getConn(), response);
        OutputStream out = worker.getOutputStream();
        try {
            if (msgContext.isPropertyTrue("SC_ACCEPTED")) {
                out.write(new byte[0]);
            } else {
                messageFormatter.writeTo(msgContext, format, out, false);
            }
            out.close();
        }
        catch (IOException e) {
            this.handleException("IO Error sending response message", e);
        }
        try {
            worker.getIs().close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
    }

    private void sendUsingOutputStream(MessageContext msgContext) throws AxisFault {
        OMOutputFormat format = NhttpUtils.getOMOutputFormat(msgContext);
        MessageFormatter messageFormatter = MessageFormatterDecoratorFactory.createMessageFormatterDecorator(msgContext);
        OutputStream out = (OutputStream)msgContext.getProperty("TRANSPORT_OUT");
        if (msgContext.isServerSide()) {
            OutTransportInfo transportInfo = (OutTransportInfo)msgContext.getProperty("OutTransportInfo");
            if (transportInfo != null) {
                transportInfo.setContentType(messageFormatter.getContentType(msgContext, format, msgContext.getSoapAction()));
            } else {
                throw new AxisFault("OutTransportInfo has not been set");
            }
        }
        try {
            messageFormatter.writeTo(msgContext, format, out, false);
            out.close();
        }
        catch (IOException e) {
            this.handleException("IO Error sending response message", e);
        }
    }

    public void cleanup(MessageContext msgContext) throws AxisFault {
    }

    public void stop() {
        if (this.state != 1) {
            return;
        }
        try {
            this.ioReactor.shutdown();
            this.state = 0;
        }
        catch (IOException e) {
            log.warn((Object)"Error shutting down IOReactor", (Throwable)e);
        }
    }

    private SessionRequestCallback getSessionRequestCallback() {
        return new SessionRequestCallback(){

            public void completed(SessionRequest request) {
            }

            public void failed(SessionRequest request) {
                this.handleError(request, false);
            }

            public void timeout(SessionRequest request) {
                this.handleError(request, true);
                request.cancel();
            }

            public void cancelled(SessionRequest sessionRequest) {
            }

            private void handleError(SessionRequest request, boolean isTimeout) {
                Axis2HttpRequest axis2Request;
                if (request.getAttachment() != null && request.getAttachment() instanceof Axis2HttpRequest && !(axis2Request = (Axis2HttpRequest)request.getAttachment()).isCompleted()) {
                    axis2Request.setCompleted(true);
                    MessageContext mc = axis2Request.getMsgContext();
                    final MessageReceiver mr = mc.getAxisOperation().getMessageReceiver();
                    if (mr != null) {
                        try {
                            AxisFault axisFault;
                            if (isTimeout) {
                                axisFault = new AxisFault("The connection timed out");
                            } else {
                                IOException exception = request.getException();
                                axisFault = new AxisFault(exception.toString(), (Throwable)exception);
                            }
                            final MessageContext nioFaultMessageContext = MessageContextBuilder.createFaultMessageContext((MessageContext)mc, (Throwable)axisFault);
                            nioFaultMessageContext.setProperty("sending_fault", (Object)Boolean.TRUE);
                            HttpCoreNIOSender.this.handler.execute(new Runnable(){

                                public void run() {
                                    try {
                                        mr.receive(nioFaultMessageContext);
                                    }
                                    catch (AxisFault af) {
                                        log.error((Object)"Error processing fault message context", (Throwable)af);
                                    }
                                }
                            });
                        }
                        catch (AxisFault af) {
                            log.error((Object)"Unable to report back failure to the message receiver", (Throwable)af);
                        }
                    }
                }
            }
        };
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    private void handleException(String msg) throws AxisFault {
        log.error((Object)msg);
        throw new AxisFault(msg);
    }

    public void pause() throws AxisFault {
        if (this.state != 1) {
            return;
        }
        this.state = 2;
        log.info((Object)"Sender paused");
    }

    public void resume() throws AxisFault {
        if (this.state != 2) {
            return;
        }
        this.state = 1;
        log.info((Object)"Sender resumed");
    }

    public void maintenenceShutdown(long millis) throws AxisFault {
        if (this.state != 1) {
            return;
        }
        try {
            long start = System.currentTimeMillis();
            this.ioReactor.shutdown(millis);
            this.state = 0;
            log.info((Object)("Sender shutdown in : " + (System.currentTimeMillis() - start) / 1000L + "s"));
        }
        catch (IOException e) {
            this.handleException("Error shutting down the IOReactor for maintenence", e);
        }
    }

    public int getActiveThreadCount() {
        return this.handler.getActiveCount();
    }

    public int getQueueSize() {
        return this.handler.getQueueSize();
    }

    public long getMessagesReceived() {
        if (this.metrics != null) {
            return this.metrics.getMessagesReceived();
        }
        return -1L;
    }

    public long getFaultsReceiving() {
        if (this.metrics != null) {
            return this.metrics.getFaultsReceiving();
        }
        return -1L;
    }

    public long getBytesReceived() {
        if (this.metrics != null) {
            return this.metrics.getBytesReceived();
        }
        return -1L;
    }

    public long getMessagesSent() {
        if (this.metrics != null) {
            return this.metrics.getMessagesSent();
        }
        return -1L;
    }

    public long getFaultsSending() {
        if (this.metrics != null) {
            return this.metrics.getFaultsSending();
        }
        return -1L;
    }

    public long getBytesSent() {
        if (this.metrics != null) {
            return this.metrics.getBytesSent();
        }
        return -1L;
    }

    private void registerMBean(MBeanServer mbs, Object mbeanInstance, String objectName) {
        try {
            ObjectName name = new ObjectName(objectName);
            Set<ObjectName> set = mbs.queryNames(name, null);
            if (set != null && set.isEmpty()) {
                mbs.registerMBean(mbeanInstance, name);
            } else {
                mbs.unregisterMBean(name);
                mbs.registerMBean(mbeanInstance, name);
            }
        }
        catch (Exception e) {
            log.warn((Object)("Error registering a MBean with objectname ' " + objectName + " ' for JMX management"), (Throwable)e);
        }
    }
}

