/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.net.ssl.SSLContext;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.TransportListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.impl.nio.reactor.DefaultListeningIOReactor;
import org.apache.http.impl.nio.reactor.SSLIOSessionHandler;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.synapse.transport.base.ManagementSupport;
import org.apache.synapse.transport.base.MetricsCollector;
import org.apache.synapse.transport.base.TransportView;
import org.apache.synapse.transport.nhttp.NHttpConfiguration;
import org.apache.synapse.transport.nhttp.PlainServerIOEventDispatch;
import org.apache.synapse.transport.nhttp.ServerHandler;

public class HttpCoreNIOListener
implements TransportListener,
ManagementSupport {
    private static final Log log = LogFactory.getLog(HttpCoreNIOListener.class);
    private ConfigurationContext cfgCtx;
    private DefaultListeningIOReactor ioReactor = null;
    private String serviceEPRPrefix;
    private int port = 8280;
    private String host = "localhost";
    private String bindAddress = null;
    private SSLContext sslContext = null;
    private SSLIOSessionHandler sslIOSessionHandler = null;
    private MetricsCollector metrics = new MetricsCollector();
    private int state = 0;
    private ServerHandler handler = null;

    private void startServerEngine(int port) {
        HttpParams params = this.getServerParameters();
        try {
            this.ioReactor = new DefaultListeningIOReactor(NHttpConfiguration.getInstance().getServerIOWorkers(), params);
            this.ioReactor.setExceptionHandler(new IOReactorExceptionHandler(){

                public boolean handle(IOException ioException) {
                    log.warn((Object)("System may be unstable: IOReactor encountered a checked exception : " + ioException.getMessage()), (Throwable)ioException);
                    return true;
                }

                public boolean handle(RuntimeException runtimeException) {
                    log.warn((Object)("System may be unstable: IOReactor encountered a runtime exception : " + runtimeException.getMessage()), (Throwable)runtimeException);
                    return true;
                }
            });
        }
        catch (IOException e) {
            log.error((Object)"Error starting the IOReactor", (Throwable)e);
        }
        this.handler = new ServerHandler(this.cfgCtx, params, this.sslContext != null, this.metrics);
        IOEventDispatch ioEventDispatch = this.getEventDispatch(this.handler, this.sslContext, this.sslIOSessionHandler, params);
        this.state = 1;
        try {
            if (this.bindAddress == null) {
                this.ioReactor.listen((SocketAddress)new InetSocketAddress(port));
            } else {
                this.ioReactor.listen((SocketAddress)new InetSocketAddress(InetAddress.getByName(this.bindAddress), port));
            }
            this.ioReactor.execute(ioEventDispatch);
        }
        catch (InterruptedIOException ex) {
            log.fatal((Object)"Reactor Interrupted");
        }
        catch (IOException e) {
            log.fatal((Object)("Encountered an I/O error: " + e.getMessage()), (Throwable)e);
        }
        log.info((Object)((this.sslContext == null ? "HTTP" : "HTTPS") + " Listener Shutdown"));
    }

    protected IOEventDispatch getEventDispatch(NHttpServiceHandler handler, SSLContext sslContext, SSLIOSessionHandler sslioSessionHandler, HttpParams params) {
        return new PlainServerIOEventDispatch(handler, params);
    }

    private HttpParams getServerParameters() {
        BasicHttpParams params = new BasicHttpParams();
        NHttpConfiguration cfg = NHttpConfiguration.getInstance();
        params.setIntParameter("http.socket.timeout", cfg.getProperty("http.socket.timeout", 60000)).setIntParameter("http.socket.buffer-size", cfg.getProperty("http.socket.buffer-size", 8192)).setBooleanParameter("http.connection.stalecheck", cfg.getProperty("http.connection.stalecheck", 0) == 1).setBooleanParameter("http.tcp.nodelay", cfg.getProperty("http.tcp.nodelay", 1) == 1).setParameter("http.origin-server", (Object)"Synapse-HttpComponents-NIO");
        return params;
    }

    public void init(ConfigurationContext cfgCtx, TransportInDescription transprtIn) throws AxisFault {
        this.cfgCtx = cfgCtx;
        Parameter param = transprtIn.getParameter("port");
        if (param != null) {
            this.port = Integer.parseInt((String)param.getValue());
        }
        if ((param = transprtIn.getParameter("bind-address")) != null) {
            this.bindAddress = ((String)param.getValue()).trim();
        }
        if ((param = transprtIn.getParameter("hostname")) != null) {
            this.host = ((String)param.getValue()).trim();
        } else {
            try {
                this.host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                log.warn((Object)"Unable to lookup local host name, using 'localhost'");
            }
        }
        this.sslContext = this.getSSLContext(transprtIn);
        this.sslIOSessionHandler = this.getSSLIOSessionHandler(transprtIn);
        param = transprtIn.getParameter("WSDLEPRPrefix");
        this.serviceEPRPrefix = param != null ? this.getServiceEPRPrefix(cfgCtx, (String)param.getValue()) : this.getServiceEPRPrefix(cfgCtx, this.host, this.port);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        String jmxAgentName = System.getProperty("jmx.agent.name");
        if (jmxAgentName == null || "".equals(jmxAgentName)) {
            jmxAgentName = "org.apache.synapse";
        }
        try {
            String name = jmxAgentName + ":Type=Transport,ConnectorName=" + "nio-http" + (this.sslContext == null ? "" : "s") + "-listener";
            TransportView tBean = new TransportView(this, null);
            this.registerMBean(mbs, tBean, name);
        }
        catch (Exception e) {
            log.warn((Object)("Error registering the non-blocking http" + (this.sslContext == null ? "" : "s") + " transport for JMX management"), (Throwable)e);
        }
    }

    protected String getServiceEPRPrefix(ConfigurationContext cfgCtx, String host, int port) {
        return "http://" + host + (port == 80 ? "" : ":" + port) + (!cfgCtx.getServiceContextPath().startsWith("/") ? "/" : "") + cfgCtx.getServiceContextPath() + (!cfgCtx.getServiceContextPath().endsWith("/") ? "/" : "");
    }

    protected String getServiceEPRPrefix(ConfigurationContext cfgCtx, String wsdlEPRPrefix) {
        return wsdlEPRPrefix + (!cfgCtx.getServiceContextPath().startsWith("/") ? "/" : "") + cfgCtx.getServiceContextPath() + (!cfgCtx.getServiceContextPath().endsWith("/") ? "/" : "");
    }

    protected SSLContext getSSLContext(TransportInDescription transportIn) throws AxisFault {
        return null;
    }

    protected SSLIOSessionHandler getSSLIOSessionHandler(TransportInDescription transportIn) throws AxisFault {
        return null;
    }

    public void start() throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting Listener...");
        }
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    HttpCoreNIOListener.this.startServerEngine(HttpCoreNIOListener.this.port);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, "HttpCoreNIOListener");
        t.start();
        log.info((Object)((this.sslContext == null ? "HTTP" : "HTTPS") + " Listener starting on" + (this.bindAddress != null ? " address : " + this.bindAddress : "") + " port : " + this.port));
    }

    public void stop() throws AxisFault {
        if (this.state != 1) {
            return;
        }
        try {
            this.ioReactor.shutdown();
            this.state = 0;
        }
        catch (IOException e) {
            this.handleException("Error shutting down IOReactor", e);
        }
    }

    public void pause() throws AxisFault {
        if (this.state != 1) {
            return;
        }
        try {
            this.ioReactor.pause();
            this.state = 2;
            log.info((Object)"Listener paused");
        }
        catch (IOException e) {
            this.handleException("Error pausing IOReactor", e);
        }
    }

    public void resume() throws AxisFault {
        if (this.state != 2) {
            return;
        }
        try {
            this.ioReactor.resume();
            this.state = 1;
            log.info((Object)"Listener resumed");
        }
        catch (IOException e) {
            this.handleException("Error resuming IOReactor", e);
        }
    }

    public int getActiveThreadCount() {
        return this.handler.getActiveCount();
    }

    public int getQueueSize() {
        return this.handler.getQueueSize();
    }

    public void maintenenceShutdown(long millis) throws AxisFault {
        if (this.state != 1) {
            return;
        }
        try {
            long start = System.currentTimeMillis();
            this.ioReactor.pause();
            this.ioReactor.shutdown(millis);
            this.state = 0;
            log.info((Object)("Listener shutdown in : " + (System.currentTimeMillis() - start) / 1000L + "s"));
        }
        catch (IOException e) {
            this.handleException("Error shutting down the IOReactor for maintenence", e);
        }
    }

    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        return new EndpointReference(this.serviceEPRPrefix + serviceName);
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        EndpointReference[] endpointReferences = new EndpointReference[]{new EndpointReference(this.serviceEPRPrefix + serviceName)};
        return endpointReferences;
    }

    public SessionContext getSessionContext(MessageContext messageContext) {
        return null;
    }

    public void destroy() {
        this.ioReactor = null;
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    private void handleException(String msg) throws AxisFault {
        log.error((Object)msg);
        throw new AxisFault(msg);
    }

    public long getMessagesReceived() {
        if (this.metrics != null) {
            return this.metrics.getMessagesReceived();
        }
        return -1L;
    }

    public long getFaultsReceiving() {
        if (this.metrics != null) {
            return this.metrics.getFaultsReceiving();
        }
        return -1L;
    }

    public long getBytesReceived() {
        if (this.metrics != null) {
            return this.metrics.getBytesReceived();
        }
        return -1L;
    }

    public long getMessagesSent() {
        if (this.metrics != null) {
            return this.metrics.getMessagesSent();
        }
        return -1L;
    }

    public long getFaultsSending() {
        if (this.metrics != null) {
            return this.metrics.getFaultsSending();
        }
        return -1L;
    }

    public long getBytesSent() {
        if (this.metrics != null) {
            return this.metrics.getBytesSent();
        }
        return -1L;
    }

    private void registerMBean(MBeanServer mbs, Object mbeanInstance, String objectName) {
        try {
            ObjectName name = new ObjectName(objectName);
            Set<ObjectName> set = mbs.queryNames(name, null);
            if (set != null && set.isEmpty()) {
                mbs.registerMBean(mbeanInstance, name);
            } else {
                mbs.unregisterMBean(name);
                mbs.registerMBean(mbeanInstance, name);
            }
        }
        catch (Exception e) {
            log.warn((Object)("Error registering a MBean with objectname ' " + objectName + " ' for JMX management"), (Throwable)e);
        }
    }
}

