/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.IOException;
import java.io.InputStream;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axiom.soap.impl.llom.soap12.SOAP12Factory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.entity.ContentInputStream;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.ContentInputBuffer;
import org.apache.http.nio.util.ContentOutputBuffer;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.nio.util.SharedOutputBuffer;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.synapse.transport.base.MetricsCollector;
import org.apache.synapse.transport.base.threads.WorkerPool;
import org.apache.synapse.transport.base.threads.WorkerPoolFactory;
import org.apache.synapse.transport.nhttp.Axis2HttpRequest;
import org.apache.synapse.transport.nhttp.ClientWorker;
import org.apache.synapse.transport.nhttp.ConnectionPool;
import org.apache.synapse.transport.nhttp.NHttpConfiguration;
import org.apache.synapse.transport.nhttp.util.SharedInputBuffer;

public class ClientHandler
implements NHttpClientHandler {
    private static final Log log = LogFactory.getLog(ClientHandler.class);
    private final HttpParams params;
    private final HttpProcessor httpProcessor;
    private final ConnectionReuseStrategy connStrategy;
    private final ByteBufferAllocator allocator;
    ConfigurationContext cfgCtx = null;
    private NHttpConfiguration cfg = null;
    private WorkerPool workerPool = null;
    private MetricsCollector metrics = null;
    public static final String OUTGOING_MESSAGE_CONTEXT = "synapse.axis2_message_context";
    public static final String AXIS2_HTTP_REQUEST = "synapse.axis2-http-request";
    public static final String REQUEST_SOURCE_BUFFER = "synapse.request-source-buffer";
    public static final String RESPONSE_SINK_BUFFER = "synapse.response-sink-buffer";
    private static final String CONTENT_TYPE = "Content-Type";

    public ClientHandler(ConfigurationContext cfgCtx, HttpParams params, MetricsCollector metrics) {
        this.cfgCtx = cfgCtx;
        this.params = params;
        this.httpProcessor = this.getHttpProcessor();
        this.connStrategy = new DefaultConnectionReuseStrategy();
        this.metrics = metrics;
        this.allocator = new HeapByteBufferAllocator();
        this.cfg = NHttpConfiguration.getInstance();
        this.workerPool = WorkerPoolFactory.getWorkerPool(this.cfg.getClientCoreThreads(), this.cfg.getClientMaxThreads(), this.cfg.getClientKeepalive(), this.cfg.getClientQueueLen(), "Client Worker thread group", "HttpClientWorker");
    }

    public void requestReady(NHttpClientConnection conn) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitRequest(NHttpClientConnection conn, Axis2HttpRequest axis2Req) {
        try {
            HttpContext context = conn.getContext();
            SharedOutputBuffer outputBuffer = new SharedOutputBuffer(this.cfg.getBufferSize(), (IOControl)conn, this.allocator);
            axis2Req.setOutputBuffer((ContentOutputBuffer)outputBuffer);
            context.setAttribute(REQUEST_SOURCE_BUFFER, (Object)outputBuffer);
            context.setAttribute(AXIS2_HTTP_REQUEST, (Object)axis2Req);
            context.setAttribute("http.connection", (Object)conn);
            context.setAttribute("http.target_host", (Object)axis2Req.getHttpHost());
            context.setAttribute(OUTGOING_MESSAGE_CONTEXT, (Object)axis2Req.getMsgContext());
            HttpRequest request = axis2Req.getRequest();
            request.setParams((HttpParams)new DefaultedHttpParams(request.getParams(), this.params));
            this.httpProcessor.process(request, context);
            conn.submitRequest(request);
            context.setAttribute("http.request", (Object)request);
            Axis2HttpRequest axis2HttpRequest = axis2Req;
            synchronized (axis2HttpRequest) {
                axis2Req.setReadyToStream(true);
                axis2Req.notifyAll();
            }
        }
        catch (IOException e) {
            this.handleException("I/O Error : " + e.getMessage(), e, conn);
        }
        catch (HttpException e) {
            this.handleException("Unexpected HTTP protocol error: " + e.getMessage(), (Exception)((Object)e), conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connected(NHttpClientConnection conn, Object attachment) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ClientHandler connected : " + conn));
        }
        try {
            HttpContext context = conn.getContext();
            Axis2HttpRequest axis2Req = (Axis2HttpRequest)attachment;
            SharedOutputBuffer outputBuffer = new SharedOutputBuffer(this.cfg.getBufferSize(), (IOControl)conn, this.allocator);
            axis2Req.setOutputBuffer((ContentOutputBuffer)outputBuffer);
            context.setAttribute(REQUEST_SOURCE_BUFFER, (Object)outputBuffer);
            context.setAttribute(AXIS2_HTTP_REQUEST, (Object)axis2Req);
            context.setAttribute("http.connection", (Object)conn);
            context.setAttribute("http.target_host", (Object)axis2Req.getHttpHost());
            context.setAttribute(OUTGOING_MESSAGE_CONTEXT, (Object)axis2Req.getMsgContext());
            HttpRequest request = axis2Req.getRequest();
            request.setParams((HttpParams)new DefaultedHttpParams(request.getParams(), this.params));
            this.httpProcessor.process(request, context);
            conn.submitRequest(request);
            context.setAttribute("http.request", (Object)request);
            Axis2HttpRequest axis2HttpRequest = axis2Req;
            synchronized (axis2HttpRequest) {
                axis2Req.setReadyToStream(true);
                axis2Req.notifyAll();
            }
        }
        catch (IOException e) {
            this.handleException("I/O Error : " + e.getMessage(), e, conn);
        }
        catch (HttpException e) {
            this.handleException("Unexpected HTTP protocol error: " + e.getMessage(), (Exception)((Object)e), conn);
        }
    }

    public void closed(NHttpClientConnection conn) {
        ConnectionPool.forget(conn);
        this.checkAxisRequestComplete(conn, "Abnormal connection close", null);
        HttpContext context = conn.getContext();
        context.removeAttribute(RESPONSE_SINK_BUFFER);
        context.removeAttribute(REQUEST_SOURCE_BUFFER);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Connection closed");
        }
    }

    public void timeout(NHttpClientConnection conn) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Connection Timeout");
        }
        if (this.metrics != null) {
            this.metrics.incrementTimeoutsSending();
        }
        this.checkAxisRequestComplete(conn, "Connection timeout", null);
        this.shutdownConnection((HttpConnection)conn);
    }

    public void exception(NHttpClientConnection conn, HttpException e) {
        log.error((Object)("HTTP protocol violation : " + e.getMessage()));
        this.checkAxisRequestComplete(conn, null, (Exception)((Object)e));
        this.shutdownConnection((HttpConnection)conn);
        if (this.metrics != null) {
            this.metrics.incrementFaultsSending();
        }
    }

    public void exception(NHttpClientConnection conn, IOException e) {
        log.error((Object)("I/O error : " + e.getMessage()), (Throwable)e);
        this.checkAxisRequestComplete(conn, null, e);
        this.shutdownConnection((HttpConnection)conn);
        if (this.metrics != null) {
            this.metrics.incrementFaultsSending();
        }
    }

    private void checkAxisRequestComplete(NHttpClientConnection conn, final String errorMessage, final Exception exceptionToRaise) {
        Axis2HttpRequest axis2Request = (Axis2HttpRequest)conn.getContext().getAttribute(AXIS2_HTTP_REQUEST);
        if (axis2Request != null && !axis2Request.isCompleted()) {
            axis2Request.setCompleted(true);
            if (errorMessage == null && exceptionToRaise == null) {
                return;
            }
            final MessageContext mc = axis2Request.getMsgContext();
            if (mc.getAxisOperation() != null && mc.getAxisOperation().getMessageReceiver() != null) {
                this.workerPool.execute(new Runnable(){

                    public void run() {
                        MessageReceiver mr = mc.getAxisOperation().getMessageReceiver();
                        try {
                            MessageContext nioFaultMessageContext = null;
                            if (errorMessage != null) {
                                nioFaultMessageContext = MessageContextBuilder.createFaultMessageContext((MessageContext)mc, (Throwable)new AxisFault(errorMessage));
                            } else if (exceptionToRaise != null) {
                                nioFaultMessageContext = MessageContextBuilder.createFaultMessageContext((MessageContext)mc, (Throwable)new AxisFault(exceptionToRaise.toString(), (Throwable)exceptionToRaise));
                            }
                            if (nioFaultMessageContext != null) {
                                nioFaultMessageContext.setProperty("sending_fault", (Object)Boolean.TRUE);
                                mr.receive(nioFaultMessageContext);
                            }
                        }
                        catch (AxisFault af) {
                            log.error((Object)"Unable to report back failure to the message receiver", (Throwable)af);
                        }
                    }
                });
            }
        }
    }

    public void inputReady(NHttpClientConnection conn, ContentDecoder decoder) {
        HttpContext context = conn.getContext();
        HttpResponse response = conn.getHttpResponse();
        ContentInputBuffer inBuf = (ContentInputBuffer)context.getAttribute(RESPONSE_SINK_BUFFER);
        try {
            int bytesRead = inBuf.consumeContent(decoder);
            if (this.metrics != null && bytesRead > 0) {
                this.metrics.incrementBytesReceived(bytesRead);
            }
            if (decoder.isCompleted()) {
                if (this.metrics != null) {
                    this.metrics.incrementMessagesReceived();
                }
                if (!this.connStrategy.keepAlive(response, context)) {
                    conn.close();
                } else {
                    ConnectionPool.release(conn);
                }
            }
        }
        catch (IOException e) {
            this.handleException("I/O Error : " + e.getMessage(), e, conn);
        }
    }

    public void outputReady(NHttpClientConnection conn, ContentEncoder encoder) {
        HttpContext context = conn.getContext();
        ContentOutputBuffer outBuf = (ContentOutputBuffer)context.getAttribute(REQUEST_SOURCE_BUFFER);
        try {
            int bytesWritten = outBuf.produceContent(encoder);
            if (this.metrics != null && bytesWritten > 0) {
                this.metrics.incrementBytesSent(bytesWritten);
            }
            if (encoder.isCompleted() && this.metrics != null) {
                this.metrics.incrementMessagesSent();
            }
        }
        catch (IOException e) {
            this.handleException("I/O Error : " + e.getMessage(), e, conn);
        }
    }

    public void responseReceived(NHttpClientConnection conn) {
        HttpContext context = conn.getContext();
        HttpResponse response = conn.getHttpResponse();
        this.checkAxisRequestComplete(conn, null, null);
        switch (response.getStatusLine().getStatusCode()) {
            case 202: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Received a 202 Accepted response");
                }
                SharedInputBuffer inputBuffer = new SharedInputBuffer(8, (IOControl)conn, this.allocator);
                context.setAttribute(RESPONSE_SINK_BUFFER, (Object)inputBuffer);
                MessageContext outMsgCtx = (MessageContext)context.getAttribute(OUTGOING_MESSAGE_CONTEXT);
                MessageReceiver mr = outMsgCtx.getAxisOperation().getMessageReceiver();
                if (!outMsgCtx.isPropertyTrue("IGNORE_SC_ACCEPTED")) {
                    try {
                        MessageContext responseMsgCtx = outMsgCtx.getOperationContext().getMessageContext("In");
                        if (responseMsgCtx == null || outMsgCtx.getOptions().isUseSeparateListener()) {
                            return;
                        }
                        responseMsgCtx.setServerSide(true);
                        responseMsgCtx.setDoingREST(outMsgCtx.isDoingREST());
                        responseMsgCtx.setProperty("TRANSPORT_IN", outMsgCtx.getProperty("TRANSPORT_IN"));
                        responseMsgCtx.setTransportIn(outMsgCtx.getTransportIn());
                        responseMsgCtx.setTransportOut(outMsgCtx.getTransportOut());
                        responseMsgCtx.setAxisMessage(outMsgCtx.getAxisOperation().getMessage("In"));
                        responseMsgCtx.setOperationContext(outMsgCtx.getOperationContext());
                        responseMsgCtx.setConfigurationContext(outMsgCtx.getConfigurationContext());
                        responseMsgCtx.setTo(null);
                        if (!outMsgCtx.isDoingREST() && !outMsgCtx.isSOAP11()) {
                            responseMsgCtx.setEnvelope(new SOAP12Factory().getDefaultEnvelope());
                        } else {
                            responseMsgCtx.setEnvelope(new SOAP11Factory().getDefaultEnvelope());
                        }
                        responseMsgCtx.setProperty("disableAddressingForOutMessages", (Object)Boolean.TRUE);
                        responseMsgCtx.setProperty("SC_ACCEPTED", (Object)Boolean.TRUE);
                        mr.receive(responseMsgCtx);
                    }
                    catch (AxisFault af) {
                        log.debug((Object)"Unable to report back 202 Accepted state to the message receiver");
                    }
                }
                return;
            }
            case 500: {
                Header contentType = response.getFirstHeader(CONTENT_TYPE);
                if (contentType != null) {
                    if (contentType.getValue().indexOf("text/xml") >= 0 || contentType.getValue().indexOf("application/soap+xml") >= 0) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Received an internal server error with a SOAP payload");
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)"Received an internal server error with a POX/REST payload");
                    }
                    this.processResponse(conn, context, response);
                    return;
                }
                log.error((Object)("Received an internal server error : " + response.getStatusLine().getReasonPhrase()));
                return;
            }
            case 100: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Received a 100 Continue response");
                }
                return;
            }
            case 200: {
                this.processResponse(conn, context, response);
                return;
            }
        }
        log.warn((Object)("Unexpected HTTP status code received : " + response.getStatusLine().getStatusCode() + " :: " + response.getStatusLine().getReasonPhrase()));
        Header contentType = response.getFirstHeader(CONTENT_TYPE);
        if (contentType != null) {
            if (contentType.getValue().indexOf("text/xml") >= 0 || contentType.getValue().indexOf("application/soap+xml") >= 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Received an unexpected response with a SOAP payload");
                }
            } else if (contentType.getValue().indexOf("html") == -1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Received an unexpected response with a POX/REST payload");
                }
            } else {
                log.warn((Object)("Received an unexpected response - of content type : " + contentType.getValue() + " and status code : " + response.getStatusLine().getStatusCode() + " with reason : " + response.getStatusLine().getReasonPhrase()));
            }
        } else {
            log.warn((Object)("Received an unexpected response - of unknown content type  with status code : " + response.getStatusLine().getStatusCode() + " and reason : " + response.getStatusLine().getReasonPhrase()));
        }
        this.processResponse(conn, context, response);
    }

    private void processResponse(NHttpClientConnection conn, HttpContext context, HttpResponse response) {
        SharedInputBuffer inputBuffer = new SharedInputBuffer(this.cfg.getBufferSize(), (IOControl)conn, this.allocator);
        context.setAttribute(RESPONSE_SINK_BUFFER, (Object)inputBuffer);
        BasicHttpEntity entity = new BasicHttpEntity();
        if (response.getStatusLine().getProtocolVersion().greaterEquals((ProtocolVersion)HttpVersion.HTTP_1_1)) {
            entity.setChunked(true);
        }
        response.setEntity((HttpEntity)entity);
        context.setAttribute("http.response", (Object)response);
        this.workerPool.execute(new ClientWorker(this.cfgCtx, (InputStream)new ContentInputStream((ContentInputBuffer)inputBuffer), response, (MessageContext)context.getAttribute(OUTGOING_MESSAGE_CONTEXT)));
    }

    public void execute(Runnable task) {
        this.workerPool.execute(task);
    }

    private void handleException(String msg, Exception e, NHttpClientConnection conn) {
        log.error((Object)msg, (Throwable)e);
        if (conn != null) {
            this.shutdownConnection((HttpConnection)conn);
        }
    }

    private void shutdownConnection(HttpConnection conn) {
        try {
            conn.shutdown();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private HttpProcessor getHttpProcessor() {
        BasicHttpProcessor httpProcessor = new BasicHttpProcessor();
        httpProcessor.addInterceptor((HttpRequestInterceptor)new RequestContent());
        httpProcessor.addInterceptor((HttpRequestInterceptor)new RequestTargetHost());
        httpProcessor.addInterceptor((HttpRequestInterceptor)new RequestConnControl());
        httpProcessor.addInterceptor((HttpRequestInterceptor)new RequestUserAgent());
        httpProcessor.addInterceptor((HttpRequestInterceptor)new RequestExpectContinue());
        return httpProcessor;
    }

    public int getActiveCount() {
        return this.workerPool.getActiveCount();
    }

    public int getQueueSize() {
        return this.workerPool.getQueueSize();
    }
}

