/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.ClosedChannelException;
import java.util.Map;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.nio.entity.ContentOutputStream;
import org.apache.http.nio.util.ContentOutputBuffer;
import org.apache.synapse.transport.nhttp.NhttpUtils;
import org.apache.synapse.transport.nhttp.util.MessageFormatterDecoratorFactory;
import org.apache.synapse.transport.nhttp.util.RESTUtil;

public class Axis2HttpRequest {
    private static final Log log = LogFactory.getLog(Axis2HttpRequest.class);
    private EndpointReference epr = null;
    private HttpHost httpHost = null;
    private MessageContext msgContext = null;
    MessageFormatter messageFormatter = null;
    OMOutputFormat format = null;
    private ContentOutputBuffer outputBuffer = null;
    private boolean readyToStream = false;
    private boolean completed = false;

    public Axis2HttpRequest(EndpointReference epr, HttpHost httpHost, MessageContext msgContext) {
        this.epr = epr;
        this.httpHost = httpHost;
        this.msgContext = msgContext;
        this.format = NhttpUtils.getOMOutputFormat(msgContext);
        this.messageFormatter = MessageFormatterDecoratorFactory.createMessageFormatterDecorator(msgContext);
    }

    public void setReadyToStream(boolean readyToStream) {
        this.readyToStream = readyToStream;
    }

    public void setOutputBuffer(ContentOutputBuffer outputBuffer) {
        this.outputBuffer = outputBuffer;
    }

    public void clear() {
        this.epr = null;
        this.httpHost = null;
        this.msgContext = null;
        this.format = null;
        this.messageFormatter = null;
        this.outputBuffer = null;
    }

    public EndpointReference getEpr() {
        return this.epr;
    }

    public HttpHost getHttpHost() {
        return this.httpHost;
    }

    public MessageContext getMsgContext() {
        return this.msgContext;
    }

    public HttpRequest getRequest() throws IOException {
        String soapAction;
        boolean doingGET = "GET".equals(this.msgContext.getProperty("HTTP_METHOD"));
        BasicHttpEntityEnclosingRequest httpRequest = null;
        if (this.msgContext.isPropertyTrue("FORCE_HTTP_1.0")) {
            if (doingGET) {
                httpRequest = new BasicHttpRequest("GET", RESTUtil.getURI(this.msgContext, this.epr.getAddress()), (ProtocolVersion)HttpVersion.HTTP_1_0);
            } else {
                httpRequest = new BasicHttpEntityEnclosingRequest("POST", this.epr.getAddress(), (ProtocolVersion)HttpVersion.HTTP_1_0);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.messageFormatter.writeTo(this.msgContext, this.format, (OutputStream)baos, false);
                BasicHttpEntity entity = new BasicHttpEntity();
                entity.setContentLength((long)baos.toByteArray().length);
                httpRequest.setEntity((HttpEntity)entity);
            }
        } else if (doingGET) {
            httpRequest = new BasicHttpRequest("GET", RESTUtil.getURI(this.msgContext, this.epr.getAddress()));
        } else {
            httpRequest = new BasicHttpEntityEnclosingRequest("POST", this.epr.getAddress());
            httpRequest.setEntity((HttpEntity)new BasicHttpEntity());
        }
        Object o = this.msgContext.getProperty("TRANSPORT_HEADERS");
        if (o != null && o instanceof Map) {
            Map headers = (Map)o;
            for (Object header : headers.keySet()) {
                Object value = headers.get(header);
                if (!(header instanceof String) || value == null || !(value instanceof String)) continue;
                httpRequest.setHeader((String)header, (String)value);
            }
        }
        if ((soapAction = this.msgContext.getSoapAction()) == null) {
            soapAction = this.msgContext.getWSAAction();
        }
        if (soapAction == null) {
            this.msgContext.getAxisOperation().getInputAction();
        }
        if (this.msgContext.isSOAP11() && soapAction != null && soapAction.length() > 0) {
            Header existingHeader = httpRequest.getFirstHeader("SOAPAction");
            if (existingHeader != null) {
                httpRequest.removeHeader(existingHeader);
            }
            httpRequest.setHeader("SOAPAction", soapAction);
        }
        httpRequest.setHeader("Content-Type", this.messageFormatter.getContentType(this.msgContext, this.format, this.msgContext.getSoapAction()));
        return httpRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamMessageContents() throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start streaming outgoing http request");
        }
        Axis2HttpRequest axis2HttpRequest = this;
        synchronized (axis2HttpRequest) {
            while (!this.readyToStream && !this.completed) {
                try {
                    this.wait();
                }
                catch (InterruptedException ignore) {}
            }
        }
        if (!this.completed) {
            ContentOutputStream out = new ContentOutputStream(this.outputBuffer);
            try {
                this.messageFormatter.writeTo(this.msgContext, this.format, (OutputStream)out, false);
            }
            catch (Exception e) {
                Throwable t = e.getCause();
                if (t != null && t.getCause() != null && t.getCause() instanceof ClosedChannelException) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Ignore closed channel exception, as the SessionRequestCallback handles this exception");
                    }
                } else {
                    if (e instanceof AxisFault) {
                        throw (AxisFault)((Object)e);
                    }
                    this.handleException("Error streaming message context", e);
                }
            }
            finally {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    this.handleException("Error closing outgoing message stream", e);
                }
            }
        }
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    public boolean isCompleted() {
        return this.completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompleted(boolean completed) {
        this.completed = completed;
        Axis2HttpRequest axis2HttpRequest = this;
        synchronized (axis2HttpRequest) {
            this.notifyAll();
        }
    }
}

