/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.mail;

import java.io.IOException;
import java.io.InputStream;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.base.BaseUtils;

public class MailUtils
extends BaseUtils {
    private static final Log log = LogFactory.getLog(MailUtils.class);
    private static BaseUtils _instance = new MailUtils();

    public static BaseUtils getInstace() {
        return _instance;
    }

    public String getProperty(Object message, String property) {
        try {
            String[] o = ((Message)message).getHeader(property);
            if (o instanceof String) {
                return (String)o;
            }
            if (o instanceof String[] && o.length > 0) {
                return o[0];
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return null;
    }

    public InputStream getInputStream(Object message) {
        block6: {
            try {
                if (!(message instanceof MimeMessage)) break block6;
                MimeMessage msg = (MimeMessage)message;
                if (msg.getContent() instanceof Multipart) {
                    MimeBodyPart firstTextPart = null;
                    Multipart mp = (Multipart)msg.getContent();
                    for (int i = 0; i < mp.getCount(); ++i) {
                        MimeBodyPart mbp = (MimeBodyPart)mp.getBodyPart(i);
                        String contType = mbp.getContentType();
                        if (contType != null && (contType.indexOf("text/xml") != -1 || contType.indexOf("application/soap+xml") != -1)) {
                            return mbp.getInputStream();
                        }
                        if (mbp == null || contType.indexOf("text/plain") == -1) continue;
                        firstTextPart = mbp;
                    }
                    if (firstTextPart != null) {
                        return firstTextPart.getInputStream();
                    }
                    break block6;
                }
                return ((Message)message).getInputStream();
            }
            catch (Exception e) {
                MailUtils.handleException("Error creating an input stream to : " + ((Message)message).getMessageNumber(), e);
            }
        }
        return null;
    }

    public String getMessageTextPayload(Object message) {
        try {
            return new String(MailUtils.getBytesFromInputStream(this.getInputStream(message), ((Message)message).getSize()));
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error reading message payload as text for : " + ((Message)message).getMessageNumber()), (Throwable)e);
            }
            return null;
        }
    }

    public byte[] getMessageBinaryPayload(Object message) {
        try {
            return MailUtils.getBytesFromInputStream(this.getInputStream(message), ((Message)message).getSize());
        }
        catch (Exception e) {
            MailUtils.handleException("Error reading message payload as a byte[] for : " + ((Message)message).getMessageNumber(), e);
            return new byte[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromInputStream(InputStream is, int length) throws IOException {
        byte[] bytes = new byte[length];
        int numRead = 0;
        try {
            int offset;
            for (offset = 0; offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                MailUtils.handleException("Could not completely read the stream to conver to a byte[]");
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ignore) {}
        }
        return bytes;
    }
}

