/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterIncludeImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.base.BaseUtils;
import org.apache.synapse.transport.jms.JMSConnectionFactory;

public class JMSUtils
extends BaseUtils {
    private static final Log log = LogFactory.getLog(JMSUtils.class);
    private static final Class[] NOARGS = new Class[0];
    private static final Object[] NOPARMS = new Object[0];
    private static BaseUtils _instance = new JMSUtils();

    public static BaseUtils getInstace() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createJMSQueue(Connection con, String destinationJNDIName) throws JMSException {
        try {
            QueueSession session = ((QueueConnection)con).createQueueSession(false, 1);
            Queue queue = session.createQueue(destinationJNDIName);
            log.info((Object)("JMS Queue with JNDI name : " + destinationJNDIName + " created"));
            String string = queue.getQueueName();
            return string;
        }
        finally {
            try {
                con.close();
            }
            catch (JMSException ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createJMSTopic(Connection con, String destinationJNDIName) throws JMSException {
        try {
            TopicSession session = ((TopicConnection)con).createTopicSession(false, 1);
            Topic topic = session.createTopic(destinationJNDIName);
            log.info((Object)("JMS Topic with JNDI name : " + destinationJNDIName + " created"));
            String string = topic.getTopicName();
            return string;
        }
        finally {
            try {
                con.close();
            }
            catch (JMSException ignore) {}
        }
    }

    public static boolean isJMSService(AxisService service) {
        if (service.isEnableAllTransports()) {
            return true;
        }
        List transports = service.getExposedTransports();
        for (int i = 0; i < transports.size(); ++i) {
            if (!"jms".equals(transports.get(i))) continue;
            return true;
        }
        return false;
    }

    public static String getJNDIDestinationNameForService(AxisService service) {
        Parameter destParam = service.getParameter("transport.jms.Destination");
        if (destParam != null) {
            return (String)destParam.getValue();
        }
        return service.getName();
    }

    public static String getDestinationTypeForService(AxisService service) {
        Parameter destTypeParam = service.getParameter("transport.jms.DestinationType");
        if (destTypeParam != null) {
            String paramValue = (String)destTypeParam.getValue();
            if ("queue".equals(paramValue) || "topic".equals(paramValue)) {
                return paramValue;
            }
            JMSUtils.handleException("Invalid destinaton type value " + paramValue);
            return null;
        }
        log.debug((Object)"JMS destination type not given. default queue");
        return "queue";
    }

    public static Hashtable getProperties(String url) {
        Hashtable<String, String> h = new Hashtable<String, String>();
        int propPos = url.indexOf("?");
        if (propPos != -1) {
            StringTokenizer st = new StringTokenizer(url.substring(propPos + 1), "&");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int sep = token.indexOf("=");
                if (sep == -1) continue;
                h.put(token.substring(0, sep), token.substring(sep + 1));
            }
        }
        return h;
    }

    static String getEPR(JMSConnectionFactory cf, String destination) {
        StringBuffer sb = new StringBuffer();
        sb.append("jms:/").append(destination);
        sb.append("?").append("transport.jms.ConnectionFactoryJNDIName").append("=").append(cf.getConnFactoryJNDIName());
        for (String key : cf.getJndiProperties().keySet()) {
            String value = (String)cf.getJndiProperties().get(key);
            sb.append("&").append(key).append("=").append(value);
        }
        return sb.toString();
    }

    public String getProperty(Object message, String property) {
        try {
            return ((Message)message).getStringProperty(property);
        }
        catch (JMSException e) {
            return null;
        }
    }

    public static String getDestination(String url) {
        String tempUrl = url.substring("jms:/".length());
        int propPos = tempUrl.indexOf("?");
        if (propPos == -1) {
            return tempUrl;
        }
        return tempUrl.substring(0, propPos);
    }

    public static void setConnectionFactoryParameters(Parameter param, JMSConnectionFactory jmsConFactory) {
        ParameterIncludeImpl pi = new ParameterIncludeImpl();
        try {
            pi.deserializeParameters((OMElement)param.getValue());
        }
        catch (AxisFault axisFault) {
            log.error((Object)("Error reading parameters for JMS connection factory" + jmsConFactory.getName()), (Throwable)axisFault);
        }
        for (Parameter p : pi.getParameters()) {
            if ("transport.jms.ConnectionFactoryType".equals(p.getName())) {
                String connectionFactoryType = (String)p.getValue();
                jmsConFactory.setConnectionFactoryType(connectionFactoryType);
                continue;
            }
            if ("transport.jms.ReconnectTimeout".equals(p.getName())) {
                String strTimeout = (String)p.getValue();
                int reconnectTimeoutSeconds = Integer.parseInt(strTimeout);
                long reconnectTimeoutMillis = reconnectTimeoutSeconds * 1000;
                jmsConFactory.setReconnectTimeout(reconnectTimeoutMillis);
                continue;
            }
            if ("java.naming.factory.initial".equals(p.getName())) {
                jmsConFactory.addJNDIContextProperty("java.naming.factory.initial", (String)p.getValue());
                continue;
            }
            if ("java.naming.provider.url".equals(p.getName())) {
                jmsConFactory.addJNDIContextProperty("java.naming.provider.url", (String)p.getValue());
                continue;
            }
            if ("java.naming.security.principal".equals(p.getName())) {
                jmsConFactory.addJNDIContextProperty("java.naming.security.principal", (String)p.getValue());
                continue;
            }
            if ("java.naming.security.credentials".equals(p.getName())) {
                jmsConFactory.addJNDIContextProperty("java.naming.security.credentials", (String)p.getValue());
                continue;
            }
            if (!"transport.jms.ConnectionFactoryJNDIName".equals(p.getName())) continue;
            jmsConFactory.setConnFactoryJNDIName((String)p.getValue());
            jmsConFactory.addJNDIContextProperty("transport.jms.ConnectionFactoryJNDIName", (String)p.getValue());
        }
    }

    public InputStream getInputStream(Object message) {
        try {
            if (message instanceof BytesMessage) {
                byte[] buffer = new byte[1024];
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                BytesMessage byteMsg = (BytesMessage)message;
                int bytesRead = byteMsg.readBytes(buffer);
                while (bytesRead != -1) {
                    out.write(buffer, 0, bytesRead);
                    bytesRead = byteMsg.readBytes(buffer);
                }
                return new ByteArrayInputStream(out.toByteArray());
            }
            if (message instanceof TextMessage) {
                TextMessage txtMsg = (TextMessage)message;
                String contentType = this.getProperty(txtMsg, "Content-Type");
                if (contentType != null) {
                    return new ByteArrayInputStream(txtMsg.getText().getBytes(BuilderUtil.getCharSetEncoding((String)contentType)));
                }
                return new ByteArrayInputStream(txtMsg.getText().getBytes());
            }
            JMSUtils.handleException("Unsupported JMS message type : " + message.getClass().getName());
        }
        catch (JMSException e) {
            JMSUtils.handleException("JMS Exception reading message payload", (Exception)((Object)e));
        }
        catch (UnsupportedEncodingException e) {
            JMSUtils.handleException("Encoding exception getting InputStream into message", e);
        }
        return null;
    }

    public static Destination setReplyDestination(Destination replyDestination, Session session, Message message) {
        if (replyDestination == null) {
            try {
                replyDestination = JMSUtils.createTemporaryDestination(session);
            }
            catch (JMSException e) {
                JMSUtils.handleException("Error creating temporary queue for response");
            }
        }
        try {
            message.setJMSReplyTo(replyDestination);
        }
        catch (JMSException e) {
            log.warn((Object)("Error setting JMS ReplyTo destination to : " + replyDestination), (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            try {
                log.debug((Object)("Expecting a response to JMS Destination : " + (replyDestination instanceof Queue ? ((Queue)replyDestination).getQueueName() : ((Topic)replyDestination).getTopicName())));
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        return replyDestination;
    }

    public static Destination createDestinationIfRequired(Destination destination, String destinationType, String targetAddress, Session session) throws AxisFault {
        if (destination == null) {
            if (targetAddress != null) {
                String name = JMSUtils.getDestination(targetAddress);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating JMS Destination : " + name));
                }
                try {
                    destination = JMSUtils.createDestination(session, name, destinationType);
                }
                catch (JMSException e) {
                    JMSUtils.handleException("Error creating destination Queue : " + name, (Exception)((Object)e));
                }
            } else {
                JMSUtils.handleException("Cannot send reply to null JMS Destination");
            }
        }
        return destination;
    }

    public static Destination createReplyDestinationIfRequired(Destination destination, String replyDestinationName, String destinationType, String targetAddress, Session session) throws AxisFault {
        if (destination == null) {
            if (targetAddress != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating JMS Reply Destination : " + replyDestinationName));
                }
                try {
                    destination = JMSUtils.createDestination(session, replyDestinationName, destinationType);
                }
                catch (JMSException e) {
                    JMSUtils.handleException("Error creating reply destination : " + replyDestinationName, (Exception)((Object)e));
                }
            } else {
                JMSUtils.handleException("Cannot send reply to null reply JMS Destination");
            }
        }
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMessageToJMSDestination(Session session, Destination destination, String destinationType, Message message) throws AxisFault {
        TopicPublisher producer = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending message to destination : " + destination));
            }
            if ("topic".equals(destinationType)) {
                producer = ((TopicSession)session).createPublisher((Topic)destination);
                producer.publish(message);
            } else {
                producer = ((QueueSession)session).createSender((Queue)destination);
                ((QueueSender)producer).send(message);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sent message to destination : " + destination + "\nMessage ID : " + message.getJMSMessageID() + "\nCorrelation ID : " + message.getJMSCorrelationID() + "\nReplyTo ID : " + message.getJMSReplyTo()));
            }
        }
        catch (JMSException e) {
            JMSUtils.handleException("Error creating a producer or sending to : " + destination, (Exception)((Object)e));
        }
        finally {
            if (producer != null) {
                try {
                    producer.close();
                }
                catch (JMSException ignore) {}
            }
        }
    }

    public static void setTransportHeaders(MessageContext msgContext, Message message) throws JMSException {
        Map headerMap = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
        if (headerMap == null) {
            return;
        }
        for (String name : headerMap.keySet()) {
            if ("JMS_COORELATION_ID".equals(name)) {
                message.setJMSCorrelationID((String)headerMap.get("JMS_COORELATION_ID"));
                continue;
            }
            if ("JMS_DELIVERY_MODE".equals(name)) {
                Object o = headerMap.get("JMS_DELIVERY_MODE");
                if (o instanceof Integer) {
                    message.setJMSDeliveryMode(((Integer)o).intValue());
                    continue;
                }
                if (o instanceof String) {
                    try {
                        message.setJMSDeliveryMode(Integer.parseInt((String)o));
                    }
                    catch (NumberFormatException nfe) {
                        log.warn((Object)("Invalid delivery mode ignored : " + o), (Throwable)nfe);
                    }
                    continue;
                }
                log.warn((Object)("Invalid delivery mode ignored : " + o));
                continue;
            }
            if ("JMS_EXPIRATION".equals(name)) {
                message.setJMSExpiration(Long.parseLong((String)headerMap.get("JMS_EXPIRATION")));
                continue;
            }
            if ("JMS_MESSAGE_ID".equals(name)) {
                message.setJMSMessageID((String)headerMap.get("JMS_MESSAGE_ID"));
                continue;
            }
            if ("JMS_PRIORITY".equals(name)) {
                message.setJMSPriority(Integer.parseInt((String)headerMap.get("JMS_PRIORITY")));
                continue;
            }
            if ("JMS_TIMESTAMP".equals(name)) {
                message.setJMSTimestamp(Long.parseLong((String)headerMap.get("JMS_TIMESTAMP")));
                continue;
            }
            if ("JMS_MESSAGE_TYPE".equals(name)) {
                message.setJMSType((String)headerMap.get("JMS_MESSAGE_TYPE"));
                continue;
            }
            Object value = headerMap.get(name);
            if (value instanceof String) {
                message.setStringProperty(name, (String)value);
                continue;
            }
            if (value instanceof Boolean) {
                message.setBooleanProperty(name, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Integer) {
                message.setIntProperty(name, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof Long) {
                message.setLongProperty(name, ((Long)value).longValue());
                continue;
            }
            if (value instanceof Double) {
                message.setDoubleProperty(name, ((Double)value).doubleValue());
                continue;
            }
            if (!(value instanceof Float)) continue;
            message.setFloatProperty(name, ((Float)value).floatValue());
        }
    }

    public static void loadTransportHeaders(Message message, MessageContext responseMsgCtx) throws AxisFault {
        responseMsgCtx.setProperty("TRANSPORT_HEADERS", (Object)JMSUtils.getTransportHeaders(message));
    }

    public static Map getTransportHeaders(Message message) {
        Destination dest;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (message.getJMSCorrelationID() != null) {
                map.put("JMS_COORELATION_ID", message.getJMSCorrelationID());
            }
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        try {
            map.put("JMS_DELIVERY_MODE", Integer.toString(message.getJMSDeliveryMode()));
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        try {
            if (message.getJMSDestination() != null) {
                dest = message.getJMSDestination();
                map.put("JMS_DESTINATION", dest instanceof Queue ? ((Queue)dest).getQueueName() : ((Topic)dest).getTopicName());
            }
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        try {
            map.put("JMS_EXPIRATION", Long.toString(message.getJMSExpiration()));
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        try {
            if (message.getJMSMessageID() != null) {
                map.put("JMS_MESSAGE_ID", message.getJMSMessageID());
            }
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        try {
            map.put("JMS_PRIORITY", Long.toString(message.getJMSPriority()));
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        try {
            map.put("JMS_REDELIVERED", Boolean.toString(message.getJMSRedelivered()));
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        try {
            if (message.getJMSReplyTo() != null) {
                dest = message.getJMSReplyTo();
                map.put("JMS_REPLY_TO", dest instanceof Queue ? ((Queue)dest).getQueueName() : ((Topic)dest).getTopicName());
            }
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        try {
            map.put("JMS_TIMESTAMP", Long.toString(message.getJMSTimestamp()));
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        try {
            if (message.getJMSType() != null) {
                map.put("JMS_TYPE", message.getJMSType());
            }
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        Enumeration e = null;
        try {
            e = message.getPropertyNames();
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        if (e != null) {
            while (e.hasMoreElements()) {
                String headerName = (String)e.nextElement();
                try {
                    map.put(headerName, message.getStringProperty(headerName));
                }
                catch (JMSException ignore) {
                    try {
                        map.put(headerName, message.getBooleanProperty(headerName));
                    }
                    catch (JMSException ignore2) {
                        try {
                            map.put(headerName, new Integer(message.getIntProperty(headerName)));
                        }
                        catch (JMSException ignore3) {
                            try {
                                map.put(headerName, new Long(message.getLongProperty(headerName)));
                            }
                            catch (JMSException ignore4) {
                                try {
                                    map.put(headerName, new Double(message.getDoubleProperty(headerName)));
                                }
                                catch (JMSException ignore5) {
                                    try {
                                        map.put(headerName, new Float(message.getFloatProperty(headerName)));
                                    }
                                    catch (JMSException ignore6) {}
                                }
                            }
                        }
                    }
                }
            }
        }
        return map;
    }

    public String getMessageTextPayload(Object message) {
        if (message instanceof TextMessage) {
            try {
                return ((TextMessage)message).getText();
            }
            catch (JMSException e) {
                JMSUtils.handleException("Error reading JMS text message payload", (Exception)((Object)e));
            }
        }
        return null;
    }

    public byte[] getMessageBinaryPayload(Object message) {
        if (message instanceof BytesMessage) {
            BytesMessage bytesMessage = (BytesMessage)message;
            try {
                bytesMessage.reset();
                byte[] buffer = new byte[1024];
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                int bytesRead = bytesMessage.readBytes(buffer);
                while (bytesRead != -1) {
                    out.write(buffer, 0, bytesRead);
                    bytesRead = bytesMessage.readBytes(buffer);
                }
                return out.toByteArray();
            }
            catch (JMSException e) {
                JMSUtils.handleException("Error reading JMS binary message payload", (Exception)((Object)e));
            }
        }
        return null;
    }

    public static Connection createConnection(ConnectionFactory conFactory, String user, String pass, String destinationType) throws JMSException {
        if ("queue".equals(destinationType)) {
            if (user != null && pass != null) {
                return ((QueueConnectionFactory)conFactory).createQueueConnection(user, pass);
            }
            return ((QueueConnectionFactory)conFactory).createQueueConnection();
        }
        if ("topic".equals(destinationType)) {
            if (user != null && pass != null) {
                return ((TopicConnectionFactory)conFactory).createTopicConnection(user, pass);
            }
            return ((TopicConnectionFactory)conFactory).createTopicConnection();
        }
        JMSUtils.handleException("Unable to determine type of JMS Connection Factory - i.e Queue/Topic");
        return null;
    }

    public static Session createSession(Connection con, boolean transacted, int acknowledgeMode, String destinationType) throws JMSException {
        if ("queue".equals(destinationType)) {
            return ((QueueConnection)con).createQueueSession(transacted, acknowledgeMode);
        }
        if ("topic".equals(destinationType)) {
            return ((TopicConnection)con).createTopicSession(transacted, acknowledgeMode);
        }
        log.debug((Object)("JMS destination type not given or invalid. default queue. was " + destinationType));
        return ((QueueConnection)con).createQueueSession(transacted, acknowledgeMode);
    }

    public static Destination createDestination(Session session, String destName, String destinationType) throws JMSException {
        if ("queue".equals(destinationType)) {
            return ((QueueSession)session).createQueue(destName);
        }
        if ("topic".equals(destinationType)) {
            return ((TopicSession)session).createTopic(destName);
        }
        log.debug((Object)("JMS destination type not given or invalid. default queue. was " + destinationType));
        return ((QueueSession)session).createQueue(destName);
    }

    public static void createDestination(ConnectionFactory conFactory, String destinationJNDIName, String destinationType) throws JMSException {
        if ("queue".equals(destinationType)) {
            JMSUtils.createJMSQueue((Connection)((QueueConnectionFactory)conFactory).createQueueConnection(), destinationJNDIName);
        } else if ("topic".equals(destinationType)) {
            JMSUtils.createJMSTopic((Connection)((TopicConnectionFactory)conFactory).createTopicConnection(), destinationJNDIName);
        }
    }

    public static MessageConsumer createConsumer(Session session, Destination dest) throws JMSException {
        if (dest instanceof Queue) {
            return ((QueueSession)session).createReceiver((Queue)dest);
        }
        return ((TopicSession)session).createSubscriber((Topic)dest);
    }

    public static Destination createTemporaryDestination(Session session) throws JMSException {
        if (session instanceof QueueSession) {
            return ((QueueSession)session).createTemporaryQueue();
        }
        return ((TopicSession)session).createTemporaryTopic();
    }

    public static long getBodyLength(BytesMessage bMsg) {
        block7: {
            try {
                Method mtd = bMsg.getClass().getMethod("getBodyLength", NOARGS);
                if (mtd != null) {
                    return (Long)mtd.invoke((Object)bMsg, NOPARMS);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block7;
                log.debug((Object)"Error trying to determine JMS BytesMessage body length", (Throwable)e);
            }
        }
        long length = 0L;
        try {
            byte[] buffer = new byte[2048];
            bMsg.reset();
            int bytesRead = bMsg.readBytes(buffer);
            while (bytesRead != -1) {
                if (bytesRead != -1) {
                    length += (long)bytesRead;
                }
                bytesRead = bMsg.readBytes(buffer);
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return length;
    }
}

