/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.jms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.activation.DataHandler;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.NamingException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMText;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.base.AbstractTransportSender;
import org.apache.synapse.transport.base.BaseConstants;
import org.apache.synapse.transport.base.BaseTransportException;
import org.apache.synapse.transport.base.BaseUtils;
import org.apache.synapse.transport.base.ManagementSupport;
import org.apache.synapse.transport.jms.JMSConnectionFactory;
import org.apache.synapse.transport.jms.JMSOutTransportInfo;
import org.apache.synapse.transport.jms.JMSUtils;

public class JMSSender
extends AbstractTransportSender
implements ManagementSupport {
    public static final String TRANSPORT_NAME = "jms";
    private Map connectionFactories = new HashMap();

    public JMSSender() {
        this.log = LogFactory.getLog(JMSSender.class);
    }

    public void init(ConfigurationContext cfgCtx, TransportOutDescription transportOut) throws AxisFault {
        this.setTransportName(TRANSPORT_NAME);
        super.init(cfgCtx, transportOut);
        this.loadConnectionFactoryDefinitions(transportOut);
    }

    private JMSConnectionFactory getJMSConnectionFactory(JMSOutTransportInfo trpInfo) {
        String jmsConnectionFactoryName;
        if (trpInfo.getProperties() != null && (jmsConnectionFactoryName = (String)trpInfo.getProperties().get("transport.jms.ConnectionFactory")) != null) {
            return (JMSConnectionFactory)this.connectionFactories.get(jmsConnectionFactoryName);
        }
        for (String cfName : this.connectionFactories.keySet()) {
            JMSConnectionFactory cf = (JMSConnectionFactory)this.connectionFactories.get(cfName);
            if (!cf.equals(trpInfo)) continue;
            return cf;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(MessageContext msgCtx, String targetAddress, OutTransportInfo outTransportInfo) throws AxisFault {
        JMSConnectionFactory jmsConnectionFactory = null;
        QueueConnection connection = null;
        JMSOutTransportInfo jmsOut = null;
        Session session = null;
        Destination destination = null;
        Destination replyDestination = null;
        try {
            if (targetAddress != null) {
                jmsOut = new JMSOutTransportInfo(targetAddress);
                jmsConnectionFactory = this.getJMSConnectionFactory(jmsOut);
                if (jmsConnectionFactory != null) {
                    session = jmsConnectionFactory.getSessionForDestination(JMSUtils.getDestination(targetAddress));
                } else {
                    jmsOut.loadConnectionFactoryFromProperies();
                    try {
                        Hashtable jndiProps = jmsOut.getProperties();
                        String user = (String)jndiProps.get("java.naming.security.principal");
                        String pass = (String)jndiProps.get("java.naming.security.credentials");
                        QueueConnectionFactory qConFac = null;
                        TopicConnectionFactory tConFac = null;
                        Object conFac = null;
                        if ("queue".equals(jmsOut.getDestinationType())) {
                            qConFac = (QueueConnectionFactory)jmsOut.getConnectionFactory();
                        } else if ("topic".equals(jmsOut.getDestinationType())) {
                            tConFac = (TopicConnectionFactory)jmsOut.getConnectionFactory();
                        } else {
                            this.handleException("Unable to determine type of JMS Connection Factory - i.e Queue/Topic");
                        }
                        if (user != null && pass != null) {
                            if (qConFac != null) {
                                connection = qConFac.createQueueConnection(user, pass);
                            } else if (tConFac != null) {
                                connection = tConFac.createTopicConnection(user, pass);
                            }
                        } else if (qConFac != null) {
                            connection = qConFac.createQueueConnection();
                        } else if (tConFac != null) {
                            connection = tConFac.createTopicConnection();
                        }
                        if ("queue".equals(jmsOut.getDestinationType())) {
                            session = connection.createQueueSession(false, 1);
                        } else if ("topic".equals(jmsOut.getDestinationType())) {
                            session = ((TopicConnection)connection).createTopicSession(false, 1);
                        }
                    }
                    catch (JMSException e) {
                        this.handleException("Error creating a connection/session for : " + targetAddress);
                    }
                }
                destination = jmsOut.getDestination();
                replyDestination = jmsOut.getReplyDestination();
            } else if (outTransportInfo != null && outTransportInfo instanceof JMSOutTransportInfo) {
                jmsOut = (JMSOutTransportInfo)outTransportInfo;
                jmsConnectionFactory = jmsOut.getJmsConnectionFactory();
                session = jmsConnectionFactory.getSessionForDestination(jmsOut.getDestination().toString());
                destination = jmsOut.getDestination();
            }
            String replyDestName = (String)msgCtx.getProperty("JMS_REPLY_TO");
            if (replyDestName != null) {
                replyDestination = jmsConnectionFactory != null ? jmsConnectionFactory.getDestination(replyDestName) : jmsOut.getReplyDestination(replyDestName);
            }
            if (session == null) {
                this.handleException("Could not create JMS session");
            }
            Session session2 = session;
            synchronized (session2) {
                boolean waitForResponse;
                String correlationId;
                Message message;
                block53: {
                    message = null;
                    correlationId = null;
                    try {
                        message = this.createJMSMessage(msgCtx, session);
                    }
                    catch (JMSException e) {
                        this.handleException("Error creating a JMS message from the axis message context", (Exception)((Object)e));
                    }
                    String destinationType = jmsOut.getDestinationType();
                    destination = JMSUtils.createDestinationIfRequired(destination, destinationType, targetAddress, session);
                    if (jmsOut.getReplyDestinationName() != null) {
                        replyDestination = JMSUtils.createReplyDestinationIfRequired(replyDestination, jmsOut.getReplyDestinationName(), jmsOut.getReplyDestinationType(), targetAddress, session);
                    }
                    if (waitForResponse = this.waitForSynchronousResponse(msgCtx)) {
                        replyDestination = JMSUtils.setReplyDestination(replyDestination, session, message);
                    }
                    try {
                        JMSUtils.sendMessageToJMSDestination(session, destination, destinationType, message);
                        try {
                            String msgId = message.getJMSMessageID();
                            if (msgId != null) {
                                msgCtx.setProperty("JMS_MESSAGE_ID", (Object)msgId);
                            }
                        }
                        catch (JMSException ignore) {
                            // empty catch block
                        }
                        this.metrics.incrementMessagesSent();
                        try {
                            if (message instanceof BytesMessage) {
                                this.metrics.incrementBytesSent(JMSUtils.getBodyLength((BytesMessage)message));
                                break block53;
                            }
                            if (message instanceof TextMessage) {
                                this.metrics.incrementBytesSent(((TextMessage)message).getText().getBytes().length);
                                break block53;
                            }
                            this.handleException("Unsupported JMS message type : " + message.getClass().getName());
                        }
                        catch (JMSException e) {
                            this.log.warn((Object)"Error reading JMS message size to update transport metrics", (Throwable)e);
                        }
                    }
                    catch (BaseTransportException e) {
                        this.metrics.incrementFaultsSending();
                        throw e;
                    }
                }
                if (waitForResponse) {
                    try {
                        connection.start();
                    }
                    catch (JMSException ignore) {
                        // empty catch block
                    }
                    try {
                        correlationId = message.getJMSMessageID();
                    }
                    catch (JMSException ignore) {
                        // empty catch block
                    }
                    this.waitForResponseAndProcess(session, replyDestination, jmsOut.getReplyDestinationType(), msgCtx, correlationId);
                }
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException ignore) {}
            }
        }
    }

    private void waitForResponseAndProcess(Session session, Destination replyDestination, String replyDestinationType, MessageContext msgCtx, String correlationId) throws AxisFault {
        block13: {
            try {
                Message reply;
                Object consumer = null;
                consumer = "queue".equals(replyDestinationType) ? (correlationId != null ? ((QueueSession)session).createReceiver((Queue)replyDestination, "JMSCorrelationID = '" + correlationId + "'") : ((QueueSession)session).createReceiver((Queue)replyDestination)) : (correlationId != null ? ((TopicSession)session).createSubscriber((Topic)replyDestination, "JMSCorrelationID = '" + correlationId + "'", false) : ((TopicSession)session).createSubscriber((Topic)replyDestination));
                long timeout = 30000L;
                String waitReply = (String)msgCtx.getProperty("JMS_WAIT_REPLY");
                if (waitReply != null) {
                    timeout = Long.valueOf(waitReply);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Waiting for a maximum of " + timeout + "ms for a response message to destination : " + replyDestination + " with JMS correlation ID : " + correlationId));
                }
                if ((reply = consumer.receive(timeout)) != null) {
                    this.metrics.incrementMessagesReceived();
                    try {
                        if (reply instanceof BytesMessage) {
                            this.metrics.incrementBytesReceived(JMSUtils.getBodyLength((BytesMessage)reply));
                        } else if (reply instanceof TextMessage) {
                            this.metrics.incrementBytesReceived(((TextMessage)reply).getText().getBytes().length);
                        } else {
                            this.handleException("Unsupported JMS message type : " + reply.getClass().getName());
                        }
                    }
                    catch (JMSException e) {
                        this.log.warn((Object)"Error reading JMS message size to update transport metrics", (Throwable)e);
                    }
                    try {
                        this.processSyncResponse(msgCtx, reply);
                        this.metrics.incrementMessagesReceived();
                        break block13;
                    }
                    catch (AxisFault e) {
                        this.metrics.incrementFaultsReceiving();
                        throw e;
                    }
                }
                this.log.warn((Object)("Did not receive a JMS response within " + timeout + " ms to destination : " + replyDestination + " with JMS correlation ID : " + correlationId));
                this.metrics.incrementTimeoutsReceiving();
            }
            catch (JMSException e) {
                this.metrics.incrementFaultsReceiving();
                this.handleException("Error creating consumer or receiving reply to : " + replyDestination, (Exception)((Object)e));
            }
        }
    }

    private Message createJMSMessage(MessageContext msgContext, Session session) throws JMSException, AxisFault {
        BytesMessage message = null;
        String msgType = this.getProperty(msgContext, "JMS_MESSAGE_TYPE");
        String jmsPayloadType = this.guessMessageType(msgContext);
        if (jmsPayloadType == null) {
            OMOutputFormat format = BaseUtils.getOMOutputFormat(msgContext);
            MessageFormatter messageFormatter = null;
            try {
                messageFormatter = TransportUtils.getMessageFormatter((MessageContext)msgContext);
            }
            catch (AxisFault axisFault) {
                throw new JMSException("Unable to get the message formatter to use");
            }
            String contentType = messageFormatter.getContentType(msgContext, format, msgContext.getSoapAction());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                messageFormatter.writeTo(msgContext, format, (OutputStream)baos, true);
                baos.flush();
            }
            catch (IOException e) {
                this.handleException("IO Error while creating BytesMessage", e);
            }
            if (msgType != null && "JMS_BYTE_MESSAGE".equals(msgType) || contentType.indexOf("multipart/related") > -1) {
                BytesMessage bytesMsg = message = session.createBytesMessage();
                bytesMsg.writeBytes(baos.toByteArray());
            } else {
                message = session.createTextMessage();
                TextMessage txtMsg = (TextMessage)message;
                txtMsg.setText(new String(baos.toByteArray()));
            }
            message.setStringProperty("Content-Type", contentType);
        } else if ("JMS_BYTE_MESSAGE".equals(jmsPayloadType)) {
            Object dh;
            BytesMessage bytesMsg = message = session.createBytesMessage();
            OMElement wrapper = msgContext.getEnvelope().getBody().getFirstChildWithName(BaseConstants.DEFAULT_BINARY_WRAPPER);
            OMNode omNode = wrapper.getFirstOMChild();
            if (omNode != null && omNode instanceof OMText && (dh = ((OMText)omNode).getDataHandler()) != null && dh instanceof DataHandler) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    ((DataHandler)dh).writeTo((OutputStream)baos);
                }
                catch (IOException e) {
                    this.handleException("Error serializing binary content of element : " + BaseConstants.DEFAULT_BINARY_WRAPPER, e);
                }
                bytesMsg.writeBytes(baos.toByteArray());
            }
        } else if ("JMS_TEXT_MESSAGE".equals(jmsPayloadType)) {
            message = session.createTextMessage();
            TextMessage txtMsg = (TextMessage)message;
            txtMsg.setText(msgContext.getEnvelope().getBody().getFirstChildWithName(BaseConstants.DEFAULT_TEXT_WRAPPER).getText());
        }
        String correlationId = this.getProperty(msgContext, "JMS_COORELATION_ID");
        if (correlationId == null && msgContext.getRelatesTo() != null) {
            correlationId = msgContext.getRelatesTo().getValue();
        }
        if (correlationId != null) {
            message.setJMSCorrelationID(correlationId);
        }
        if (msgContext.isServerSide()) {
            this.setProperty((Message)message, msgContext, "SOAPAction");
        } else {
            String action = msgContext.getOptions().getAction();
            if (action != null) {
                message.setStringProperty("SOAPAction", action);
            }
        }
        JMSUtils.setTransportHeaders(msgContext, (Message)message);
        return message;
    }

    private String guessMessageType(MessageContext msgContext) {
        OMElement firstChild = msgContext.getEnvelope().getBody().getFirstElement();
        if (firstChild != null) {
            if (BaseConstants.DEFAULT_BINARY_WRAPPER.equals(firstChild.getQName())) {
                return "JMS_BYTE_MESSAGE";
            }
            if (BaseConstants.DEFAULT_TEXT_WRAPPER.equals(firstChild.getQName())) {
                return "JMS_TEXT_MESSAGE";
            }
        }
        return null;
    }

    private void processSyncResponse(MessageContext outMsgCtx, Message message) throws AxisFault {
        MessageContext responseMsgCtx = this.createResponseMessageContext(outMsgCtx);
        JMSUtils.loadTransportHeaders(message, responseMsgCtx);
        responseMsgCtx.setServerSide(false);
        String contentType = JMSUtils.getInstace().getProperty(message, "Content-Type");
        JMSUtils.getInstace().setSOAPEnvelope(message, responseMsgCtx, contentType);
        responseMsgCtx.setServerSide(true);
        this.handleIncomingMessage(responseMsgCtx, JMSUtils.getTransportHeaders(message), JMSUtils.getInstace().getProperty(message, "SOAPAction"), contentType);
    }

    private void setProperty(Message message, MessageContext msgCtx, String key) {
        String value = this.getProperty(msgCtx, key);
        if (value != null) {
            try {
                message.setStringProperty(key, value);
            }
            catch (JMSException e) {
                this.log.warn((Object)("Couldn't set message property : " + key + " = " + value), (Throwable)e);
            }
        }
    }

    private String getProperty(MessageContext mc, String key) {
        return (String)mc.getProperty(key);
    }

    private void loadConnectionFactoryDefinitions(TransportOutDescription transportOut) {
        for (Parameter conFacParams : transportOut.getParameters()) {
            JMSConnectionFactory jmsConFactory = new JMSConnectionFactory(conFacParams.getName(), this.cfgCtx);
            JMSUtils.setConnectionFactoryParameters(conFacParams, jmsConFactory);
            try {
                jmsConFactory.connectAndListen();
            }
            catch (NamingException e) {
                this.log.warn((Object)("Error looking up JMS connection factory : " + jmsConFactory.getName()), (Throwable)e);
            }
            catch (JMSException e) {
                this.log.warn((Object)("Error connecting to JMS connection factory : " + jmsConFactory.getName()), (Throwable)e);
            }
            this.connectionFactories.put(jmsConFactory.getName(), jmsConFactory);
        }
    }
}

