/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.jms;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.base.BaseUtils;
import org.apache.synapse.transport.jms.AxisJMSException;
import org.apache.synapse.transport.jms.JMSMessageReceiver;
import org.apache.synapse.transport.jms.JMSOutTransportInfo;
import org.apache.synapse.transport.jms.JMSUtils;

public class JMSConnectionFactory
implements ExceptionListener {
    private static final Log log = LogFactory.getLog(JMSConnectionFactory.class);
    private String name = null;
    private String connFactoryJNDIName = null;
    private Map serviceJNDINameMapping = null;
    private Map destinationTypeMapping = null;
    private Map serviceDestinationNameMapping = null;
    private Map jmsSessions = null;
    private Hashtable jndiProperties = null;
    private Context context = null;
    private ConnectionFactory conFactory = null;
    private String connectionFactoryType = null;
    private Connection connection = null;
    private JMSMessageReceiver jmsMessageReceiver = null;
    private ConfigurationContext cfgCtx = null;
    private long reconnectTimeout = 30000L;

    public JMSConnectionFactory(String name, ConfigurationContext cfgCtx) {
        this.name = name;
        this.cfgCtx = cfgCtx;
        this.serviceJNDINameMapping = new HashMap();
        this.destinationTypeMapping = new HashMap();
        this.serviceDestinationNameMapping = new HashMap();
        this.jndiProperties = new Hashtable();
        this.jmsSessions = new HashMap();
    }

    public void addDestination(String destinationJNDIName, String destinationType, String serviceName) {
        String destinationName = this.getPhysicalDestinationName(destinationJNDIName);
        if (destinationName == null) {
            log.warn((Object)("JMS Destination with JNDI name : " + destinationJNDIName + " does not exist"));
            try {
                log.info((Object)("Creating a JMS Queue with the JNDI name : " + destinationJNDIName + " using the connection factory definition named : " + this.name));
                JMSUtils.createDestination(this.conFactory, destinationJNDIName, destinationType);
                destinationName = this.getPhysicalDestinationName(destinationJNDIName);
            }
            catch (JMSException e) {
                log.error((Object)("Unable to create Destination with JNDI name : " + destinationJNDIName), (Throwable)e);
                BaseUtils.markServiceAsFaulty(serviceName, "Error creating JMS destination : " + destinationJNDIName, this.cfgCtx.getAxisConfiguration());
                return;
            }
        }
        this.serviceJNDINameMapping.put(destinationJNDIName, serviceName);
        this.destinationTypeMapping.put(destinationJNDIName, destinationType);
        this.serviceDestinationNameMapping.put(destinationName, serviceName);
        log.info((Object)("Mapped JNDI name : " + destinationJNDIName + " and JMS Destination name : " + destinationName + " against service : " + serviceName));
    }

    public void removeDestination(String jndiDestinationName) {
        String providerSpecificDestination = this.getPhysicalDestinationName(jndiDestinationName);
        this.stoplisteningOnDestination(jndiDestinationName);
        this.serviceJNDINameMapping.remove(jndiDestinationName);
        if (providerSpecificDestination != null) {
            this.serviceDestinationNameMapping.remove(providerSpecificDestination);
        }
    }

    public synchronized void connectAndListen() throws JMSException, NamingException {
        if (this.connection != null) {
            log.info((Object)("Re-initializing the JMS connection factory : " + this.name));
            Iterator sessionIter = this.jmsSessions.values().iterator();
            while (sessionIter.hasNext()) {
                try {
                    ((Session)sessionIter.next()).close();
                }
                catch (JMSException ignore) {}
            }
            try {
                this.connection.stop();
            }
            catch (JMSException ignore) {}
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Initializing the JMS connection factory : " + this.name));
        }
        this.context = new InitialContext(this.jndiProperties);
        this.conFactory = (ConnectionFactory)this.context.lookup(this.connFactoryJNDIName);
        log.info((Object)("Connected to the JMS connection factory : " + this.connFactoryJNDIName));
        try {
            Object conFac = null;
            QueueConnectionFactory qConFac = null;
            TopicConnectionFactory tConFac = null;
            if ("queue".equals(this.getConnectionFactoryType())) {
                qConFac = (QueueConnectionFactory)this.conFactory;
            } else if ("topic".equals(this.getConnectionFactoryType())) {
                tConFac = (TopicConnectionFactory)this.conFactory;
            } else {
                this.handleException("Unable to determine type of Connection Factory - i.e. Queue/Topic", null);
            }
            String user = (String)this.jndiProperties.get("java.naming.security.principal");
            String pass = (String)this.jndiProperties.get("java.naming.security.credentials");
            if (user != null && pass != null) {
                if (qConFac != null) {
                    this.connection = qConFac.createQueueConnection(user, pass);
                } else if (tConFac != null) {
                    this.connection = tConFac.createTopicConnection(user, pass);
                }
            } else if (qConFac != null) {
                this.connection = qConFac.createQueueConnection();
            } else if (tConFac != null) {
                this.connection = tConFac.createTopicConnection();
            }
            this.connection.setExceptionListener((ExceptionListener)this);
        }
        catch (JMSException e) {
            this.handleException("Error connecting to Connection Factory : " + this.connFactoryJNDIName, (Exception)((Object)e));
        }
        for (String destJNDIName : this.serviceJNDINameMapping.keySet()) {
            String destinationType = (String)this.destinationTypeMapping.get(destJNDIName);
            this.startListeningOnDestination(destJNDIName, destinationType);
        }
        this.connection.start();
        log.info((Object)("Connection factory : " + this.name + " initialized..."));
    }

    public Session getSessionForDestination(String destinationJNDIname) {
        Object session = (Session)this.jmsSessions.get(destinationJNDIname);
        if (session == null) {
            try {
                Destination dest = this.getPhysicalDestination(destinationJNDIname);
                session = dest instanceof Topic ? ((TopicConnection)this.connection).createTopicSession(false, 1) : ((QueueConnection)this.connection).createQueueSession(false, 1);
                this.jmsSessions.put(destinationJNDIname, session);
            }
            catch (JMSException e) {
                this.handleException("Unable to create a session using connection factory : " + this.name, (Exception)((Object)e));
            }
        }
        return session;
    }

    public void startListeningOnDestination(String destinationJNDIname, String destinationType) {
        Session session = (Session)this.jmsSessions.get(destinationJNDIname);
        if (session != null) {
            try {
                session.close();
            }
            catch (JMSException ignore) {
                // empty catch block
            }
        }
        try {
            session = JMSUtils.createSession(this.connection, false, 1, destinationType);
            Destination destination = null;
            try {
                destination = (Destination)this.context.lookup(destinationJNDIname);
            }
            catch (NameNotFoundException e) {
                log.warn((Object)("Cannot find destination : " + destinationJNDIname + ". Creating a Queue"));
                destination = JMSUtils.createDestination(session, destinationJNDIname, destinationType);
            }
            MessageConsumer consumer = JMSUtils.createConsumer(session, destination);
            consumer.setMessageListener((MessageListener)this.jmsMessageReceiver);
            this.jmsSessions.put(destinationJNDIname, session);
        }
        catch (Exception e) {
            if (session != null) {
                try {
                    session.close();
                }
                catch (JMSException ignore) {
                    // empty catch block
                }
            }
            BaseUtils.markServiceAsFaulty((String)this.serviceJNDINameMapping.get(destinationJNDIname), "Error looking up JMS destination : " + destinationJNDIname, this.cfgCtx.getAxisConfiguration());
        }
    }

    private void stoplisteningOnDestination(String destinationJNDIname) {
        Session session = (Session)this.jmsSessions.get(destinationJNDIname);
        if (session != null) {
            try {
                session.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    public void stop() {
        if (this.connection != null) {
            Iterator sessionIter = this.jmsSessions.values().iterator();
            while (sessionIter.hasNext()) {
                try {
                    ((Session)sessionIter.next()).close();
                }
                catch (JMSException ignore) {}
            }
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                log.warn((Object)("Error shutting down connection factory : " + this.name), (Throwable)e);
            }
        }
    }

    private String getPhysicalDestinationName(String destinationJndi) {
        Destination destination = this.getPhysicalDestination(destinationJndi);
        if (destination != null) {
            try {
                if (destination instanceof Queue) {
                    return ((Queue)destination).getQueueName();
                }
                if (destination instanceof Topic) {
                    return ((Topic)destination).getTopicName();
                }
            }
            catch (JMSException e) {
                log.warn((Object)("Error reading Destination name for JNDI destination : " + destinationJndi), (Throwable)e);
            }
        }
        return null;
    }

    private Destination getPhysicalDestination(String destinationJndi) {
        Destination destination;
        block6: {
            destination = null;
            try {
                destination = (Destination)this.context.lookup(destinationJndi);
            }
            catch (NamingException e) {
                String provider = (String)this.jndiProperties.get("java.naming.factory.initial");
                if (provider.indexOf("activemq") == -1) break block6;
                try {
                    destination = (Destination)this.context.lookup("dynamicQueues/" + destinationJndi);
                }
                catch (NamingException ne) {
                    try {
                        destination = (Destination)this.context.lookup("dynamicTopics/" + destinationJndi);
                    }
                    catch (NamingException e1) {
                        log.warn((Object)("Error looking up destination for JNDI name : " + destinationJndi));
                    }
                }
            }
        }
        return destination;
    }

    public EndpointReference getEPRForDestination(String jndiDestination) {
        StringBuffer sb = new StringBuffer();
        sb.append("jms:/").append(jndiDestination);
        sb.append("?").append("transport.jms.ConnectionFactoryJNDIName").append("=").append(this.getConnFactoryJNDIName());
        for (String key : this.getJndiProperties().keySet()) {
            String value = (String)this.getJndiProperties().get(key);
            sb.append("&").append(key).append("=").append(value);
        }
        return new EndpointReference(sb.toString());
    }

    public boolean equals(Object o) {
        JMSOutTransportInfo trpInfo;
        Hashtable trpProps;
        return o instanceof JMSOutTransportInfo && this.equals((trpProps = (trpInfo = (JMSOutTransportInfo)o).getProperties()).get("transport.jms.ConnectionFactoryJNDIName"), this.jndiProperties.get("transport.jms.ConnectionFactoryJNDIName")) && this.equals(trpProps.get("java.naming.factory.initial"), this.jndiProperties.get("java.naming.factory.initial")) && this.equals(trpProps.get("java.naming.provider.url"), this.jndiProperties.get("java.naming.provider.url")) && this.equals(trpProps.get("java.naming.security.principal"), this.jndiProperties.get("java.naming.security.principal")) && this.equals(trpProps.get("java.naming.security.credentials"), this.jndiProperties.get("java.naming.security.credentials"));
    }

    private boolean equals(Object s1, Object s2) {
        if (s1 == s2) {
            return true;
        }
        return s1 != null && s1.equals(s2);
    }

    public String getServiceNameForDestinationName(String jmsDestinationName) {
        return (String)this.serviceDestinationNameMapping.get(jmsDestinationName);
    }

    public String getServiceNameForDestination(Destination dest, String jmsDestinationName) {
        String provider;
        String serviceName = (String)this.serviceDestinationNameMapping.get(jmsDestinationName);
        if (serviceName == null && (provider = (String)this.getJndiProperties().get("java.naming.factory.initial")).indexOf("activemq") != -1) {
            serviceName = this.getServiceNameForJNDIName((dest instanceof Queue ? "dynamicQueues/" : "dynamicTopics/") + jmsDestinationName);
        }
        return serviceName;
    }

    public String getServiceNameForJNDIName(String jndiDestinationName) {
        return (String)this.serviceJNDINameMapping.get(jndiDestinationName);
    }

    public void setConnFactoryJNDIName(String connFactoryJNDIName) {
        this.connFactoryJNDIName = connFactoryJNDIName;
    }

    public Destination getDestination(String destinationJNDIName) {
        try {
            return (Destination)this.context.lookup(destinationJNDIName);
        }
        catch (NamingException namingException) {
            return null;
        }
    }

    public void addJNDIContextProperty(String key, String value) {
        this.jndiProperties.put(key, value);
    }

    public String getName() {
        return this.name;
    }

    public String getConnFactoryJNDIName() {
        return this.connFactoryJNDIName;
    }

    public ConnectionFactory getConFactory() {
        return this.conFactory;
    }

    public Hashtable getJndiProperties() {
        return this.jndiProperties;
    }

    public JMSMessageReceiver getJmsMessageReceiver() {
        return this.jmsMessageReceiver;
    }

    public Context getContext() {
        return this.context;
    }

    public void setJmsMessageReceiver(JMSMessageReceiver jmsMessageReceiver) {
        this.jmsMessageReceiver = jmsMessageReceiver;
    }

    private void handleException(String msg, Exception e) throws AxisJMSException {
        log.error((Object)msg, (Throwable)e);
        throw new AxisJMSException(msg, e);
    }

    public String getConnectionFactoryType() {
        return this.connectionFactoryType;
    }

    public void setConnectionFactoryType(String connectionFactoryType) {
        this.connectionFactoryType = connectionFactoryType;
    }

    public long getReconnectTimeout() {
        return this.reconnectTimeout;
    }

    public void setReconnectTimeout(long reconnectTimeout) {
        this.reconnectTimeout = reconnectTimeout;
    }

    public void onException(JMSException e) {
        log.error((Object)("JMS connection factory " + this.name + " encountered an error"), (Throwable)e);
        boolean wasError = true;
        while (wasError) {
            try {
                this.connectAndListen();
                wasError = false;
            }
            catch (Exception e1) {
                log.warn((Object)("JMS reconnection attempt failed for connection factory : " + this.name), (Throwable)e);
            }
            if (!wasError) continue;
            try {
                log.info((Object)("Attempting reconnection for connection factory " + this.name + " in " + this.getReconnectTimeout() / 1000L + " seconds"));
                Thread.sleep(this.getReconnectTimeout());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void pause() {
        try {
            this.connection.stop();
        }
        catch (JMSException e) {
            this.handleException("Error pausing JMS connection for factory : " + this.name, (Exception)((Object)e));
        }
    }

    public void resume() {
        try {
            this.connection.start();
        }
        catch (JMSException e) {
            this.handleException("Error resuming JMS connection for factory : " + this.name, (Exception)((Object)e));
        }
    }
}

