/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.fix;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import quickfix.Field;
import quickfix.FieldNotFound;
import quickfix.Message;
import quickfix.SessionID;
import quickfix.SocketAcceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FIXUtils {
    private static final Log log = LogFactory.getLog(FIXUtils.class);
    private static FIXUtils _instance = new FIXUtils();

    public static FIXUtils getInstance() {
        return _instance;
    }

    public void setSOAPEnvelope(Message message, int counter, String sessionID, MessageContext msgCtx) throws AxisFault {
        String binaryCID;
        OMElement binaryData;
        String contentID;
        DataHandler dataHandler;
        ByteArrayDataSource dataSource;
        Object value;
        OMElement msgField;
        Field field;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating SOAP envelope for FIX message...");
        }
        SOAP11Factory soapFactory = new SOAP11Factory();
        OMElement msg = soapFactory.createOMElement("message", null);
        msg.addAttribute(soapFactory.createOMAttribute("inSession", null, sessionID));
        msg.addAttribute(soapFactory.createOMAttribute("counter", null, String.valueOf(counter)));
        OMElement header = soapFactory.createOMElement("header", null);
        OMElement body = soapFactory.createOMElement("body", null);
        OMElement trailer = soapFactory.createOMElement("trailer", null);
        Iterator iter = message.getHeader().iterator();
        if (iter != null) {
            while (iter.hasNext()) {
                field = (Field)iter.next();
                msgField = soapFactory.createOMElement("field", null);
                msgField.addAttribute(soapFactory.createOMAttribute("id", null, String.valueOf(field.getTag())));
                value = field.getObject();
                if (value instanceof byte[]) {
                    dataSource = new ByteArrayDataSource((byte[])value);
                    dataHandler = new DataHandler((DataSource)dataSource);
                    contentID = msgCtx.addAttachment(dataHandler);
                    binaryData = soapFactory.createOMElement("rawdata", null);
                    binaryCID = "cid:" + contentID;
                    binaryData.addAttribute("href", binaryCID, null);
                    msgField.addChild((OMNode)binaryData);
                } else {
                    soapFactory.createOMText((OMContainer)msgField, value.toString(), 12);
                }
                header.addChild((OMNode)msgField);
            }
        }
        if ((iter = message.iterator()) != null) {
            while (iter.hasNext()) {
                field = (Field)iter.next();
                msgField = soapFactory.createOMElement("field", null);
                msgField.addAttribute(soapFactory.createOMAttribute("id", null, String.valueOf(field.getTag())));
                value = field.getObject();
                if (value instanceof byte[]) {
                    dataSource = new ByteArrayDataSource((byte[])value);
                    dataHandler = new DataHandler((DataSource)dataSource);
                    contentID = msgCtx.addAttachment(dataHandler);
                    binaryData = soapFactory.createOMElement("rawdata", null);
                    binaryCID = "cid:" + contentID;
                    binaryData.addAttribute("href", binaryCID, null);
                    msgField.addChild((OMNode)binaryData);
                } else {
                    soapFactory.createOMText((OMContainer)msgField, value.toString(), 12);
                }
                body.addChild((OMNode)msgField);
            }
        }
        if ((iter = message.getTrailer().iterator()) != null) {
            while (iter.hasNext()) {
                field = (Field)iter.next();
                msgField = soapFactory.createOMElement("field", null);
                msgField.addAttribute(soapFactory.createOMAttribute("id", null, String.valueOf(field.getTag())));
                value = field.getObject();
                if (value instanceof byte[]) {
                    dataSource = new ByteArrayDataSource((byte[])value);
                    dataHandler = new DataHandler((DataSource)dataSource);
                    contentID = msgCtx.addAttachment(dataHandler);
                    binaryData = soapFactory.createOMElement("rawdata", null);
                    binaryCID = "cid:" + contentID;
                    binaryData.addAttribute("href", binaryCID, null);
                    msgField.addChild((OMNode)binaryData);
                } else {
                    soapFactory.createOMText((OMContainer)msgField, value.toString(), 12);
                }
                trailer.addChild((OMNode)msgField);
            }
        }
        msg.addChild((OMNode)header);
        msg.addChild((OMNode)body);
        msg.addChild((OMNode)trailer);
        SOAPEnvelope envelope = soapFactory.getDefaultEnvelope();
        envelope.getBody().addChild((OMNode)msg);
        msgCtx.setEnvelope(envelope);
    }

    public Message createFIXMessage(MessageContext msgCtx) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Extracting FIX message from the message context (Message ID: " + msgCtx.getMessageID() + ")"));
        }
        Message message = new Message();
        SOAPBody soapBody = msgCtx.getEnvelope().getBody();
        OMElement messageNode = soapBody.getFirstChildWithName(new QName("message"));
        Iterator messageElements = messageNode.getChildElements();
        while (messageElements.hasNext()) {
            ByteArrayOutputStream outputStream;
            DataHandler binaryDataHandler;
            String href;
            OMElement child;
            String value;
            String tag;
            OMElement node = (OMElement)messageElements.next();
            if (node.getQName().getLocalPart().equals("header")) {
                Iterator headerElements = node.getChildElements();
                while (headerElements.hasNext()) {
                    OMElement headerNode = (OMElement)headerElements.next();
                    tag = headerNode.getAttributeValue(new QName("id"));
                    value = null;
                    child = headerNode.getFirstElement();
                    if (child != null) {
                        href = headerNode.getFirstElement().getAttributeValue(new QName("href"));
                        if (href != null) {
                            binaryDataHandler = msgCtx.getAttachment(href.substring(4));
                            outputStream = new ByteArrayOutputStream();
                            binaryDataHandler.writeTo((OutputStream)outputStream);
                            value = new String(outputStream.toByteArray());
                        }
                    } else {
                        value = headerNode.getText();
                    }
                    if (value == null) continue;
                    message.getHeader().setString(Integer.parseInt(tag), value);
                }
                continue;
            }
            if (node.getQName().getLocalPart().equals("body")) {
                Iterator bodyElements = node.getChildElements();
                while (bodyElements.hasNext()) {
                    OMElement bodyNode = (OMElement)bodyElements.next();
                    tag = bodyNode.getAttributeValue(new QName("id"));
                    value = null;
                    child = bodyNode.getFirstElement();
                    if (child != null) {
                        href = bodyNode.getFirstElement().getAttributeValue(new QName("href"));
                        if (href != null) {
                            binaryDataHandler = msgCtx.getAttachment(href.substring(4));
                            outputStream = new ByteArrayOutputStream();
                            binaryDataHandler.writeTo((OutputStream)outputStream);
                            value = new String(outputStream.toByteArray());
                        }
                    } else {
                        value = bodyNode.getText();
                    }
                    if (value == null) continue;
                    message.setString(Integer.parseInt(tag), value);
                }
                continue;
            }
            if (!node.getQName().getLocalPart().equals("trailer")) continue;
            Iterator trailerElements = node.getChildElements();
            while (trailerElements.hasNext()) {
                OMElement trailerNode = (OMElement)trailerElements.next();
                tag = trailerNode.getAttributeValue(new QName("id"));
                value = null;
                child = trailerNode.getFirstElement();
                if (child != null) {
                    href = trailerNode.getFirstElement().getAttributeValue(new QName("href"));
                    if (href != null) {
                        binaryDataHandler = msgCtx.getAttachment(href.substring(4));
                        outputStream = new ByteArrayOutputStream();
                        binaryDataHandler.writeTo((OutputStream)outputStream);
                        value = new String(outputStream.toByteArray());
                    }
                } else {
                    value = trailerNode.getText();
                }
                if (value == null) continue;
                message.getTrailer().setString(Integer.parseInt(tag), value);
            }
        }
        return message;
    }

    public static String[] generateEPRs(SocketAcceptor acceptor, String serviceName, String ip) {
        Map socketAddresses = acceptor.getAcceptorAddresses();
        ArrayList sessions = acceptor.getSessions();
        String[] EPRList = new String[sessions.size()];
        int i = 0;
        while (i < sessions.size()) {
            String targetLocationID;
            String senderLocationID;
            String targetSubID;
            String senderSubID;
            SessionID sessionID = (SessionID)sessions.get(i);
            InetSocketAddress socketAddress = (InetSocketAddress)socketAddresses.get(sessionID);
            EPRList[i] = "fix://" + ip + ":" + socketAddress.getPort() + "?" + "BeginString" + "=" + sessionID.getBeginString() + "&" + "SenderCompID" + "=" + sessionID.getTargetCompID() + "&" + "TargetCompID" + "=" + sessionID.getSenderCompID();
            String sessionQualifier = sessionID.getSessionQualifier();
            if (sessionQualifier != null && !sessionQualifier.equals("")) {
                int n = i;
                EPRList[n] = EPRList[n] + "&SessionQualifier=" + sessionQualifier;
            }
            if ((senderSubID = sessionID.getSenderSubID()) != null && !senderSubID.equals("")) {
                int n = i;
                EPRList[n] = EPRList[n] + "&SenderSubID=" + senderSubID;
            }
            if ((targetSubID = sessionID.getTargetSubID()) != null && !targetSubID.equals("")) {
                int n = i;
                EPRList[n] = EPRList[n] + "&TargetSubID=" + targetSubID;
            }
            if ((senderLocationID = sessionID.getSenderLocationID()) != null && !senderLocationID.equals("")) {
                int n = i;
                EPRList[n] = EPRList[n] + "&SenderLocationID=" + senderLocationID;
            }
            if ((targetLocationID = sessionID.getTargetLocationID()) != null && !targetLocationID.equals("")) {
                int n = i;
                EPRList[n] = EPRList[n] + "&TargetLocationID=" + targetLocationID;
            }
            int n = i++;
            EPRList[n] = EPRList[n] + "&Service=" + serviceName;
        }
        return EPRList;
    }

    public static Hashtable getProperties(String url) {
        Hashtable<String, String> h = new Hashtable<String, String>();
        int propPos = url.indexOf("?");
        if (propPos != -1) {
            StringTokenizer st = new StringTokenizer(url.substring(propPos + 1), "&");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int sep = token.indexOf("=");
                if (sep == -1) continue;
                h.put(token.substring(0, sep), token.substring(sep + 1));
            }
        }
        return h;
    }

    public static Map<String, String> getMessageForwardingParameters(Message message) {
        HashMap<String, String> map = new HashMap<String, String>();
        String value = FIXUtils.getHeaderFieldValue(message, 8);
        map.put("BeginString", value);
        value = FIXUtils.getHeaderFieldValue(message, 49);
        map.put("SenderCompID", value);
        value = FIXUtils.getHeaderFieldValue(message, 50);
        map.put("SenderSubID", value);
        value = FIXUtils.getHeaderFieldValue(message, 142);
        map.put("SenderLocationID", value);
        value = FIXUtils.getHeaderFieldValue(message, 56);
        map.put("TargetCompID", value);
        value = FIXUtils.getHeaderFieldValue(message, 128);
        map.put("DeliverToCompID", value);
        value = FIXUtils.getHeaderFieldValue(message, 129);
        map.put("DeliverToSubID", value);
        value = FIXUtils.getHeaderFieldValue(message, 145);
        map.put("DeliverToLocationID", value);
        value = FIXUtils.getHeaderFieldValue(message, 115);
        map.put("OnBehalfOfCompID", value);
        value = FIXUtils.getHeaderFieldValue(message, 116);
        map.put("OnBehalfOfSubID", value);
        value = FIXUtils.getHeaderFieldValue(message, 144);
        map.put("OnBehalfOfLocationID", value);
        return map;
    }

    private static String getHeaderFieldValue(Message message, int tag) {
        try {
            return message.getHeader().getString(tag);
        }
        catch (FieldNotFound fieldNotFound) {
            return null;
        }
    }

    public static String getServiceName(MessageContext msgCtx) throws AxisFault {
        String serviceName;
        String serviceName2;
        Object serviceParam = msgCtx.getProperty("transport.fix.ServiceName");
        if (serviceParam != null && (serviceName2 = serviceParam.toString()) != null && !serviceName2.equals("")) {
            return serviceName2;
        }
        Map trpHeaders = (Map)msgCtx.getProperty("TRANSPORT_HEADERS");
        if (trpHeaders != null && (serviceName = (String)trpHeaders.get("service")) != null) {
            return serviceName;
        }
        throw new AxisFault("Unable to find a valid service for the message");
    }

    public static String getFixApplication(MessageContext msgCtx) {
        Map trpHeaders = (Map)msgCtx.getProperty("TRANSPORT_HEADERS");
        String fixApplication = null;
        if (trpHeaders != null) {
            fixApplication = (String)trpHeaders.get("fixApplication");
        }
        return fixApplication;
    }

    public static Map<String, String> getTransportHeaders(String serviceName, String fixApplication) {
        HashMap<String, String> trpHeaders = new HashMap<String, String>();
        trpHeaders.put("service", serviceName);
        trpHeaders.put("fixApplication", fixApplication);
        return trpHeaders;
    }

    public static String[] getSocketAddressElements(String fixEPR) throws AxisFault {
        String address;
        String[] socketAddressElemets;
        int propPos = fixEPR.indexOf("?");
        if (propPos != -1 && fixEPR.startsWith("fix://") && (socketAddressElemets = (address = fixEPR.substring("fix://".length(), propPos)).split(":")).length == 2) {
            return socketAddressElemets;
        }
        throw new AxisFault("Malformed FIX EPR: " + fixEPR);
    }

    public static int getSequenceNumber(MessageContext msgCtx) {
        SOAPBody body = msgCtx.getEnvelope().getBody();
        OMElement messageNode = body.getFirstChildWithName(new QName("message"));
        String value = messageNode.getAttributeValue(new QName("counter"));
        if (value != null) {
            return Integer.parseInt(value);
        }
        return -1;
    }

    public static String getSourceSession(MessageContext msgCtx) {
        SOAPBody body = msgCtx.getEnvelope().getBody();
        OMElement messageNode = body.getFirstChildWithName(new QName("message"));
        return messageNode.getAttributeValue(new QName("inSession"));
    }
}

