/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.fix;

import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportInDescription;
import org.apache.synapse.transport.base.AbstractTransportListener;
import org.apache.synapse.transport.fix.FIXApplicationFactory;
import org.apache.synapse.transport.fix.FIXSessionFactory;
import org.apache.synapse.transport.fix.FIXTransportSender;

public class FIXTransportListener
extends AbstractTransportListener {
    private FIXSessionFactory fixSessionFactory;

    public void init(ConfigurationContext cfgCtx, TransportInDescription trpInDesc) throws AxisFault {
        this.setTransportName("fix");
        super.init(cfgCtx, trpInDesc);
        this.fixSessionFactory = new FIXSessionFactory(new FIXApplicationFactory(this.cfgCtx, this.workerPool));
        FIXTransportSender sender = (FIXTransportSender)cfgCtx.getAxisConfiguration().getTransportOut("fix").getSender();
        sender.setSessionFactory(this.fixSessionFactory);
        this.log.info((Object)"FIX transport listener initialized...");
    }

    protected void startListeningForService(AxisService service) {
        if (service.getName().startsWith("__")) {
            return;
        }
        this.fixSessionFactory.createFIXAcceptor(service);
    }

    protected void stopListeningForService(AxisService service) {
        this.fixSessionFactory.disposeFIXAcceptor(service);
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        String[] serviceEPRStrings = this.fixSessionFactory.getServiceEPRs(serviceName, ip);
        if (serviceEPRStrings != null) {
            EndpointReference[] serviceEPRs = new EndpointReference[serviceEPRStrings.length];
            for (int i = 0; i < serviceEPRStrings.length; ++i) {
                serviceEPRs[i] = new EndpointReference(serviceEPRStrings[i]);
            }
            return serviceEPRs;
        }
        throw new AxisFault("Unable to get EPRs for the service " + serviceName);
    }
}

