/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.fix;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.synapse.transport.fix.FIXApplicationFactory;
import org.apache.synapse.transport.fix.FIXIncomingMessageHandler;
import org.apache.synapse.transport.fix.FIXUtils;
import quickfix.Acceptor;
import quickfix.Application;
import quickfix.ConfigError;
import quickfix.DefaultMessageFactory;
import quickfix.FileLogFactory;
import quickfix.FileStoreFactory;
import quickfix.Initiator;
import quickfix.JdbcLogFactory;
import quickfix.JdbcStoreFactory;
import quickfix.LogFactory;
import quickfix.MemoryStoreFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.ScreenLogFactory;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.SleepycatStoreFactory;
import quickfix.SocketAcceptor;
import quickfix.SocketInitiator;

public class FIXSessionFactory {
    private Map<String, Acceptor> acceptorStore;
    private Map<String, Initiator> initiatorStore;
    private Map<String, Application> applicationStore;
    private FIXApplicationFactory applicationFactory;
    private Log log;

    public FIXSessionFactory(FIXApplicationFactory applicationFactory) {
        this.applicationFactory = applicationFactory;
        this.log = org.apache.commons.logging.LogFactory.getLog(this.getClass());
        this.acceptorStore = new HashMap<String, Acceptor>();
        this.initiatorStore = new HashMap<String, Initiator>();
        this.applicationStore = new HashMap<String, Application>();
    }

    public void createFIXAcceptor(AxisService service) {
        InputStream fixConfigStream = this.getFIXConfigAsStream(service, true);
        if (fixConfigStream != null) {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Initializing a new FIX session for the service " + service.getName()));
                }
                SessionSettings settings = new SessionSettings(fixConfigStream);
                MessageStoreFactory storeFactory = this.getMessageStoreFactory(service, settings, true);
                DefaultMessageFactory messageFactory = new DefaultMessageFactory();
                LogFactory logFactory = this.getLogFactory(service, settings, true);
                Application messageHandler = this.applicationFactory.getFIXApplication(service, true);
                SocketAcceptor acceptor = new SocketAcceptor(messageHandler, storeFactory, settings, logFactory, (MessageFactory)messageFactory);
                this.acceptorStore.put(service.getName(), (Acceptor)acceptor);
                acceptor.start();
                return;
            }
            catch (ConfigError e) {
                this.log.error((Object)("Error in the specified FIX configuration. Unable to initialize a FIX session for the service " + service.getName()), (Throwable)e);
            }
        }
        this.log.error((Object)("Unable to initialize a FIX session for the service " + service.getName()));
    }

    public void createFIXInitiator(String fixEPR, AxisService service, SessionID sessionID) throws AxisFault {
        SessionSettings settings;
        InputStream fixConfigStream;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Initializing a new FIX initiator for the service " + service.getName()));
        }
        if ((fixConfigStream = this.getFIXConfigAsStream(service, false)) == null) {
            settings = new SessionSettings();
            settings.setLong(sessionID, "HeartBtInt", 30L);
            settings.setString(sessionID, "StartTime", "00:00:00");
            settings.setString(sessionID, "EndTime", "00:00:00");
        } else {
            try {
                settings = new SessionSettings(fixConfigStream);
            }
            catch (ConfigError e) {
                throw new AxisFault("Error in the specified FIX configuration. Unable to initialize a FIX session for the service " + service.getName(), (Throwable)e);
            }
        }
        Hashtable properties = FIXUtils.getProperties(fixEPR);
        for (String currentKey : properties.keySet()) {
            settings.setString(sessionID, currentKey, (String)properties.get(currentKey));
        }
        String[] socketAddressElements = FIXUtils.getSocketAddressElements(fixEPR);
        settings.setString(sessionID, "ConnectionType", "initiator");
        settings.setString(sessionID, "SocketConnectHost", socketAddressElements[0]);
        settings.setString(sessionID, "SocketConnectPort", socketAddressElements[1]);
        LogFactory logFactory = this.getLogFactory(service, settings, false);
        MessageStoreFactory storeFactory = this.getMessageStoreFactory(service, settings, false);
        DefaultMessageFactory messageFactory = new DefaultMessageFactory();
        Application messageHandler = this.applicationFactory.getFIXApplication(service, false);
        try {
            SocketInitiator initiator = new SocketInitiator(messageHandler, storeFactory, settings, logFactory, (MessageFactory)messageFactory);
            this.initiatorStore.put(fixEPR, (Initiator)initiator);
            this.applicationStore.put(fixEPR, messageHandler);
            initiator.start();
            FIXIncomingMessageHandler fixMessageHandler = (FIXIncomingMessageHandler)messageHandler;
            this.log.info((Object)"Waiting for logon procedure to complete...");
            fixMessageHandler.acquire();
        }
        catch (ConfigError e) {
            throw new AxisFault("Error in the specified FIX configuration. Unable to initialize a FIX initiator.", (Throwable)e);
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
    }

    public void disposeFIXAcceptor(AxisService service) {
        Acceptor acceptor;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Stopping the FIX acceptor for the service " + service.getName()));
        }
        if ((acceptor = this.acceptorStore.get(service.getName())) != null) {
            acceptor.stop();
            this.log.info((Object)("FIX session for service " + service.getName() + " terminated..."));
            this.acceptorStore.remove(service.getName());
        }
    }

    public String[] getServiceEPRs(String serviceName, String ip) {
        SocketAcceptor acceptor;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Getting EPRs for the service " + serviceName));
        }
        if ((acceptor = (SocketAcceptor)this.acceptorStore.get(serviceName)) != null) {
            return FIXUtils.generateEPRs(acceptor, serviceName, ip);
        }
        return null;
    }

    public Acceptor getAccepter(String serviceName) {
        return this.acceptorStore.get(serviceName);
    }

    public Initiator getInitiator(String fixEPR) {
        return this.initiatorStore.get(fixEPR);
    }

    private InputStream getFIXConfigAsStream(AxisService service, boolean acceptor) {
        InputStream fixConfigStream = null;
        Parameter fixConfigURLParam = acceptor ? service.getParameter("transport.fix.AcceptorConfigURL") : service.getParameter("transport.fix.InitiatorConfigURL");
        if (fixConfigURLParam != null) {
            String fixConfigURLValue = fixConfigURLParam.getValue().toString();
            try {
                URL url = new URL(fixConfigURLValue);
                fixConfigStream = url.openStream();
            }
            catch (MalformedURLException e) {
                this.log.error((Object)("The FIX configuration URL " + fixConfigURLValue + " is" + " malformed."), (Throwable)e);
            }
            catch (IOException e) {
                this.log.error((Object)("Error while reading from the URL " + fixConfigURLValue), (Throwable)e);
            }
        } else {
            this.log.error((Object)("FIX configuration URL is not specified for the service " + service.getName()));
        }
        return fixConfigStream;
    }

    private LogFactory getLogFactory(AxisService service, SessionSettings settings, boolean acceptor) {
        FileLogFactory logFactory = null;
        Parameter fixLogMethod = acceptor ? service.getParameter("transport.fix.AcceptorLogFactory") : service.getParameter("transport.fix.InitiatorLogFactory");
        if (fixLogMethod != null) {
            String method = fixLogMethod.getValue().toString();
            this.log.info((Object)("FIX logging method = " + method));
            if ("file".equals(method)) {
                logFactory = new FileLogFactory(settings);
            } else if ("jdbc".equals(method)) {
                logFactory = new JdbcLogFactory(settings);
            } else if ("console".equals(method)) {
                logFactory = new ScreenLogFactory();
            } else {
                this.log.warn((Object)("Invalid acceptor log method " + method + ". Using defaults."));
            }
        }
        return logFactory;
    }

    private MessageStoreFactory getMessageStoreFactory(AxisService service, SessionSettings settings, boolean acceptor) {
        MemoryStoreFactory storeFactory = new MemoryStoreFactory();
        Parameter msgLogMethod = acceptor ? service.getParameter("transport.fix.AcceptorMessageStore") : service.getParameter("transport.fix.InitiatorMessageStore");
        if (msgLogMethod != null) {
            String method = msgLogMethod.getValue().toString();
            this.log.info((Object)("FIX message logging method = " + method));
            if ("jdbc".equals(method)) {
                storeFactory = new JdbcStoreFactory(settings);
            } else if ("sleepycat".equals(method)) {
                storeFactory = new SleepycatStoreFactory(settings);
            } else if ("file".equals(method)) {
                storeFactory = new FileStoreFactory(settings);
            } else if (!"memory".equals(method)) {
                this.log.warn((Object)("Invalid message store " + method + ". Using defaults."));
            }
        }
        return storeFactory;
    }

    public Application getApplication(String fixEPR) {
        return this.applicationStore.get(fixEPR);
    }
}

