/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.fix;

import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.context.MessageContext;
import org.apache.synapse.transport.fix.FIXIncomingMessageHandler;
import org.apache.synapse.transport.fix.FIXSessionFactory;
import quickfix.Message;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.SessionNotFound;

public class FIXOutgoingMessageHandler {
    private Map<String, Integer> countersMap = new HashMap<String, Integer>();
    private Map<String, Map<Integer, Object[]>> messagesMap = new HashMap<String, Map<Integer, Object[]>>();
    private FIXSessionFactory sessionFactory;

    public void setSessionFactory(FIXSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public synchronized void sendMessage(Message message, SessionID targetSession, String sourceSession, int counter, MessageContext msgCtx, String targetEPR) throws SessionNotFound {
        if (sourceSession != null && counter != -1) {
            int expectedValue;
            if (this.countersMap.containsKey(sourceSession)) {
                expectedValue = this.countersMap.get(sourceSession);
            } else {
                this.countersMap.put(sourceSession, 1);
                this.messagesMap.put(sourceSession, new HashMap());
                expectedValue = 1;
            }
            if (expectedValue == counter) {
                this.sendToTarget(msgCtx, targetEPR, message, targetSession);
                this.countersMap.put(sourceSession, expectedValue++);
                this.sendQueuedMessages(expectedValue, sourceSession);
            } else {
                Map<Integer, Object[]> messages = this.messagesMap.get(sourceSession);
                Object[] obj = new Object[]{message, targetSession, msgCtx, targetEPR};
                messages.put(counter, obj);
                this.messagesMap.put(sourceSession, messages);
            }
        } else {
            this.sendToTarget(msgCtx, targetEPR, message, targetSession);
        }
    }

    private void sendToTarget(MessageContext msgCtx, String targetEPR, Message message, SessionID sessionID) throws SessionNotFound {
        if (msgCtx != null && targetEPR != null) {
            FIXIncomingMessageHandler messageHandler = (FIXIncomingMessageHandler)this.sessionFactory.getApplication(targetEPR);
            messageHandler.setOutgoingMessageContext(msgCtx);
        }
        Session.sendToTarget((Message)message, (SessionID)sessionID);
    }

    private void sendQueuedMessages(int expectedValue, String session) throws SessionNotFound {
        Map<Integer, Object[]> messages = this.messagesMap.get(session);
        Object[] obj = messages.get(expectedValue);
        while (obj != null) {
            Message message = (Message)obj[0];
            SessionID sessionID = (SessionID)obj[1];
            MessageContext msgCtx = null;
            String targetEPR = null;
            if (obj[2] != null) {
                msgCtx = (MessageContext)obj[2];
                targetEPR = obj[3].toString();
            }
            this.sendToTarget(msgCtx, targetEPR, message, sessionID);
            messages.remove(expectedValue);
            obj = messages.get(expectedValue++);
        }
        this.messagesMap.put(session, messages);
        this.countersMap.put(session, expectedValue);
    }

    public void cleanUpMessages(String session) {
        if (this.countersMap.containsKey(session)) {
            int expectedValue = this.countersMap.get(session);
            Map<Integer, Object[]> messages = this.messagesMap.get(session);
            while (!messages.isEmpty()) {
                Object[] obj = messages.get(expectedValue);
                if (obj != null) {
                    Message message = (Message)obj[0];
                    SessionID sessionID = (SessionID)obj[1];
                    try {
                        Session.sendToTarget((Message)message, (SessionID)sessionID);
                    }
                    catch (SessionNotFound ignore) {
                        // empty catch block
                    }
                    messages.remove(expectedValue);
                }
                ++expectedValue;
            }
            this.messagesMap.remove(session);
            this.countersMap.remove(session);
        }
    }
}

