/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.fix;

import java.util.Hashtable;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.fix.AxisFIXException;
import org.apache.synapse.transport.fix.FIXUtils;
import quickfix.SessionID;

public class FIXOutTransportInfo
implements OutTransportInfo {
    private SessionID sessionID;
    private Log log;

    public FIXOutTransportInfo(SessionID sessionID) {
        this.sessionID = sessionID;
        this.log = LogFactory.getLog(this.getClass());
    }

    public FIXOutTransportInfo(String targetEPR) {
        if (!targetEPR.startsWith("fix://")) {
            this.handleException("Invalid FIX EPR " + targetEPR + ". The EPR prefix must be " + "fix://");
        } else {
            Hashtable properties = FIXUtils.getProperties(targetEPR);
            this.sessionID = new SessionID((String)properties.get("BeginString"), (String)properties.get("SenderCompID"), (String)properties.get("SenderSubID"), (String)properties.get("SenderLocationID"), (String)properties.get("TargetCompID"), (String)properties.get("TargetSubID"), (String)properties.get("TargetLocationID"), (String)properties.get("SessionQualifier"));
            this.log = LogFactory.getLog(this.getClass());
        }
    }

    public SessionID getSessionID() {
        return this.sessionID;
    }

    public void setContentType(String s) {
    }

    private void handleException(String s) {
        this.log.error((Object)s);
        throw new AxisFIXException(s);
    }
}

