/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.fix;

import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.base.AbstractTransportListener;
import org.apache.synapse.transport.base.AbstractTransportSender;
import org.apache.synapse.transport.base.BaseConstants;
import org.apache.synapse.transport.base.BaseUtils;
import org.apache.synapse.transport.base.threads.WorkerPool;
import org.apache.synapse.transport.fix.AxisFIXException;
import org.apache.synapse.transport.fix.FIXOutTransportInfo;
import org.apache.synapse.transport.fix.FIXTransportSender;
import org.apache.synapse.transport.fix.FIXUtils;
import quickfix.Application;
import quickfix.DoNotSend;
import quickfix.FieldNotFound;
import quickfix.IncorrectDataFormat;
import quickfix.IncorrectTagValue;
import quickfix.IntField;
import quickfix.Message;
import quickfix.RejectLogon;
import quickfix.SessionID;
import quickfix.StringField;
import quickfix.UnsupportedMessageType;
import quickfix.field.MsgSeqNum;
import quickfix.field.MsgType;
import quickfix.field.SenderCompID;
import quickfix.field.TargetCompID;

public class FIXIncomingMessageHandler
implements Application {
    private ConfigurationContext cfgCtx;
    private WorkerPool workerPool;
    private AxisService service;
    private Log log;
    private boolean acceptor;
    private Map<SessionID, Integer> countersMap;
    private Queue<MessageContext> outgoingMessages;
    private boolean allNewApproach;
    private Semaphore semaphore;

    public FIXIncomingMessageHandler(ConfigurationContext cfgCtx, WorkerPool workerPool, AxisService service, boolean acceptor) {
        this.cfgCtx = cfgCtx;
        this.workerPool = workerPool;
        this.service = service;
        this.log = LogFactory.getLog(this.getClass());
        this.acceptor = acceptor;
        this.countersMap = new HashMap<SessionID, Integer>();
        this.outgoingMessages = new LinkedBlockingQueue<MessageContext>();
        this.semaphore = new Semaphore(0);
        this.getResponseHandlingApproach();
    }

    private void getResponseHandlingApproach() {
        Parameter param = this.service.getParameter("transport.fix.SendAllToInSequence");
        if (param != null && "false".equals(param.getValue().toString())) {
            this.allNewApproach = false;
            return;
        }
        this.allNewApproach = true;
    }

    public void setOutgoingMessageContext(MessageContext msgCtx) {
        if (!this.allNewApproach) {
            this.outgoingMessages.offer(msgCtx);
        }
    }

    public void acquire() throws InterruptedException {
        this.semaphore.acquire();
    }

    private void handleException(String msg, Exception e) {
        this.log.error((Object)msg, (Throwable)e);
        throw new AxisFIXException(msg, e);
    }

    public void onCreate(SessionID sessionID) {
        this.log.info((Object)("New FIX session created: " + sessionID.toString()));
    }

    public void onLogon(SessionID sessionID) {
        this.countersMap.put(sessionID, 0);
        this.log.info((Object)("FIX session logged on: " + sessionID.toString()));
        this.semaphore.release();
    }

    public void onLogout(SessionID sessionID) {
        this.countersMap.put(sessionID, 0);
        FIXTransportSender trpSender = (FIXTransportSender)this.cfgCtx.getAxisConfiguration().getTransportOut("fix").getSender();
        trpSender.logOutIncomingSession(sessionID);
        this.log.info((Object)("FIX session logged out: " + sessionID.toString()));
    }

    public void toAdmin(Message message, SessionID sessionID) {
        if (this.log.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            try {
                sb.append("Sending admin level FIX message to ").append(message.getHeader().getField((StringField)new TargetCompID()).getValue());
                sb.append("\nMessage Type: ").append(message.getHeader().getField((StringField)new MsgType()).getValue());
                sb.append("\nMessage Sequence Number: ").append(message.getHeader().getField((IntField)new MsgSeqNum()).getValue());
                sb.append("\nSender ID: ").append(message.getHeader().getField((StringField)new SenderCompID()).getValue());
            }
            catch (FieldNotFound e) {
                sb.append("Sending admin level FIX message...");
                this.log.warn((Object)"One or more required fields are not found in the response message", (Throwable)e);
            }
            this.log.debug((Object)sb.toString());
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Message: " + message.toString()));
            }
        }
    }

    public void fromAdmin(Message message, SessionID sessionID) throws FieldNotFound, IncorrectDataFormat, IncorrectTagValue, RejectLogon {
        if (this.log.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("Received admin level FIX message from ").append(message.getHeader().getField((StringField)new SenderCompID()).getValue());
            sb.append("\nMessage Type: ").append(message.getHeader().getField((StringField)new MsgType()).getValue());
            sb.append("\nMessage Sequence Number: ").append(message.getHeader().getField((IntField)new MsgSeqNum()).getValue());
            sb.append("\nReceiver ID: ").append(message.getHeader().getField((StringField)new TargetCompID()).getValue());
            this.log.debug((Object)sb.toString());
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Message: " + message.toString()));
            }
        }
    }

    public void toApp(Message message, SessionID sessionID) throws DoNotSend {
        if (this.log.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            try {
                sb.append("Sending application level FIX message to ").append(message.getHeader().getField((StringField)new TargetCompID()).getValue());
                sb.append("\nMessage Type: ").append(message.getHeader().getField((StringField)new MsgType()).getValue());
                sb.append("\nMessage Sequence Number: ").append(message.getHeader().getField((IntField)new MsgSeqNum()).getValue());
                sb.append("\nSender ID: ").append(message.getHeader().getField((StringField)new SenderCompID()).getValue());
            }
            catch (FieldNotFound e) {
                sb.append("Sending application level FIX message...");
                this.log.warn((Object)"One or more required fields are not found in the response message", (Throwable)e);
            }
            this.log.debug((Object)sb.toString());
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Message: " + message.toString()));
            }
        }
    }

    public void fromApp(Message message, SessionID sessionID) throws FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType {
        if (this.log.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("Received FIX message from ").append(message.getHeader().getField((StringField)new SenderCompID()).getValue());
            sb.append("\nMessage Sequence Number: ").append(message.getHeader().getField((IntField)new MsgSeqNum()).getValue());
            sb.append("\nReceiver ID: ").append(message.getHeader().getField((StringField)new TargetCompID()).getValue());
            this.log.debug((Object)sb.toString());
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Message: " + message.toString()));
            }
        }
        int counter = this.countersMap.get(sessionID);
        this.countersMap.put(sessionID, ++counter);
        this.workerPool.execute(new FIXWorkerThread(message, sessionID, counter));
    }

    class FIXWorkerThread
    implements Runnable {
        private Message message;
        private SessionID sessionID;
        private int counter;

        public FIXWorkerThread(Message message, SessionID sessionID, int counter) {
            this.message = message;
            this.sessionID = sessionID;
            this.counter = counter;
        }

        private void handleIncomingRequest() {
            AbstractTransportListener trpListener = (AbstractTransportListener)FIXIncomingMessageHandler.this.cfgCtx.getAxisConfiguration().getTransportIn("fix").getReceiver();
            MessageContext msgCtx = trpListener.createMessageContext();
            msgCtx.setProperty("OutTransportInfo", (Object)new FIXOutTransportInfo(this.sessionID));
            if (FIXIncomingMessageHandler.this.service != null) {
                msgCtx.setAxisService(FIXIncomingMessageHandler.this.service);
                Parameter operationParam = FIXIncomingMessageHandler.this.service.getParameter("Operation");
                QName operationQName = operationParam != null ? BaseUtils.getQNameFromString(operationParam.getValue()) : BaseConstants.DEFAULT_OPERATION;
                AxisOperation operation = FIXIncomingMessageHandler.this.service.getOperation(operationQName);
                if (operation != null) {
                    msgCtx.setAxisOperation(operation);
                    msgCtx.setSoapAction("urn:" + operation.getName().getLocalPart());
                }
            }
            String fixApplication = "initiator";
            if (FIXIncomingMessageHandler.this.acceptor) {
                fixApplication = "acceptor";
            } else {
                msgCtx.setProperty("synapse.isresponse", (Object)true);
            }
            try {
                FIXUtils.getInstance().setSOAPEnvelope(this.message, this.counter, this.sessionID.toString(), msgCtx);
                trpListener.handleIncomingMessage(msgCtx, FIXUtils.getTransportHeaders(FIXIncomingMessageHandler.this.service.getName(), fixApplication), null, "text/xml");
            }
            catch (AxisFault e) {
                FIXIncomingMessageHandler.this.handleException("Error while processing FIX message", (Exception)((Object)e));
            }
        }

        private void handleIncomingResponse(MessageContext outMsgCtx) {
            AbstractTransportSender trpSender = (AbstractTransportSender)FIXIncomingMessageHandler.this.cfgCtx.getAxisConfiguration().getTransportOut("fix").getSender();
            MessageContext msgCtx = trpSender.createResponseMessageContext(outMsgCtx);
            try {
                FIXUtils.getInstance().setSOAPEnvelope(this.message, this.counter, this.sessionID.toString(), msgCtx);
                msgCtx.setServerSide(true);
                trpSender.handleIncomingMessage(msgCtx, FIXUtils.getTransportHeaders(FIXIncomingMessageHandler.this.service.getName(), "initiator"), null, "text/xml");
            }
            catch (AxisFault e) {
                FIXIncomingMessageHandler.this.handleException("Error while processing response FIX message", (Exception)((Object)e));
            }
        }

        public void run() {
            if (FIXIncomingMessageHandler.this.allNewApproach) {
                this.handleIncomingRequest();
            } else if (FIXIncomingMessageHandler.this.acceptor) {
                this.handleIncomingRequest();
            } else {
                MessageContext outMsgCtx = (MessageContext)FIXIncomingMessageHandler.this.outgoingMessages.poll();
                if (outMsgCtx != null) {
                    this.handleIncomingResponse(outMsgCtx);
                } else {
                    this.handleIncomingRequest();
                }
            }
        }
    }
}

