/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.base;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.format.BinaryFormatter;
import org.apache.synapse.format.PlainTextFormatter;
import org.apache.synapse.transport.base.BaseConstants;
import org.apache.synapse.transport.base.BaseTransportException;
import org.apache.synapse.transport.vfs.PollTableEntry;

public abstract class BaseUtils {
    private static final Log log = LogFactory.getLog(BaseUtils.class);

    public static QName getQNameFromString(Object obj) {
        if (obj instanceof QName) {
            return (QName)obj;
        }
        String value = obj.toString();
        int open = value.indexOf(123);
        int close = value.indexOf(125);
        if (close > open && open > -1 && value.length() > close) {
            return new QName(value.substring(open + 1, close - open), value.substring(close + 1));
        }
        return new QName(value);
    }

    public static void markServiceAsFaulty(String serviceName, String msg, AxisConfiguration axisCfg) {
        if (serviceName != null) {
            try {
                AxisService service = axisCfg.getService(serviceName);
                axisCfg.getFaultyServices().put(service.getName(), msg);
            }
            catch (AxisFault axisFault) {
                log.warn((Object)("Error marking service : " + serviceName + " as faulty"), (Throwable)axisFault);
            }
        }
    }

    public static SOAPEnvelope getEnvelope(InputStream in, String namespace) throws XMLStreamException {
        try {
            in.reset();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        XMLStreamReader xmlreader = StAXUtils.createXMLStreamReader((InputStream)in, (String)"UTF-8");
        StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(xmlreader, namespace);
        return (SOAPEnvelope)builder.getDocumentElement();
    }

    public static OMOutputFormat getOMOutputFormat(MessageContext msgContext) {
        OMOutputFormat format = new OMOutputFormat();
        msgContext.setDoingMTOM(HTTPTransportUtils.doWriteMTOM((MessageContext)msgContext));
        msgContext.setDoingSwA(HTTPTransportUtils.doWriteSwA((MessageContext)msgContext));
        msgContext.setDoingREST(HTTPTransportUtils.isDoingREST((MessageContext)msgContext));
        format.setSOAP11(msgContext.isSOAP11());
        format.setDoOptimize(msgContext.isDoingMTOM());
        format.setDoingSWA(msgContext.isDoingSwA());
        format.setCharSetEncoding(HTTPTransportUtils.getCharSetEncoding((MessageContext)msgContext));
        Object mimeBoundaryProperty = msgContext.getProperty("mimeBoundary");
        if (mimeBoundaryProperty != null) {
            format.setMimeBoundary((String)mimeBoundaryProperty);
        }
        return format;
    }

    public static MessageFormatter getMessageFormatter(MessageContext msgContext) {
        OMElement firstChild = msgContext.getEnvelope().getBody().getFirstElement();
        if (firstChild != null) {
            if (BaseConstants.DEFAULT_BINARY_WRAPPER.equals(firstChild.getQName())) {
                return new BinaryFormatter();
            }
            if (BaseConstants.DEFAULT_TEXT_WRAPPER.equals(firstChild.getQName())) {
                return new PlainTextFormatter();
            }
        }
        try {
            return TransportUtils.getMessageFormatter((MessageContext)msgContext);
        }
        catch (AxisFault axisFault) {
            throw new BaseTransportException("Unable to get the message formatter to use");
        }
    }

    public static long getMinPollTime(List pollTable) {
        Iterator iter = pollTable.iterator();
        long min = 300L;
        while (iter.hasNext()) {
            PollTableEntry entry = (PollTableEntry)iter.next();
            if (entry.getPollInterval() >= min) continue;
            min = entry.getPollInterval();
        }
        return min;
    }

    public void setSOAPEnvelope(Object message, MessageContext msgContext, String contentType) throws AxisFault {
        String charEncOfMessage;
        SOAPEnvelope envelope = null;
        StAXBuilder builder = null;
        String charSetEnc = null;
        try {
            if (contentType != null) {
                charSetEnc = new ContentType(contentType).getParameter("charset");
            }
        }
        catch (ParseException ex) {
            // empty catch block
        }
        InputStream in = this.getInputStream(message);
        try {
            if (contentType != null) {
                if (contentType.indexOf("multipart/related") > -1) {
                    builder = BuilderUtil.getAttachmentsBuilder((MessageContext)msgContext, (InputStream)in, (String)contentType, (boolean)true);
                    envelope = (SOAPEnvelope)builder.getDocumentElement();
                } else {
                    builder = BuilderUtil.getSOAPBuilder((InputStream)in, (String)charSetEnc);
                    envelope = (SOAPEnvelope)builder.getDocumentElement();
                }
            }
        }
        catch (Exception ignore) {
            try {
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            in = this.getInputStream(message);
        }
        if (builder == null) {
            SOAP11Factory soapFactory = new SOAP11Factory();
            try {
                builder = new StAXOMBuilder(StAXUtils.createXMLStreamReader((InputStream)in, (String)charSetEnc));
                builder.setOMBuilderFactory(OMAbstractFactory.getOMFactory());
                String ns = builder.getDocumentElement().getNamespace().getNamespaceURI();
                if ("http://www.w3.org/2003/05/soap-envelope".equals(ns)) {
                    envelope = BaseUtils.getEnvelope(in, "http://www.w3.org/2003/05/soap-envelope");
                } else if ("http://schemas.xmlsoap.org/soap/envelope/".equals(ns)) {
                    envelope = BaseUtils.getEnvelope(in, "http://schemas.xmlsoap.org/soap/envelope/");
                } else {
                    msgContext.setDoingREST(true);
                    envelope = soapFactory.getDefaultEnvelope();
                    envelope.getBody().addChild((OMNode)builder.getDocumentElement());
                }
            }
            catch (Exception e) {
                envelope = this.handleLegacyMessage(msgContext, message);
            }
        }
        msgContext.setProperty("CHARACTER_SET_ENCODING", (Object)charSetEnc);
        String string = builder == null ? null : (charEncOfMessage = builder.getDocument() == null ? null : builder.getDocument().getCharsetEncoding());
        if (StringUtils.isNotBlank(charEncOfMessage) && StringUtils.isNotBlank((String)charSetEnc) && !charEncOfMessage.equalsIgnoreCase(charSetEnc)) {
            BaseUtils.handleException("Charset encoding of transport differs from that of the payload");
        }
        msgContext.setEnvelope(envelope);
    }

    private SOAPEnvelope handleLegacyMessage(MessageContext msgContext, Object message) {
        String textPayload;
        SOAP11Factory soapFactory = new SOAP11Factory();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Non SOAP/XML message received");
        }
        Parameter wrapperParam = msgContext.getAxisService().getParameter("Wrapper");
        QName wrapperQName = null;
        OMElement wrapper = null;
        if (wrapperParam != null) {
            wrapperQName = BaseUtils.getQNameFromString(wrapperParam.getValue());
        }
        if ((textPayload = this.getMessageTextPayload(message)) != null) {
            OMTextImpl textData = (OMTextImpl)soapFactory.createOMText(textPayload);
            if (wrapperQName == null) {
                wrapperQName = BaseConstants.DEFAULT_TEXT_WRAPPER;
            }
            wrapper = soapFactory.createOMElement(wrapperQName, null);
            wrapper.addChild((OMNode)textData);
        } else {
            byte[] msgBytes = this.getMessageBinaryPayload(message);
            if (msgBytes != null) {
                DataHandler dataHandler = new DataHandler((DataSource)new ByteArrayDataSource(msgBytes));
                OMText textData = soapFactory.createOMText((Object)dataHandler, true);
                if (wrapperQName == null) {
                    wrapperQName = BaseConstants.DEFAULT_BINARY_WRAPPER;
                }
                wrapper = soapFactory.createOMElement(wrapperQName, null);
                wrapper.addChild((OMNode)textData);
                msgContext.setDoingMTOM(true);
            } else {
                BaseUtils.handleException("Unable to read payload from message of type : " + message.getClass().getName());
            }
        }
        SOAPEnvelope envelope = soapFactory.getDefaultEnvelope();
        envelope.getBody().addChild((OMNode)wrapper);
        return envelope;
    }

    public abstract String getProperty(Object var1, String var2);

    public abstract InputStream getInputStream(Object var1);

    public abstract String getMessageTextPayload(Object var1);

    public abstract byte[] getMessageBinaryPayload(Object var1);

    protected static void handleException(String s) {
        log.error((Object)s);
        throw new BaseTransportException(s);
    }

    protected static void handleException(String s, Exception e) {
        log.error((Object)s, (Throwable)e);
        throw new BaseTransportException(s, e);
    }

    public static boolean isValid(String str) {
        return str != null && str.trim().length() > 0;
    }

    public static String getRequiredServiceParam(AxisService service, String paramName) throws AxisFault {
        Parameter param = service.getParameter(paramName);
        if (param != null && param.getValue() != null && param.getValue() instanceof String) {
            return (String)param.getValue();
        }
        throw new AxisFault("Cannot find parameter : " + paramName + " for service : " + service.getName());
    }

    public static String getOptionalServiceParam(AxisService service, String paramName) throws AxisFault {
        Parameter param = service.getParameter(paramName);
        if (param != null && param.getValue() != null && param.getValue() instanceof String) {
            return (String)param.getValue();
        }
        return null;
    }

    public static boolean isUsingTransport(AxisService service, String transportName) {
        boolean process = service.isEnableAllTransports();
        if (process) {
            return true;
        }
        List transports = service.getExposedTransports();
        for (Object transport : transports) {
            if (!transportName.equals(transport)) continue;
            return true;
        }
        return false;
    }
}

