/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.base;

import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.synapse.transport.base.MetricsCollector;
import org.apache.synapse.transport.base.TransportView;

public abstract class AbstractTransportSender
extends AbstractHandler
implements TransportSender {
    protected Log log = null;
    protected String transportName = null;
    protected ConfigurationContext cfgCtx = null;
    protected AxisEngine engine = null;
    private TransportInDescription transportIn = null;
    private TransportOutDescription transportOut = null;
    protected MetricsCollector metrics = new MetricsCollector();
    private int state = 0;

    public void init(ConfigurationContext cfgCtx, TransportOutDescription transportOut) throws AxisFault {
        this.cfgCtx = cfgCtx;
        this.engine = new AxisEngine(cfgCtx);
        this.transportIn = cfgCtx.getAxisConfiguration().getTransportIn(this.transportName);
        this.transportOut = transportOut;
        this.state = 1;
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        String jmxAgentName = System.getProperty("jmx.agent.name");
        if (jmxAgentName == null || "".equals(jmxAgentName)) {
            jmxAgentName = "org.apache.synapse";
        }
        try {
            String name = jmxAgentName + ":Type=Transport,ConnectorName=" + this.transportName + "-sender";
            TransportView tBean = new TransportView(null, this);
            this.registerMBean(mbs, tBean, name);
        }
        catch (Exception e) {
            this.log.warn((Object)("Error registering the " + this.transportName + " transport for JMX management"), (Throwable)e);
        }
        this.log.info((Object)(this.transportName.toUpperCase() + " Sender started"));
    }

    public void stop() {
        if (this.state != 1) {
            return;
        }
        this.state = 0;
        this.log.info((Object)(this.transportName.toUpperCase() + " Sender Shutdown"));
    }

    public void cleanup(MessageContext msgContext) throws AxisFault {
    }

    public abstract void sendMessage(MessageContext var1, String var2, OutTransportInfo var3) throws AxisFault;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        String targetAddress = (String)msgContext.getProperty("TransportURL");
        if (targetAddress != null) {
            this.sendMessage(msgContext, targetAddress, null);
            return Handler.InvocationResponse.CONTINUE;
        } else if (msgContext.getTo() != null && !msgContext.getTo().hasAnonymousAddress()) {
            targetAddress = msgContext.getTo().getAddress();
            if (msgContext.getTo().hasNoneAddress()) return Handler.InvocationResponse.CONTINUE;
            this.sendMessage(msgContext, targetAddress, null);
            return Handler.InvocationResponse.CONTINUE;
        } else {
            if (!msgContext.isServerSide()) return Handler.InvocationResponse.CONTINUE;
            this.sendMessage(msgContext, null, (OutTransportInfo)msgContext.getProperty("OutTransportInfo"));
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    public void handleIncomingMessage(MessageContext msgCtx, Map trpHeaders, String soapAction, String contentType) {
        if (soapAction != null) {
            msgCtx.setSoapAction(soapAction);
        }
        msgCtx.setProperty("TRANSPORT_HEADERS", (Object)trpHeaders);
        try {
            try {
                AxisEngine.receive((MessageContext)msgCtx);
            }
            catch (AxisFault e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Error receiving message", (Throwable)e);
                }
                if (msgCtx.isServerSide()) {
                    AxisEngine.sendFault((MessageContext)MessageContextBuilder.createFaultMessageContext((MessageContext)msgCtx, (Throwable)e));
                }
            }
        }
        catch (AxisFault axisFault) {
            this.logException("Error processing response message", (Exception)((Object)axisFault));
        }
    }

    public MessageContext createResponseMessageContext(MessageContext outMsgCtx) {
        MessageContext responseMsgCtx = null;
        try {
            responseMsgCtx = outMsgCtx.getOperationContext().getMessageContext("In");
        }
        catch (AxisFault af) {
            this.log.error((Object)"Error getting IN message context from the operation context", (Throwable)af);
        }
        if (responseMsgCtx == null) {
            responseMsgCtx = new MessageContext();
            responseMsgCtx.setOperationContext(outMsgCtx.getOperationContext());
        }
        responseMsgCtx.setIncomingTransportName(this.transportName);
        responseMsgCtx.setTransportOut(this.transportOut);
        responseMsgCtx.setTransportIn(this.transportIn);
        responseMsgCtx.setMessageID(UUIDGenerator.getUUID());
        responseMsgCtx.setDoingREST(outMsgCtx.isDoingREST());
        responseMsgCtx.setProperty("TRANSPORT_IN", outMsgCtx.getProperty("TRANSPORT_IN"));
        responseMsgCtx.setAxisMessage(outMsgCtx.getOperationContext().getAxisOperation().getMessage("In"));
        responseMsgCtx.setTo(null);
        return responseMsgCtx;
    }

    protected boolean waitForSynchronousResponse(MessageContext msgCtx) {
        return msgCtx.getOperationContext() != null && "http://www.w3.org/ns/wsdl/out-in".equals(msgCtx.getOperationContext().getAxisOperation().getMessageExchangePattern());
    }

    public String getTransportName() {
        return this.transportName;
    }

    public void setTransportName(String transportName) {
        this.transportName = transportName;
    }

    protected void handleException(String msg, Exception e) throws AxisFault {
        this.log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    protected void handleException(String msg) throws AxisFault {
        this.log.error((Object)msg);
        throw new AxisFault(msg);
    }

    protected void logException(String msg, Exception e) {
        this.log.error((Object)msg, (Throwable)e);
    }

    public void pause() throws AxisFault {
        if (this.state != 1) {
            return;
        }
        this.state = 2;
        this.log.info((Object)"Sender paused");
    }

    public void resume() throws AxisFault {
        if (this.state != 2) {
            return;
        }
        this.state = 1;
        this.log.info((Object)"Sender resumed");
    }

    public void maintenenceShutdown(long millis) throws AxisFault {
        if (this.state != 1) {
            return;
        }
        long start = System.currentTimeMillis();
        this.stop();
        this.state = 0;
        this.log.info((Object)("Sender shutdown in : " + (System.currentTimeMillis() - start) / 1000L + "s"));
    }

    public int getActiveThreadCount() {
        return 0;
    }

    public int getQueueSize() {
        return 0;
    }

    public long getMessagesReceived() {
        if (this.metrics != null) {
            return this.metrics.getMessagesReceived();
        }
        return -1L;
    }

    public long getFaultsReceiving() {
        if (this.metrics != null) {
            return this.metrics.getFaultsReceiving();
        }
        return -1L;
    }

    public long getBytesReceived() {
        if (this.metrics != null) {
            return this.metrics.getBytesReceived();
        }
        return -1L;
    }

    public long getMessagesSent() {
        if (this.metrics != null) {
            return this.metrics.getMessagesSent();
        }
        return -1L;
    }

    public long getFaultsSending() {
        if (this.metrics != null) {
            return this.metrics.getFaultsSending();
        }
        return -1L;
    }

    public long getBytesSent() {
        if (this.metrics != null) {
            return this.metrics.getBytesSent();
        }
        return -1L;
    }

    private void registerMBean(MBeanServer mbs, Object mbeanInstance, String objectName) {
        try {
            ObjectName name = new ObjectName(objectName);
            Set<ObjectName> set = mbs.queryNames(name, null);
            if (set != null && set.isEmpty()) {
                mbs.registerMBean(mbeanInstance, name);
            } else {
                mbs.unregisterMBean(name);
                mbs.registerMBean(mbeanInstance, name);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Error registering a MBean with objectname ' " + objectName + " ' for JMX management"), (Throwable)e);
        }
    }
}

