/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.base;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.engine.AxisObserver;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.base.BaseUtils;
import org.apache.synapse.transport.base.MetricsCollector;
import org.apache.synapse.transport.base.TransportListenerEndpointView;
import org.apache.synapse.transport.base.TransportView;
import org.apache.synapse.transport.base.threads.WorkerPool;
import org.apache.synapse.transport.base.threads.WorkerPoolFactory;

public abstract class AbstractTransportListener
implements TransportListener {
    protected Log log = null;
    protected String transportName = null;
    protected ConfigurationContext cfgCtx = null;
    protected AxisEngine engine = null;
    private TransportInDescription transportIn = null;
    private TransportOutDescription transportOut = null;
    protected int state = 0;
    protected boolean isNonBlocking = false;
    private final AxisObserver axisObserver = new GenericAxisObserver();
    protected WorkerPool workerPool = null;
    protected boolean useAxis2ThreadPool = false;
    protected MetricsCollector metrics = new MetricsCollector();

    protected AbstractTransportListener() {
        this.log = LogFactory.getLog(this.getClass());
    }

    public void init(ConfigurationContext cfgCtx, TransportInDescription transportIn) throws AxisFault {
        this.cfgCtx = cfgCtx;
        this.engine = new AxisEngine(cfgCtx);
        this.transportIn = transportIn;
        this.transportOut = cfgCtx.getAxisConfiguration().getTransportOut(this.transportName);
        if (this.useAxis2ThreadPool) {
            throw new AxisFault("Unsupported thread pool for task execution - Axis2 thread pool");
        }
        this.workerPool = WorkerPoolFactory.getWorkerPool(10, 20, 5, -1, this.transportName + "Server Worker thread group", this.transportName + "-Worker");
        cfgCtx.getAxisConfiguration().addObservers(this.axisObserver);
        this.registerMBean(new TransportView(this, null), this.getMBeanName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            if (this.state == 1) {
                try {
                    this.stop();
                }
                catch (AxisFault ignore) {
                    this.log.warn((Object)("Error stopping the transport : " + this.transportName));
                }
            }
        }
        finally {
            this.state = 0;
        }
        try {
            this.workerPool.shutdown(10000);
        }
        catch (InterruptedException ex) {
            this.log.warn((Object)"Thread interrupted while waiting for worker pool to shut down");
        }
    }

    public void stop() throws AxisFault {
        if (this.state == 1) {
            this.state = 0;
            this.cfgCtx.getAxisConfiguration().getObserversList().remove(this.axisObserver);
            this.log.info((Object)(this.transportName.toUpperCase() + " Listener Shutdown"));
        }
    }

    public void start() throws AxisFault {
        if (this.state != 1) {
            this.state = 1;
        }
        this.log.info((Object)(this.transportName.toUpperCase() + " Listener started"));
        for (AxisService service : this.cfgCtx.getAxisConfiguration().getServices().values()) {
            if (!BaseUtils.isUsingTransport(service, this.transportName)) continue;
            this.internalStartListeningForService(service);
        }
    }

    public void disableTransportForService(AxisService service) {
        this.log.warn((Object)("Disabling the " + this.getTransportName() + " transport for the service " + service.getName() + ", because it is not configured properly for the service"));
        if (service.isEnableAllTransports()) {
            ArrayList<String> exposedTransports = new ArrayList<String>();
            for (Object obj : this.cfgCtx.getAxisConfiguration().getTransportsIn().values()) {
                String transportName = ((TransportInDescription)obj).getName();
                if (transportName.equals(this.getTransportName())) continue;
                exposedTransports.add(transportName);
            }
            service.setExposedTransports(exposedTransports);
        } else {
            service.removeExposedTransport(this.getTransportName());
        }
    }

    private void internalStartListeningForService(AxisService service) {
        this.startListeningForService(service);
        String serviceName = service.getName();
        this.registerMBean(new TransportListenerEndpointView(this, serviceName), this.getEndpointMBeanName(serviceName));
    }

    private void internalStopListeningForService(AxisService service) {
        this.unregisterMBean(this.getEndpointMBeanName(service.getName()));
        this.stopListeningForService(service);
    }

    protected abstract void startListeningForService(AxisService var1);

    protected abstract void stopListeningForService(AxisService var1);

    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        return this.getEPRsForService(serviceName, ip)[0];
    }

    public SessionContext getSessionContext(MessageContext messageContext) {
        return null;
    }

    public MessageContext createMessageContext() {
        MessageContext msgCtx = new MessageContext();
        msgCtx.setConfigurationContext(this.cfgCtx);
        msgCtx.setIncomingTransportName(this.transportName);
        msgCtx.setTransportOut(this.transportOut);
        msgCtx.setTransportIn(this.transportIn);
        msgCtx.setServerSide(true);
        msgCtx.setMessageID(UUIDGenerator.getUUID());
        msgCtx.setProperty("transportNonBlocking", (Object)(!this.isNonBlocking ? 1 : 0));
        return msgCtx;
    }

    public void handleIncomingMessage(MessageContext msgCtx, Map trpHeaders, String soapAction, String contentType) throws AxisFault {
        if (soapAction != null) {
            msgCtx.setSoapAction(soapAction);
        }
        msgCtx.setProperty("TRANSPORT_HEADERS", (Object)trpHeaders);
        try {
            try {
                AxisEngine.receive((MessageContext)msgCtx);
            }
            catch (AxisFault e) {
                e.printStackTrace();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Error receiving message", (Throwable)e);
                }
                if (msgCtx.isServerSide()) {
                    AxisEngine.sendFault((MessageContext)MessageContextBuilder.createFaultMessageContext((MessageContext)msgCtx, (Throwable)e));
                }
            }
        }
        catch (AxisFault axisFault) {
            this.logException("Error processing received message", (Exception)((Object)axisFault));
            throw axisFault;
        }
    }

    protected void handleException(String msg, Exception e) throws AxisFault {
        this.log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    protected void logException(String msg, Exception e) {
        this.log.error((Object)msg, (Throwable)e);
    }

    public String getTransportName() {
        return this.transportName;
    }

    public void setTransportName(String transportName) {
        this.transportName = transportName;
    }

    public MetricsCollector getMetricsCollector() {
        return this.metrics;
    }

    public void pause() throws AxisFault {
    }

    public void resume() throws AxisFault {
    }

    public void maintenenceShutdown(long millis) throws AxisFault {
    }

    public int getActiveThreadCount() {
        return this.workerPool.getActiveCount();
    }

    public int getQueueSize() {
        return this.workerPool.getQueueSize();
    }

    public long getMessagesReceived() {
        if (this.metrics != null) {
            return this.metrics.getMessagesReceived();
        }
        return -1L;
    }

    public long getFaultsReceiving() {
        if (this.metrics != null) {
            return this.metrics.getFaultsReceiving();
        }
        return -1L;
    }

    public long getBytesReceived() {
        if (this.metrics != null) {
            return this.metrics.getBytesReceived();
        }
        return -1L;
    }

    public long getMessagesSent() {
        if (this.metrics != null) {
            return this.metrics.getMessagesSent();
        }
        return -1L;
    }

    public long getFaultsSending() {
        if (this.metrics != null) {
            return this.metrics.getFaultsSending();
        }
        return -1L;
    }

    public long getBytesSent() {
        if (this.metrics != null) {
            return this.metrics.getBytesSent();
        }
        return -1L;
    }

    private String getMBeanName() {
        String jmxAgentName = System.getProperty("jmx.agent.name");
        if (jmxAgentName == null || "".equals(jmxAgentName)) {
            jmxAgentName = "org.apache.synapse";
        }
        return jmxAgentName + ":Type=Transport,ConnectorName=" + this.transportName + "-listener";
    }

    private String getEndpointMBeanName(String serviceName) {
        return this.getMBeanName() + ",Group=Services,Service=" + serviceName;
    }

    private void registerMBean(Object mbeanInstance, String objectName) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = new ObjectName(objectName);
            Set<ObjectName> set = mbs.queryNames(name, null);
            if (set != null && set.isEmpty()) {
                mbs.registerMBean(mbeanInstance, name);
            } else {
                mbs.unregisterMBean(name);
                mbs.registerMBean(mbeanInstance, name);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Error registering a MBean with objectname ' " + objectName + " ' for JMX management"), (Throwable)e);
        }
    }

    private void unregisterMBean(String objectName) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName objName = new ObjectName(objectName);
            if (mbs.isRegistered(objName)) {
                mbs.unregisterMBean(objName);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Error un-registering a MBean with objectname ' " + objectName + " ' for JMX management"), (Throwable)e);
        }
    }

    class GenericAxisObserver
    implements AxisObserver {
        GenericAxisObserver() {
        }

        public void init(AxisConfiguration axisConfig) {
        }

        public void serviceUpdate(AxisEvent event, AxisService service) {
            if (service.getName().startsWith("__")) {
                return;
            }
            if (BaseUtils.isUsingTransport(service, AbstractTransportListener.this.transportName)) {
                switch (event.getEventType()) {
                    case 1: {
                        AbstractTransportListener.this.internalStartListeningForService(service);
                        break;
                    }
                    case 0: {
                        AbstractTransportListener.this.internalStopListeningForService(service);
                        break;
                    }
                    case 3: {
                        AbstractTransportListener.this.internalStartListeningForService(service);
                        break;
                    }
                    case 2: {
                        AbstractTransportListener.this.internalStopListeningForService(service);
                    }
                }
            }
        }

        public void moduleUpdate(AxisEvent event, AxisModule module) {
        }

        public void addParameter(Parameter param) throws AxisFault {
        }

        public void removeParameter(Parameter param) throws AxisFault {
        }

        public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        }

        public Parameter getParameter(String name) {
            return null;
        }

        public ArrayList getParameters() {
            return null;
        }

        public boolean isParameterLocked(String parameterName) {
            return false;
        }

        public void serviceGroupUpdate(AxisEvent event, AxisServiceGroup serviceGroup) {
        }
    }
}

